/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage.styler.ui;

import java.awt.AWTError;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.openjump.core.rasterimage.styler.I18N;

public class ColorEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private Component parent;
    private Color currentColor;
    private JButton button;
    private JColorChooser colorChooser;
    private JDialog jDialog_ColorPicker;
    private JCheckBox jCheckBox_Transparent;
    protected static final String EDIT = I18N.get("org.openjump.core.rasterimage.styler.ui.ColorEditor.edit");

    public ColorEditor(Component parent) {
        this.parent = parent;
        this.fixComponents();
    }

    private void fixComponents() {
        this.button = new JButton();
        this.button.setActionCommand(EDIT);
        this.button.addActionListener(this);
        this.button.setBorderPainted(false);
        this.button.setFocusPainted(false);
        this.button.setContentAreaFilled(false);
        this.colorChooser = new JColorChooser();
        if (this.parent == null) {
            throw new AWTError("No suitable parent found for Component.");
        }
        if (this.parent instanceof Dialog) {
            this.jDialog_ColorPicker = new JDialog((Dialog)this.parent, I18N.get("org.openjump.core.rasterimage.styler.ui.ColorEditor.PickAColor"));
        } else if (this.parent instanceof Frame) {
            this.jDialog_ColorPicker = new JDialog((Frame)this.parent, I18N.get("org.openjump.core.rasterimage.styler.ui.ColorEditor.PickAColor"));
        }
        this.jDialog_ColorPicker.setLocationRelativeTo(this.parent);
        this.jDialog_ColorPicker.setSize(500, 500);
        this.jDialog_ColorPicker.setModal(true);
        this.jDialog_ColorPicker.getContentPane().setLayout(new BorderLayout());
        this.colorChooser = new JColorChooser();
        this.jDialog_ColorPicker.getContentPane().add((Component)this.colorChooser, "North");
        this.jCheckBox_Transparent = new JCheckBox(I18N.get("org.openjump.core.rasterimage.styler.ui.ColorEditor.Transparent"));
        this.jDialog_ColorPicker.getContentPane().add((Component)this.jCheckBox_Transparent, "Center");
        JButton jButton_Cancel = new JButton(I18N.get("org.openjump.core.rasterimage.styler.ui.ColorEditor.Cancel"));
        jButton_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ColorEditor.this.jDialog_ColorPicker.setVisible(false);
            }
        });
        JButton jButton_Ok = new JButton(I18N.get("org.openjump.core.rasterimage.styler.ui.ColorEditor.Ok"));
        jButton_Ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ColorEditor.this.currentColor = ColorEditor.this.colorChooser.getColor();
                if (ColorEditor.this.jCheckBox_Transparent.isSelected()) {
                    ColorEditor.this.currentColor = new Color(ColorEditor.this.currentColor.getRed(), ColorEditor.this.currentColor.getGreen(), ColorEditor.this.currentColor.getBlue(), 0);
                }
                ColorEditor.this.jDialog_ColorPicker.setVisible(false);
            }
        });
        JPanel jPanel_Buttons = new JPanel(new FlowLayout());
        jPanel_Buttons.add(jButton_Cancel);
        jPanel_Buttons.add(jButton_Ok);
        this.jDialog_ColorPicker.getContentPane().add((Component)jPanel_Buttons, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (EDIT.equals(e.getActionCommand())) {
            this.button.setBackground(this.currentColor);
            this.colorChooser.setColor(this.currentColor);
            this.jDialog_ColorPicker.setVisible(true);
            this.fireEditingStopped();
        } else {
            this.currentColor = this.colorChooser.getColor();
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.currentColor;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.currentColor = (Color)value;
        return this.button;
    }
}

