/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Timer;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Disposable;
import com.vividsolutions.jump.workbench.model.GeoReferencedLayerable;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.ui.LayerNameRenderer;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.Viewport;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import javax.media.jai.JAI;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingException;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.openjump.core.rasterimage.ImageAndMetadata;
import org.openjump.core.rasterimage.Metadata;
import org.openjump.core.rasterimage.RasterImageIO;
import org.openjump.core.rasterimage.RasterSymbology;
import org.openjump.core.rasterimage.Resolution;
import org.openjump.core.rasterimage.Stats;
import org.openjump.core.rasterimage.TiffUtilsV2;
import org.openjump.util.metaData.MetaDataMap;
import org.openjump.util.metaData.ObjectContainingMetaInformation;

public final class RasterImageLayer
extends GeoReferencedLayerable
implements ObjectContainingMetaInformation,
Disposable {
    protected int lastImgProcessingMode = 0;
    protected static final int MODE_NONE = 0;
    protected static final int MODE_SCALINGFIRST = 1;
    protected static final int MODE_CLIPPINGFIRST = 2;
    protected static final int MODE_FASTDISPLAY = 3;
    protected Rectangle imagePart;
    protected Rectangle visibleRect = null;
    protected double oldScaleXImg2Canvas;
    protected int xOffset;
    protected int yOffset;
    protected double transparencyLevel = 0.0;
    protected static long availRAM = Runtime.getRuntime().maxMemory();
    protected static double freeRamFactor = 0.5;
    protected static double minRamToKeepFree = (double)availRAM * freeRamFactor;
    protected static int maxPixelsForFastDisplayMode = 250000;
    protected String imageFileName = null;
    protected int origImageWidth;
    protected int origImageHeight;
    protected boolean imageSet = false;
    protected BufferedImage image = null;
    protected int numBands = 0;
    protected boolean rasterDataChanged = false;
    protected BufferedImage scaledBufferedImage = null;
    protected Envelope actualImageEnvelope = null;
    protected Envelope visibleEnv = null;
    protected Envelope oldVisibleEnv;
    protected boolean firingAppearanceEvents = true;
    protected boolean needToKeepImage = false;
    protected Color transparentColor = null;
    protected boolean transparencyColorNeedsToBeApplied = false;
    protected double noDataValue = Double.NaN;
    protected double originalCellSize;
    protected double actualCellSize;
    private Metadata metadata;
    private int bitsPerPixel = -1;
    private Stats stats;
    private RasterSymbology symbology = null;
    private boolean symbologyChanged = false;
    private final UUID uuid = UUID.randomUUID();
    protected MetaDataMap metaInformation = null;
    private static final String NODATASOURCELAYER = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.nodatasourcelayer.message");

    public RasterImageLayer() {
        this.getBlackboard().put(LayerNameRenderer.USE_CLOCK_ANIMATION_KEY, true);
    }

    public String getXmlEnvelope() {
        return this.getEnvelope().toString();
    }

    public void setXmlEnvelope(String envStr) {
        String coords = envStr.substring(envStr.indexOf("[") + 1, envStr.indexOf("]"));
        String[] coordArray = coords.split(",");
        String[] xCoords = coordArray[0].split(":");
        String[] yCoords = coordArray[1].split(":");
        double minX = Double.parseDouble(xCoords[0]);
        double maxX = Double.parseDouble(xCoords[1]);
        double minY = Double.parseDouble(yCoords[0]);
        double maxY = Double.parseDouble(yCoords[1]);
        this.setWholeImageEnvelope(new Envelope(minX, maxX, minY, maxY));
    }

    public RasterImageLayer(String name, LayerManager layerManager, String imageFileName, BufferedImage imageToDisplay, Envelope wholeImageEnvelope) {
        super(name, layerManager);
        long avram;
        this.getBlackboard().put(LayerNameRenderer.USE_CLOCK_ANIMATION_KEY, true);
        this.imageFileName = imageFileName;
        this.setEnvelope(wholeImageEnvelope);
        if (imageToDisplay != null) {
            this.setImage(imageToDisplay);
        }
        if ((avram = RasterImageLayer.getAvailRAM()) > 256000000L) {
            maxPixelsForFastDisplayMode = 250000;
        }
        if (avram > 750000000L) {
            maxPixelsForFastDisplayMode = 4000000;
        }
    }

    public RasterImageLayer(String name, LayerManager layerManager, BufferedImage imageToDisplay, Raster newRaster, Envelope wholeImageEnvelope) {
        super(name, layerManager);
        if (imageToDisplay == null || newRaster == null) {
            Logger.warn("imageToDisplay and newRaster must not be null");
            return;
        }
        this.getBlackboard().put(LayerNameRenderer.USE_CLOCK_ANIMATION_KEY, true);
        this.setNeedToKeepImage(true);
        this.setEnvelope(wholeImageEnvelope);
        this.setImage(imageToDisplay);
        long avram = RasterImageLayer.getAvailRAM();
        if (avram > 256000000L) {
            maxPixelsForFastDisplayMode = 250000;
        }
        if (avram > 750000000L) {
            maxPixelsForFastDisplayMode = 563500;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return this.imageFileName == null ? new RasterImageLayer(this.getName(), this.getLayerManager(), this.getImage(), this.getActualRasterData(), this.getEnvelope()) : new RasterImageLayer(this.getName(), this.getLayerManager(), this.getImageFileName(), this.getImage(), this.getEnvelope());
    }

    protected BufferedImage scaleImage(BufferedImage im, float xScale, float yScale) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(im);
        pb.add(xScale);
        pb.add(yScale);
        return JAI.create((String)"Scale", (ParameterBlock)pb, null).getAsBufferedImage();
    }

    protected BufferedImage createOneColorImage(Color color) {
        BufferedImage bim = new BufferedImage(this.visibleRect.width, this.visibleRect.height, 2);
        Graphics2D grfcs = bim.createGraphics();
        grfcs.setColor(color);
        grfcs.fillRect(0, 0, bim.getWidth(), bim.getHeight());
        grfcs.dispose();
        return bim;
    }

    public BufferedImage createImage(LayerViewPanel layerViewPanel) {
        Viewport viewport = layerViewPanel.getViewport();
        if (!this.isVisible() || this.transparencyLevel >= 1.0) {
            this.setImageProcessingMode(0);
            this.clearImageAndRaster(true);
            return null;
        }
        BufferedImage imageToDraw = null;
        try {
            Point imageDims = RasterImageIO.getImageDimensions(this.imageFileName);
            assert (imageDims != null);
            this.origImageWidth = imageDims.x;
            this.origImageHeight = imageDims.y;
            this.visibleRect = viewport.getPanel().getVisibleRect();
            int visibleX1 = this.visibleRect.x;
            int visibleY1 = this.visibleRect.y;
            int visibleX2 = visibleX1 + this.visibleRect.width;
            int visibleY2 = visibleY1 + this.visibleRect.height;
            Coordinate upperLeftVisible = viewport.toModelCoordinate(new Point(visibleX1, visibleY1));
            Coordinate lowerRightVisible = viewport.toModelCoordinate(new Point(visibleX2, visibleY2));
            Envelope newVisibleEnv = new Envelope(upperLeftVisible, lowerRightVisible);
            this.setImageSet(false);
            if (this.visibleEnv == null || this.visibleEnv.getMinX() != newVisibleEnv.getMinX() || this.visibleEnv.getMaxX() != newVisibleEnv.getMaxX() || this.visibleEnv.getMinY() != newVisibleEnv.getMinY() || this.visibleEnv.getMaxY() != newVisibleEnv.getMaxY() || this.symbologyChanged) {
                this.visibleEnv = newVisibleEnv;
                this.symbologyChanged = false;
                this.setNeedToKeepImage(false);
                if (this.bitsPerPixel == -1) {
                    if (this.imageFileName.toLowerCase().endsWith(".flt")) {
                        this.bitsPerPixel = 16;
                    } else if (this.imageFileName.toLowerCase().endsWith(".asc")) {
                        this.bitsPerPixel = 16;
                    } else if (this.imageFileName.toLowerCase().endsWith(".txt")) {
                        this.bitsPerPixel = 16;
                    } else {
                        try {
                            this.bitsPerPixel = Imaging.getImageInfo((File)new File(this.imageFileName)).getBitsPerPixel();
                        }
                        catch (ImagingException e) {
                            Logger.warn("Can't get ImageInfo of " + this.imageFileName, e);
                        }
                    }
                }
                this.clearImageAndRaster(true);
                if ((double)(RasterImageLayer.getAvailRAM() - this.getCommittedMemory()) < (double)(this.origImageWidth * this.origImageHeight * this.bitsPerPixel) / 8.0 + (double)RasterImageLayer.getAvailRAM() * 0.01 + 1.048576E7) {
                    layerViewPanel.getContext().warnUser("Low Memory : image " + this.imageFileName + " will not be displayed");
                    System.out.println("" + (RasterImageLayer.getAvailRAM() - this.getCommittedMemory()) / 1024L + "kb < " + this.origImageWidth * this.origImageHeight * this.bitsPerPixel / 8 / 1024 + "kb " + (double)RasterImageLayer.getAvailRAM() * 0.01 / 1024.0 + "kb + 10240");
                    return null;
                }
                Logger.debug("Reload image");
                this.reLoadImage(layerViewPanel);
                if (this.image == null) {
                    return null;
                }
                Point2D upperLeftCornerOfImage = viewport.toViewPoint(new Coordinate(this.getActualImageEnvelope().getMinX(), this.getActualImageEnvelope().getMaxY()));
                Point2D lowerRightCornerOfImage = viewport.toViewPoint(new Coordinate(this.getActualImageEnvelope().getMaxX(), this.getActualImageEnvelope().getMinY()));
                double scaledWidth = lowerRightCornerOfImage.getX() - upperLeftCornerOfImage.getX();
                double scaledHeight = upperLeftCornerOfImage.getY() - lowerRightCornerOfImage.getY();
                imageToDraw = this.stretchImageValuesForDisplay();
                layerViewPanel.getViewport().update();
                this.setImage(imageToDraw);
                this.imagePart = this.getVisibleImageCoordinatesOfImage(this.image.getWidth(), this.image.getHeight(), this.visibleEnv, this.getActualImageEnvelope());
                double scaleXImg2Canvas = scaledWidth / (double)this.image.getWidth();
                double scaleYImg2Canvas = scaledHeight / (double)this.image.getHeight();
                if (this.scaledBufferedImage == null || scaleXImg2Canvas != this.oldScaleXImg2Canvas || !RasterImageLayer.tilesAreNotNullAndCongruent(this.visibleEnv, this.oldVisibleEnv)) {
                    this.scaledBufferedImage = this.getVisiblePartOfTheImage(this.getImageForDisplay(layerViewPanel), this.imagePart);
                    if (this.scaledBufferedImage != null) {
                        if (this.imagePart.width == 1 || this.imagePart.height == 1) {
                            this.xOffset = 0;
                            this.yOffset = 0;
                            this.scaledBufferedImage = this.createOneColorImage(new Color(this.scaledBufferedImage.getRGB(0, 0)));
                        } else {
                            this.scaledBufferedImage = this.getScaledImageMatchingVisible(this.scaledBufferedImage, scaleXImg2Canvas, scaleYImg2Canvas);
                        }
                    } else {
                        return null;
                    }
                    if (this.transparentColor != null) {
                        this.transparencyColorNeedsToBeApplied = true;
                    }
                    this.xOffset = (int)((double)this.xOffset * scaleXImg2Canvas);
                    this.yOffset = (int)((double)this.yOffset * -scaleYImg2Canvas);
                    this.oldScaleXImg2Canvas = scaleXImg2Canvas;
                    this.oldVisibleEnv = this.visibleEnv;
                }
            }
            if (this.scaledBufferedImage != null && this.transparencyColorNeedsToBeApplied) {
                imageToDraw = this.setupTransparency(this.scaledBufferedImage);
            } else if (this.scaledBufferedImage != null) {
                imageToDraw = this.scaledBufferedImage;
            }
        }
        catch (Exception e) {
            Logger.warn(e);
        }
        if (imageToDraw != null) {
            return imageToDraw;
        }
        return this.scaledBufferedImage;
    }

    protected long getCommittedMemory() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public boolean clearImageAndRaster(boolean garbageCollect) {
        boolean reallyNeedToFreeRAM;
        boolean bl = reallyNeedToFreeRAM = (double)(availRAM - this.getCommittedMemory()) < minRamToKeepFree;
        if (!this.needToKeepImage && reallyNeedToFreeRAM) {
            this.flushImages(garbageCollect);
        } else if (garbageCollect) {
            Runtime.getRuntime().gc();
        }
        return reallyNeedToFreeRAM;
    }

    public void flushImages(boolean garbageCollect) {
        if (this.image != null) {
            this.image.flush();
        }
        this.image = null;
        if (this.scaledBufferedImage != null) {
            this.scaledBufferedImage.flush();
        }
        this.scaledBufferedImage = null;
        if (garbageCollect) {
            Runtime.getRuntime().gc();
        }
    }

    public void reLoadImage(LayerViewPanel layerViewPanel) throws Exception {
        RasterImageIO rasterImageIO = new RasterImageIO();
        Viewport viewport = layerViewPanel.getViewport();
        if (!viewport.getEnvelopeInModelCoordinates().intersects(this.getEnvelope()) && layerViewPanel.getLayerManager().getLayerables(Layerable.class).isEmpty()) {
            viewport.zoom(this.getEnvelope());
        }
        Resolution requestedRes = RasterImageIO.calcRequestedResolution(viewport);
        long start = Timer.milliSecondsSince(0L);
        Logger.debug("Try reading " + this.getName());
        ImageAndMetadata imageAndMetadata = rasterImageIO.loadImage(this.imageFileName, this.stats, viewport.getEnvelopeInModelCoordinates(), requestedRes);
        Logger.debug("Reading '" + this.getName() + "' took " + Timer.secondsSinceString(start) + "s.");
        this.metadata = imageAndMetadata.getMetadata();
        this.image = imageAndMetadata.getImage();
        this.numBands = this.metadata.getStats().getBandCount();
        this.noDataValue = imageAndMetadata.getMetadata().getNoDataValue();
        this.stats = imageAndMetadata.getMetadata().getStats();
        this.setEnvelope(imageAndMetadata.getMetadata().getOriginalImageEnvelope());
        this.actualImageEnvelope = imageAndMetadata.getMetadata().getActualEnvelope();
        this.originalCellSize = imageAndMetadata.getMetadata().getOriginalCellSize();
        this.actualCellSize = imageAndMetadata.getMetadata().getActualCellSize();
        if (this.image != null) {
            this.setImage(this.image);
        }
    }

    protected BufferedImage stretchImageValuesForDisplay() throws NoninvertibleTransformException {
        WritableRaster actualRasterData = this.image.copyData(null);
        int width = actualRasterData.getWidth();
        int height = actualRasterData.getHeight();
        if (this.image.getColorModel() instanceof IndexColorModel) {
            return this.image;
        }
        BufferedImage newImage = new BufferedImage(width, height, 6);
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                if (this.symbology == null) {
                    int b;
                    int g;
                    if (this.stats.getBandCount() < 3) {
                        RasterSymbology rasterSymbology;
                        double max;
                        double min = this.metadata.getStats().getMin(0);
                        if (min == (max = this.metadata.getStats().getMax(0))) {
                            rasterSymbology = new RasterSymbology("SINGLE");
                            rasterSymbology.addColorMapEntry(min, Color.GRAY);
                        } else {
                            rasterSymbology = new RasterSymbology("RAMP");
                            rasterSymbology.addColorMapEntry(min, Color.BLACK);
                            rasterSymbology.addColorMapEntry(max, Color.WHITE);
                        }
                        if (!Double.isNaN(this.metadata.getNoDataValue())) {
                            rasterSymbology.addColorMapEntry(this.metadata.getNoDataValue(), this.transparentColor);
                        }
                        this.setSymbology(rasterSymbology);
                        continue;
                    }
                    double valueR = actualRasterData.getSampleDouble(col, row, 0);
                    double valueG = actualRasterData.getSampleDouble(col, row, 1);
                    double valueB = actualRasterData.getSampleDouble(col, row, 2);
                    double valueAlpha = 255.0;
                    if (this.stats.getBandCount() > 3) {
                        valueAlpha = actualRasterData.getSampleDouble(col, row, 3);
                    }
                    if (Double.isNaN(valueR) || Double.isInfinite(valueR) || valueR == this.noDataValue || Double.isNaN(valueG) || Double.isInfinite(valueG) || valueG == this.noDataValue || Double.isNaN(valueB) || Double.isInfinite(valueB) || valueB == this.noDataValue || valueAlpha <= 0.0) {
                        newImage.setRGB(col, row, 3);
                        continue;
                    }
                    int r = (int)((valueR - this.stats.getMin(0)) * 255.0 / (this.stats.getMax(0) - this.stats.getMin(0)));
                    if (r > 255) {
                        r = 255;
                    }
                    if (r < 0) {
                        r = 0;
                    }
                    if ((g = (int)((valueG - this.stats.getMin(1)) * 255.0 / (this.stats.getMax(1) - this.stats.getMin(0)))) > 255) {
                        g = 255;
                    }
                    if (g < 0) {
                        g = 0;
                    }
                    if ((b = (int)((valueB - this.stats.getMin(2)) * 255.0 / (this.stats.getMax(2) - this.stats.getMin(0)))) > 255) {
                        b = 255;
                    }
                    if (b < 0) {
                        b = 0;
                    }
                    int alpha = (int)valueAlpha;
                    newImage.setRGB(col, row, new Color(r, g, b, alpha).getRGB());
                    continue;
                }
                double value = actualRasterData.getSampleDouble(col, row, 0);
                Double[] symbologyClassLimits = this.symbology.getColorMapEntries_tm().keySet().toArray(new Double[0]);
                double symbMinValue = symbologyClassLimits[0];
                double symbFirstValue = symbologyClassLimits[0];
                if (this.isNoData(symbFirstValue)) {
                    symbMinValue = symbologyClassLimits[1];
                }
                if (!this.isNoData(value) && value < symbMinValue) {
                    value = symbMinValue;
                }
                Color color = this.symbology.getColor(value);
                if ((Double.isNaN(value) || Double.isInfinite(value) || this.isNoData(value)) && color == null) {
                    newImage.setRGB(col, row, 3);
                    continue;
                }
                int transparency = (int)((1.0 - this.symbology.getTransparency()) * ((double)color.getAlpha() / 255.0) * 255.0);
                newImage.setRGB(col, row, new Color(color.getRed(), color.getGreen(), color.getBlue(), transparency).getRGB());
            }
        }
        return newImage;
    }

    public Envelope getWholeImageEnvelope() {
        return this.getEnvelope();
    }

    public Envelope getActualImageEnvelope() {
        return this.actualImageEnvelope;
    }

    private void setWholeImageEnvelope(Envelope envelope) {
        this.setEnvelope(envelope);
        this.forceTotalRepaint();
        if (this.isFiringAppearanceEvents()) {
            this.fireAppearanceChanged();
        }
    }

    private void setActualImageEnvelope(Envelope envelope) {
        this.actualImageEnvelope = envelope;
        this.forceTotalRepaint();
        if (this.isFiringAppearanceEvents()) {
            this.fireAppearanceChanged();
        }
    }

    public String getXmlWholeImageEnvelope() {
        return this.getEnvelope().toString();
    }

    public String getXmlActualImageEnvelope() {
        return this.actualImageEnvelope.toString();
    }

    public void setXmlWholeImageEnvelope(String envStr) {
        String coords = envStr.substring(envStr.indexOf("[") + 1, envStr.indexOf("]"));
        String[] coordArray = coords.split(",");
        String[] xCoords = coordArray[0].split(":");
        String[] yCoords = coordArray[1].split(":");
        double minX = Double.parseDouble(xCoords[0]);
        double maxX = Double.parseDouble(xCoords[1]);
        double minY = Double.parseDouble(yCoords[0]);
        double maxY = Double.parseDouble(yCoords[1]);
        this.setWholeImageEnvelope(new Envelope(minX, maxX, minY, maxY));
    }

    public void setXmlActualImageEnvelope(String envStr) {
        String coords = envStr.substring(envStr.indexOf("[") + 1, envStr.indexOf("]"));
        String[] coordArray = coords.split(",");
        String[] xCoords = coordArray[0].split(":");
        String[] yCoords = coordArray[1].split(":");
        double minX = Double.parseDouble(xCoords[0]);
        double maxX = Double.parseDouble(xCoords[1]);
        double minY = Double.parseDouble(yCoords[0]);
        double maxY = Double.parseDouble(yCoords[1]);
        this.setActualImageEnvelope(new Envelope(minX, maxX, minY, maxY));
    }

    public Geometry getWholeImageEnvelopeAsGeometry() {
        return new GeometryFactory().toGeometry(this.getEnvelope());
    }

    public Geometry getActualImageEnvelopeAsGeometry() {
        return new GeometryFactory().toGeometry(this.actualImageEnvelope);
    }

    public void setGeometryAsWholeImageEnvelope(Geometry geometry) {
        this.setWholeImageEnvelope(geometry.getEnvelopeInternal());
    }

    public void setGeometryAsActualImageEnvelope(Geometry geometry) {
        this.setActualImageEnvelope(geometry.getEnvelopeInternal());
    }

    private BufferedImage setupTransparency(BufferedImage bim) {
        ColorModel cm = bim.getColorModel();
        int fullTransparencyAlpha = 255;
        if (this.getTransparentColor() == null) {
            return null;
        }
        int transparentColor = this.getTransparentColor().getRGB();
        int[] argb = new int[4];
        if (!cm.hasAlpha()) {
            bim = RasterImageLayer.makeBufferedImage(bim);
        }
        for (int w = 0; w < bim.getWidth(); ++w) {
            for (int h = 0; h < bim.getHeight(); ++h) {
                if (bim.getRGB(w, h) != transparentColor) continue;
                Color color = new Color(bim.getRGB(w, h));
                argb[0] = fullTransparencyAlpha;
                argb[1] = color.getRed();
                argb[2] = color.getGreen();
                argb[3] = color.getBlue();
                bim.setRGB(w, h, 1, 1, argb, 0, 1);
            }
        }
        return bim;
    }

    private void setImageProcessingMode(int nr) {
        if (this.lastImgProcessingMode != nr) {
            this.imagePart = null;
            this.oldScaleXImg2Canvas = -1.0;
            if ((double)Runtime.getRuntime().freeMemory() < RasterImageLayer.getMinRamToKeepFree()) {
                Runtime.getRuntime().gc();
            }
            this.lastImgProcessingMode = nr;
        }
    }

    private static boolean tilesAreNotNullAndCongruent(Envelope oldVisibleEnv, Envelope newVisibleEnv) {
        if (oldVisibleEnv == null || newVisibleEnv == null) {
            return true;
        }
        return oldVisibleEnv.getMinX() == newVisibleEnv.getMinX() && oldVisibleEnv.getMaxX() == newVisibleEnv.getMaxX() && oldVisibleEnv.getMinY() == newVisibleEnv.getMinY() && oldVisibleEnv.getMaxY() == newVisibleEnv.getMaxY();
    }

    public static BufferedImage makeBufferedImage(Image im) {
        BufferedImage copy = new BufferedImage(im.getWidth(null), im.getHeight(null), 2);
        Graphics2D g2d = copy.createGraphics();
        g2d.drawImage(im, 0, 0, null);
        g2d.dispose();
        return copy;
    }

    protected BufferedImage getScaledImageMatchingVisible(BufferedImage toBeScaled, double XscaleImg2Canvas, double YscaleImg2Canvas) {
        if (toBeScaled == null) {
            return null;
        }
        int scaledWidth = (int)((double)toBeScaled.getWidth() * XscaleImg2Canvas);
        int scaledHeight = (int)((double)toBeScaled.getHeight() * Math.abs(YscaleImg2Canvas));
        if (scaledWidth <= 0 || scaledHeight <= 0) {
            return null;
        }
        return this.scaleImage(toBeScaled, (float)XscaleImg2Canvas, (float)Math.abs(YscaleImg2Canvas));
    }

    public Rectangle getDrawingRectangle(double imgWidth, double imgHeight, Envelope imageEnv, Viewport viewport) throws NoninvertibleTransformException {
        Point2D lowerRightCorner;
        Point2D upperLeftCorner;
        Rectangle visible = viewport.getPanel().getVisibleRect();
        try {
            upperLeftCorner = viewport.toViewPoint(new Coordinate(imageEnv.getMinX(), imageEnv.getMaxY()));
            lowerRightCorner = viewport.toViewPoint(new Coordinate(imageEnv.getMaxX(), imageEnv.getMinY()));
        }
        catch (NoninvertibleTransformException ne) {
            ne.printStackTrace();
            return null;
        }
        int visibleX1 = visible.x;
        int visibleY1 = visible.y;
        int visibleX2 = visibleX1 + visible.width;
        int visibleY2 = visibleY1 + visible.height;
        Coordinate upperLeftVisible = viewport.toModelCoordinate(new Point(visibleX1, visibleY1));
        Coordinate lowerRightVisible = viewport.toModelCoordinate(new Point(visibleX2, visibleY2));
        Envelope newVisibleEnv = new Envelope(upperLeftVisible.x, lowerRightVisible.x, upperLeftVisible.y, lowerRightVisible.y);
        Rectangle rect = this.getVisibleImageCoordinatesOfImage(imgWidth, imgHeight, newVisibleEnv, imageEnv);
        if (rect == null) {
            return null;
        }
        double scaledWidth = lowerRightCorner.getX() - upperLeftCorner.getX();
        double scaledHeight = upperLeftCorner.getY() - lowerRightCorner.getY();
        double scaleXImg2Canvas = scaledWidth / imgWidth;
        double scaleYImg2Canvas = scaledHeight / imgHeight;
        rect.width = (int)((double)rect.width * scaleXImg2Canvas);
        rect.height = (int)((double)rect.height * scaleYImg2Canvas);
        return rect;
    }

    protected Rectangle getVisibleImageCoordinatesOfImage(double imgWidth, double imgHeight, Envelope viewportEnv, Envelope imageEnv) {
        Envelope visiblePartOfImage = viewportEnv.intersection(imageEnv);
        if (visiblePartOfImage.isNull()) {
            return null;
        }
        double offset2VisibleX = imageEnv.getMinX() - viewportEnv.getMinX();
        double offset2VisibleY = viewportEnv.getMaxY() - imageEnv.getMaxY();
        double scaleX = imgWidth / imageEnv.getWidth();
        double scaleY = imgHeight / imageEnv.getHeight();
        this.xOffset = offset2VisibleX >= 0.0 ? 0 : (int)(-offset2VisibleX * scaleX);
        this.yOffset = offset2VisibleY >= 0.0 ? 0 : (int)(-offset2VisibleY * scaleY);
        int width = (int)(visiblePartOfImage.getWidth() * scaleX);
        int height = (int)(visiblePartOfImage.getHeight() * scaleY);
        if ((double)width < imgWidth) {
            ++width;
        }
        if ((double)height < imgHeight) {
            ++height;
        }
        return new Rectangle(this.xOffset, this.yOffset, width, height);
    }

    protected Rectangle getVisibleImageCoordinatesOfImage(BufferedImage img, Envelope visible, Envelope imageEnv) {
        return this.getVisibleImageCoordinatesOfImage(img.getWidth(), img.getHeight(), visible, imageEnv);
    }

    protected BufferedImage getVisiblePartOfTheImage(BufferedImage img, Rectangle desiredImageArea) {
        if (desiredImageArea == null) {
            return null;
        }
        if (desiredImageArea.width > 0 && desiredImageArea.height > 0 && desiredImageArea.width + desiredImageArea.x <= img.getWidth() && desiredImageArea.height + desiredImageArea.y <= img.getHeight()) {
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(img);
            pb.add((float)desiredImageArea.x);
            pb.add((float)desiredImageArea.y);
            pb.add((float)desiredImageArea.width);
            pb.add((float)desiredImageArea.height);
            return JAI.create((String)"crop", (ParameterBlock)pb).getAsBufferedImage();
        }
        return null;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.imageSet = true;
    }

    public void setImageSet(boolean imageSet) {
        this.imageSet = imageSet;
    }

    public boolean isImageNull() {
        return this.image == null;
    }

    public BufferedImage getImageForDisplay(LayerViewPanel layerViewPanel) throws Exception {
        if (this.image == null) {
            this.reLoadImage(layerViewPanel);
        }
        return this.image;
    }

    public boolean isImageSet() {
        return this.imageSet;
    }

    public double getTransparencyLevel() {
        return this.transparencyLevel;
    }

    public void setTransparencyLevel(double transparencyLevel) {
        if (transparencyLevel != this.transparencyLevel) {
            this.transparencyLevel = transparencyLevel;
            if (this.isFiringAppearanceEvents()) {
                this.fireAppearanceChanged();
            }
        }
    }

    public void setTransparencyLevelInPercent(int transparencyInPercent) {
        double tLevel = (double)transparencyInPercent / 100.0;
        if (tLevel != this.transparencyLevel) {
            this.transparencyLevel = tLevel;
            if (this.isFiringAppearanceEvents()) {
                this.fireAppearanceChanged();
            }
        }
    }

    public Color getTransparentColor() {
        return this.transparentColor;
    }

    public String getTransparentColorAsString() {
        if (this.getTransparentColor() == null) {
            return "null";
        }
        String hexColor = Integer.toHexString(this.getTransparentColor().getRGB());
        if (hexColor.length() > 6) {
            hexColor = hexColor.substring(2);
        }
        return hexColor;
    }

    public void setTransparentColorAsString(String hexColorString) {
        if (hexColorString == null || hexColorString.equals("null")) {
            return;
        }
        int rgb = Integer.parseInt(hexColorString.toUpperCase(), 16);
        Color tColor = new Color(rgb);
        this.setTransparentColor(tColor);
    }

    public void setTransparentColor(Color transparentColor) {
        if (!Objects.equals(this.transparentColor, transparentColor)) {
            this.transparentColor = transparentColor;
            this.forceTotalRepaint();
            if (this.isFiringAppearanceEvents()) {
                this.fireAppearanceChanged();
            }
        }
    }

    protected void forceTotalRepaint() {
        this.visibleEnv = null;
        this.setImageProcessingMode(0);
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public static double getFreeRamFactor() {
        return freeRamFactor;
    }

    public static void setFreeRamFactor(double freeRamFactor) {
        RasterImageLayer.freeRamFactor = freeRamFactor;
        minRamToKeepFree = (double)availRAM * RasterImageLayer.freeRamFactor;
        maxPixelsForFastDisplayMode = (int)(((double)availRAM - minRamToKeepFree) / 1048576.0 * 3000.0);
    }

    public static long getAvailRAM() {
        return availRAM;
    }

    public static int getMaxPixelsForFastDisplayMode() {
        return maxPixelsForFastDisplayMode;
    }

    public static double getMinRamToKeepFree() {
        return minRamToKeepFree;
    }

    public void setImageFileName(String imageFileName) {
        this.imageFileName = imageFileName;
        this.setNeedToKeepImage(false);
    }

    public String getImageFileName() {
        return this.imageFileName;
    }

    public boolean isNeedToKeepImage() {
        return this.needToKeepImage;
    }

    public void setNeedToKeepImage(boolean needToKeepImage) {
        this.needToKeepImage = needToKeepImage;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.flushImages(true);
    }

    public int getOrigImageHeight() {
        return this.origImageHeight;
    }

    public int getOrigImageWidth() {
        return this.origImageWidth;
    }

    public void setOrigImageHeight(int origImageHeight) {
        this.origImageHeight = origImageHeight;
    }

    public void setOrigImageWidth(int origImageWidth) {
        this.origImageWidth = origImageWidth;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.clearImageAndRaster(true);
        }
        if (this.isFiringAppearanceEvents()) {
            this.fireAppearanceChanged();
        }
    }

    public boolean isFiringAppearanceEvents() {
        return this.firingAppearanceEvents;
    }

    public void setFiringAppearanceEvents(boolean firingAppearanceEvents) {
        this.firingAppearanceEvents = firingAppearanceEvents;
    }

    @Override
    public MetaDataMap getMetaInformation() {
        return this.metaInformation;
    }

    @Override
    public void setMetaInformation(MetaDataMap metaInformation) {
        this.metaInformation = metaInformation;
    }

    public Raster getRasterData(Rectangle subset) throws IOException {
        return RasterImageIO.loadRasterData(this.imageFileName, subset);
    }

    public Rectangle getRectangleFromEnvelope(Envelope envelope) {
        double imgWidth = this.origImageWidth;
        double imgHeight = this.origImageHeight;
        Envelope imageEnv = this.getEnvelope();
        double offset2VisibleX = imageEnv.getMinX() - envelope.getMinX();
        double offset2VisibleY = envelope.getMaxY() - imageEnv.getMaxY();
        double scaleX = imgWidth / imageEnv.getWidth();
        double scaleY = imgHeight / imageEnv.getHeight();
        int xOffset = offset2VisibleX >= 0.0 ? 0 : (int)Math.round(-offset2VisibleX * scaleX);
        int yOffset = offset2VisibleY >= 0.0 ? 0 : (int)Math.round(-offset2VisibleY * scaleY);
        int wantedWidth = (int)Math.round(envelope.getWidth() * scaleX);
        int wantedHeight = (int)Math.round(envelope.getHeight() * scaleY);
        return new Rectangle(xOffset, yOffset, wantedWidth, wantedHeight);
    }

    public boolean isRasterDataChanged() {
        return this.rasterDataChanged;
    }

    public void setRasterDataChanged(boolean rasterDataChanged) {
        this.rasterDataChanged = rasterDataChanged;
    }

    public double getNoDataValue() {
        return this.noDataValue;
    }

    public int getNumBands() {
        return this.numBands;
    }

    @Override
    public void dispose() {
        TiffUtilsV2.removeFromGeoRastercache(new File(this.imageFileName));
    }

    public Double getCellValue(Coordinate coordinate, int band) throws IOException {
        return this.getCellValue(coordinate.x, coordinate.y, band);
    }

    public Double getCellValue(int col, int row, int band) throws IOException {
        int pos = row * this.origImageWidth + col;
        if (pos < 0 || pos > this.origImageWidth * this.origImageHeight) {
            return null;
        }
        return RasterImageIO.readCellValue(this.imageFileName, col, row, band);
    }

    public Double getCellValue(double coordX, double coordY, int band) throws IOException {
        double cellSizeX = (this.getEnvelope().getMaxX() - this.getEnvelope().getMinX()) / (double)this.origImageWidth;
        double cellSizeY = (this.getEnvelope().getMaxY() - this.getEnvelope().getMinY()) / (double)this.origImageHeight;
        int col = (int)Math.floor((coordX - this.getEnvelope().getMinX()) / cellSizeX);
        int row = this.origImageHeight - (int)Math.floor((coordY - this.getEnvelope().getMinY()) / cellSizeY) - 1;
        if (col < 0 || col >= this.origImageWidth || row < 0 || row >= this.origImageHeight) {
            return null;
        }
        return RasterImageIO.readCellValue(this.imageFileName, col, row, band);
    }

    public boolean isNoData(double value) {
        if (Double.isInfinite(this.noDataValue) && Double.isInfinite(value)) {
            return true;
        }
        if (Double.isNaN(this.noDataValue) && Double.isNaN(value)) {
            return true;
        }
        return value == this.noDataValue || (float)value == (float)this.noDataValue;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public static Rectangle getViewportRectangle(WorkbenchContext workbenchContext) {
        return new Rectangle(0, 0, workbenchContext.getLayerViewPanel().getVisibleRect().width, workbenchContext.getLayerViewPanel().getVisibleRect().height);
    }

    public RasterSymbology getSymbology() {
        return this.symbology;
    }

    public void setSymbology(RasterSymbology symbology) throws NoninvertibleTransformException {
        this.symbology = symbology;
        this.symbologyChanged = true;
        this.scaledBufferedImage = null;
    }

    public Raster getActualRasterData() {
        return this.image.copyData(null);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public boolean isTemporaryLayer() {
        return this.imageFileName.contains(System.getProperty("java.io.tmpdir"));
    }

    public String getFilePath() {
        String fileName = !this.imageFileName.contains(System.getProperty("java.io.tmpdir")) ? this.getImageFileName() : NODATASOURCELAYER;
        return fileName;
    }

    public boolean isSpatiallyConsistentWith(RasterImageLayer rasterImageLayer) {
        if (!this.getWholeImageEnvelope().equals((Object)rasterImageLayer.getWholeImageEnvelope())) {
            return false;
        }
        if (this.getOrigImageWidth() != rasterImageLayer.getOrigImageWidth()) {
            return false;
        }
        return this.getOrigImageHeight() == rasterImageLayer.getOrigImageHeight();
    }

    public static class RasterDataNotFoundException
    extends Exception {
    }
}

