/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage;

import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openjump.core.ccordsys.utils.SRSInfo;
import org.openjump.core.ccordsys.utils.SridLookupTable;
import org.openjump.core.rasterimage.Stats;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GDALPamDataset
extends DefaultHandler {
    private String tmpValue;
    private String attributeQName;
    private String attributeValue;
    private int bandCount = 0;
    private int band = 0;
    private final List<Double> min_l = new ArrayList<Double>();
    private final List<Double> max_l = new ArrayList<Double>();
    private List<Double> mean_l = new ArrayList<Double>();
    private List<Double> stdDev_l = new ArrayList<Double>();

    public Stats readStatistics(File auxXmlFile) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        parser.parse(auxXmlFile, (DefaultHandler)this);
        if (this.min_l.isEmpty() || this.max_l.isEmpty() || this.mean_l.isEmpty() || this.stdDev_l.isEmpty()) {
            throw new IOException("Error while reading xml file: some statistcs non found");
        }
        Stats stats = new Stats(this.bandCount);
        for (int b = 0; b < this.bandCount; ++b) {
            stats.setStatsForBand(b, this.min_l.get(b), this.max_l.get(b), this.mean_l.get(b), this.stdDev_l.get(b));
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStatistics(File auxXmlFile, Stats stats) throws ParserConfigurationException, TransformerConfigurationException, TransformerException, SAXException, IOException {
        Element metadataElement;
        Element pamRasterBandElement;
        int b;
        String pamDatasetTagName;
        Element pamDatasetElement;
        Document doc;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        if (auxXmlFile.isFile()) {
            try {
                doc = docBuilder.parse(auxXmlFile);
            }
            catch (IOException | SAXException ex) {
                doc = docBuilder.newDocument();
            }
        } else {
            doc = docBuilder.newDocument();
        }
        if ((pamDatasetElement = (Element)doc.getElementsByTagName(pamDatasetTagName = "PAMDataset").item(0)) == null) {
            pamDatasetElement = doc.createElement(pamDatasetTagName);
        }
        String pamRasterBandTagName = "PAMRasterBand";
        String bandAttribute = "band";
        String metadataElementName = "Metadata";
        NodeList pamRasterBandNodeList = pamDatasetElement.getElementsByTagName(pamRasterBandTagName);
        if (pamRasterBandNodeList != null && pamRasterBandNodeList.getLength() > 0) {
            for (b = 0; b < pamRasterBandNodeList.getLength(); ++b) {
                pamRasterBandElement = (Element)pamRasterBandNodeList.item(b);
                int bandNr = Integer.parseInt(pamRasterBandElement.getAttribute(bandAttribute));
                if (bandNr != b + 1) continue;
                metadataElement = (Element)pamRasterBandElement.getElementsByTagName(metadataElementName).item(0);
                metadataElement = this.updateMetadataElement(doc, metadataElement, stats, this.band);
                pamRasterBandElement.appendChild(metadataElement);
                pamDatasetElement.appendChild(pamRasterBandElement);
            }
        } else {
            for (b = 0; b < stats.getBandCount(); ++b) {
                pamRasterBandElement = doc.createElement(pamRasterBandTagName);
                Attr attr = doc.createAttribute(bandAttribute);
                attr.setValue(Integer.toString(b + 1));
                pamRasterBandElement.setAttributeNode(attr);
                metadataElement = doc.createElement(metadataElementName);
                metadataElement = this.updateMetadataElement(doc, metadataElement, stats, this.band);
                pamRasterBandElement.appendChild(metadataElement);
                pamDatasetElement.appendChild(pamRasterBandElement);
            }
            doc.appendChild(pamDatasetElement);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(doc);
        FileOutputStream stream = new FileOutputStream(auxXmlFile);
        try {
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
        }
        finally {
            FileUtil.close(stream);
        }
    }

    public void writeStatisticsAndSRS(File auxXmlFile, SRSInfo srsInfo, Stats stats) throws ParserConfigurationException, TransformerConfigurationException, TransformerException, SAXException, IOException {
        Element metadataElement;
        Element pamRasterBandElement;
        int b;
        String pamDatasetTagName;
        Element pamDatasetElement;
        Document doc;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        if (auxXmlFile.isFile()) {
            try {
                doc = docBuilder.parse(auxXmlFile);
            }
            catch (IOException | SAXException ex) {
                doc = docBuilder.newDocument();
            }
        } else {
            doc = docBuilder.newDocument();
        }
        if ((pamDatasetElement = (Element)doc.getElementsByTagName(pamDatasetTagName = "PAMDataset").item(0)) == null) {
            pamDatasetElement = doc.createElement(pamDatasetTagName);
        }
        try {
            String SRS = SridLookupTable.getOGCWKTFromWkidCode(srsInfo.getCode());
            Element srsElement = doc.createElement("SRS");
            srsElement.appendChild(doc.createTextNode(SRS));
            pamDatasetElement.appendChild(srsElement);
        }
        catch (IOException | URISyntaxException e) {
            JUMPWorkbench.getInstance().getFrame().warnUser("OpenjUMP cannot decode/record SRS");
        }
        String pamRasterBandTagName = "PAMRasterBand";
        String bandAttribute = "band";
        String metadataElementName = "Metadata";
        NodeList pamRasterBandNodeList = pamDatasetElement.getElementsByTagName(pamRasterBandTagName);
        if (pamRasterBandNodeList != null && pamRasterBandNodeList.getLength() > 0) {
            for (b = 0; b < pamRasterBandNodeList.getLength(); ++b) {
                pamRasterBandElement = (Element)pamRasterBandNodeList.item(b);
                int bandNr = Integer.parseInt(pamRasterBandElement.getAttribute(bandAttribute));
                if (bandNr != b + 1) continue;
                metadataElement = (Element)pamRasterBandElement.getElementsByTagName(metadataElementName).item(0);
                metadataElement = this.updateMetadataElement(doc, metadataElement, stats, this.band);
                pamRasterBandElement.appendChild(metadataElement);
                pamDatasetElement.appendChild(pamRasterBandElement);
            }
        } else {
            for (b = 0; b < stats.getBandCount(); ++b) {
                pamRasterBandElement = doc.createElement(pamRasterBandTagName);
                Attr attr = doc.createAttribute(bandAttribute);
                attr.setValue(Integer.toString(b + 1));
                pamRasterBandElement.setAttributeNode(attr);
                metadataElement = doc.createElement(metadataElementName);
                metadataElement = this.updateMetadataElement(doc, metadataElement, stats, this.band);
                pamRasterBandElement.appendChild(metadataElement);
                pamDatasetElement.appendChild(pamRasterBandElement);
            }
            doc.appendChild(pamDatasetElement);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(auxXmlFile);
        transformer.transform(source, result);
    }

    private Element updateMetadataElement(Document doc, Element metadataElement, Stats stats, int band) {
        Element mdi = doc.createElement("MDI");
        mdi.setAttribute("key", "STATISTICS_MINIMUM");
        mdi.setTextContent(Double.toString(stats.getMin(band)));
        metadataElement.appendChild(mdi);
        mdi = doc.createElement("MDI");
        mdi.setAttribute("key", "STATISTICS_MAXIMUM");
        mdi.setTextContent(Double.toString(stats.getMax(band)));
        metadataElement.appendChild(mdi);
        mdi = doc.createElement("MDI");
        mdi.setAttribute("key", "STATISTICS_MEAN");
        mdi.setTextContent(Double.toString(stats.getMean(band)));
        metadataElement.appendChild(mdi);
        mdi = doc.createElement("MDI");
        mdi.setAttribute("key", "STATISTICS_STDDEV");
        mdi.setTextContent(Double.toString(stats.getStdDev(band)));
        metadataElement.appendChild(mdi);
        return metadataElement;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        int a;
        super.startElement(uri, localName, qName, attributes);
        this.attributeValue = null;
        if (localName.toUpperCase().equals("PAMRASTERBAND")) {
            for (a = 0; a < attributes.getLength(); ++a) {
                if (!attributes.getQName(a).toLowerCase().equals("band")) continue;
                this.attributeQName = "band";
                this.attributeValue = attributes.getValue(a);
                this.band = Integer.parseInt(this.attributeValue);
                this.bandCount = Math.max(this.band, this.bandCount);
            }
        }
        if (localName.toUpperCase().equals("MDI")) {
            block13: for (a = 0; a < attributes.getLength(); ++a) {
                if (!attributes.getQName(a).toLowerCase().equals("key")) continue;
                this.attributeQName = "key";
                switch (attributes.getValue(a).toUpperCase()) {
                    case "STATISTICS_MINIMUM": {
                        this.attributeValue = "STATISTICS_MINIMUM";
                        continue block13;
                    }
                    case "STATISTICS_MAXIMUM": {
                        this.attributeValue = "STATISTICS_MAXIMUM";
                        continue block13;
                    }
                    case "STATISTICS_MEAN": {
                        this.attributeValue = "STATISTICS_MEAN";
                        continue block13;
                    }
                    case "STATISTICS_STDDEV": {
                        this.attributeValue = "STATISTICS_STDDEV";
                    }
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if (this.attributeValue == null || this.tmpValue.trim().equals("")) {
            return;
        }
        if (this.attributeQName.toLowerCase().equals("key")) {
            switch (this.attributeValue.toUpperCase()) {
                case "STATISTICS_MINIMUM": {
                    this.min_l.add(Double.parseDouble(this.tmpValue));
                    break;
                }
                case "STATISTICS_MAXIMUM": {
                    this.max_l.add(Double.parseDouble(this.tmpValue));
                    break;
                }
                case "STATISTICS_MEAN": {
                    this.mean_l.add(Double.parseDouble(this.tmpValue));
                    break;
                }
                case "STATISTICS_STDDEV": {
                    this.stdDev_l.add(Double.parseDouble(this.tmpValue));
                }
            }
        }
    }

    @Override
    public void characters(char[] ac, int i, int j) throws SAXException {
        this.tmpValue = new String(ac, i, j);
    }
}

