/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ccordsys.srid;

import com.vividsolutions.jump.coordsys.CoordinateSystem;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import java.awt.Graphics2D;
import org.locationtech.jts.util.Assert;

public class SRIDStyle
implements Style {
    private int srid;
    private int lastUpdateSrid;
    private boolean initialized;
    private boolean enabled;

    public SRIDStyle() {
        this.lastUpdateSrid = this.srid = 0;
        this.initialized = false;
        this.enabled = true;
    }

    @Override
    public void paint(Feature f, Graphics2D g, Viewport viewport) throws Exception {
    }

    @Override
    public void initialize(Layer layer) {
        if (this.initialized) {
            return;
        }
        this.updateSRIDs(layer);
        this.initialized = true;
    }

    public void updateSRIDs(Layer layer) {
        if (this.lastUpdateSrid == this.srid) {
            return;
        }
        layer.getFeatureCollectionWrapper().getFeatureSchema().setCoordinateSystem(new CoordinateSystem("", this.srid, null));
        for (Feature feature : layer.getFeatureCollectionWrapper().getFeatures()) {
            feature.getGeometry().setSRID(this.srid);
        }
        this.lastUpdateSrid = this.srid;
    }

    @Override
    public Object clone() {
        try {
            SRIDStyle clone = (SRIDStyle)super.clone();
            clone.initialized = false;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public int getSRID() {
        return this.srid;
    }

    public void setSRID(int srid) {
        this.srid = srid;
    }
}

