/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.shapefile;

import com.vividsolutions.jump.io.EndianDataInputStream;
import com.vividsolutions.jump.io.EndianDataOutputStream;
import com.vividsolutions.jump.workbench.Logger;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.geotools.shapefile.InvalidShapefileException;
import org.geotools.shapefile.ShapeHandler;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.PointLocation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.strtree.STRtree;

public class PolygonHandler
implements ShapeHandler {
    int myShapeType;

    public PolygonHandler() {
        this.myShapeType = 5;
    }

    public PolygonHandler(int type) throws InvalidShapefileException {
        if (type != 5 && type != 15 && type != 25) {
            throw new InvalidShapefileException("PolygonHandler constructor - expected type to be 5, 15, or 25.");
        }
        this.myShapeType = type;
    }

    @Override
    public Geometry read(EndianDataInputStream file, GeometryFactory geometryFactory, int contentLength) throws IOException, InvalidShapefileException {
        MultiPolygon geom;
        int actualReadWords = 0;
        int shapeType = file.readIntLE();
        actualReadWords += 2;
        if (shapeType == 0) {
            geom = geometryFactory.createMultiPolygon(new Polygon[0]);
        } else {
            int fullLength;
            int t;
            if (shapeType != this.myShapeType) {
                throw new InvalidShapefileException("PolygonHandler.read() - got shape type " + shapeType + " but was expecting " + this.myShapeType);
            }
            file.readDoubleLE();
            file.readDoubleLE();
            file.readDoubleLE();
            file.readDoubleLE();
            actualReadWords += 16;
            int numParts = file.readIntLE();
            int numPoints = file.readIntLE();
            actualReadWords += 4;
            int[] partOffsets = new int[numParts];
            for (int i = 0; i < numParts; ++i) {
                partOffsets[i] = file.readIntLE();
                actualReadWords += 2;
            }
            Coordinate[] coords = new Coordinate[numPoints];
            for (t = 0; t < numPoints; ++t) {
                coords[t] = new Coordinate(file.readDoubleLE(), file.readDoubleLE());
                actualReadWords += 8;
            }
            if (this.myShapeType == 15) {
                file.readDoubleLE();
                file.readDoubleLE();
                actualReadWords += 8;
                for (t = 0; t < numPoints; ++t) {
                    coords[t].z = file.readDoubleLE();
                    actualReadWords += 4;
                }
            }
            if (this.myShapeType >= 15 && contentLength >= (fullLength = this.myShapeType == 15 ? 22 + 2 * numParts + 8 * numPoints + 8 + 4 * numPoints + 8 + 4 * numPoints : 22 + 2 * numParts + 8 * numPoints + 8 + 4 * numPoints)) {
                file.readDoubleLE();
                file.readDoubleLE();
                actualReadWords += 8;
                for (int t2 = 0; t2 < numPoints; ++t2) {
                    file.readDoubleLE();
                    actualReadWords += 4;
                }
            }
            ArrayList<LinearRing> rings = new ArrayList<LinearRing>();
            int offset = 0;
            for (int part = 0; part < numParts; ++part) {
                int start = partOffsets[part];
                int finish = part == numParts - 1 ? numPoints : partOffsets[part + 1];
                int length = finish - start;
                Object[] points = new Coordinate[length];
                for (int i = 0; i < length; ++i) {
                    points[i] = coords[offset];
                    ++offset;
                }
                if (points.length != 1) {
                    if ((points.length == 0 || points.length > 3) && points[0].equals(points[points.length - 1])) {
                        LinearRing ring = geometryFactory.createLinearRing((Coordinate[])points);
                        rings.add(ring);
                        continue;
                    }
                    Logger.warn("Wrong ring for a Polygon: " + Arrays.toString(points));
                    continue;
                }
                Logger.warn("Wrong ring for a Polygon: " + Arrays.toString(points));
            }
            geom = this.polygonsFromRings(rings, geometryFactory);
        }
        while (actualReadWords < contentLength) {
            short junk = file.readShortBE();
            ++actualReadWords;
        }
        return geom;
    }

    private Geometry polygonsFromRings(List<LinearRing> rings, GeometryFactory geometryFactory) {
        int i2;
        if (rings.isEmpty()) {
            return geometryFactory.createPolygon();
        }
        if (rings.size() == 1) {
            return geometryFactory.createPolygon(rings.get(0));
        }
        LinearRing[] ringArray = new LinearRing[rings.size()];
        for (i2 = 0; i2 < rings.size(); ++i2) {
            ringArray[i2] = rings.get(i2);
            ringArray[i2].setUserData((Object)new MD(ringArray[i2]));
        }
        Arrays.parallelSort(ringArray, Comparator.comparingDouble(r -> ((MD)r.getUserData()).area));
        for (i2 = 0; i2 < ringArray.length; ++i2) {
            ((MD)ringArray[i2].getUserData()).index = i2;
        }
        STRtree index = new STRtree();
        for (LinearRing r2 : ringArray) {
            index.insert(r2.getEnvelopeInternal(), (Object)r2);
        }
        index.build();
        block3: for (LinearRing r2 : ringArray) {
            List candidates = index.query(r2.getEnvelopeInternal());
            candidates = candidates.stream().filter(a -> ((MD)a.getUserData()).index > ((MD)r.getUserData()).index).filter(a -> a.getEnvelopeInternal().contains(r2.getEnvelopeInternal())).collect(Collectors.toList());
            candidates.sort(Comparator.comparingDouble(a -> ((MD)a.getUserData()).area));
            for (LinearRing candidate : candidates) {
                if (!PointLocation.isInRing((Coordinate)((MD)r2.getUserData()).c, (Coordinate[])candidate.getCoordinates())) continue;
                ((MD)r2.getUserData()).parent = ((MD)candidate.getUserData()).index;
                ((MD)candidate.getUserData()).children.add(((MD)r2.getUserData()).index);
                continue block3;
            }
        }
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (LinearRing r3 : ringArray) {
            MD md = (MD)r3.getUserData();
            if (!this.isShell(ringArray, md.index)) continue;
            if (Orientation.isCCW((Coordinate[])r3.getCoordinates())) {
                Logger.warn("This CCW ring seems to be a shell : " + r3);
            }
            List<LinearRing> holes = md.children.stream().map(i -> ringArray[i]).collect(Collectors.toList());
            polygons.add(r3.getFactory().createPolygon(r3, holes.toArray(new LinearRing[0])));
            ringArray[md.index] = null;
            for (LinearRing h : holes) {
                ringArray[((MD)h.getUserData()).index] = null;
            }
        }
        for (LinearRing r3 : ringArray) {
            if (r3 == null) continue;
            Logger.warn("This ring is undefined, we eep it as a shell : " + r3);
            polygons.add(r3.getFactory().createPolygon(r3));
        }
        return geometryFactory.buildGeometry(polygons);
    }

    private boolean isShell(LinearRing[] array, int index) {
        MD md = (MD)array[index].getUserData();
        int ancestors = 0;
        if (md != null) {
            while (md.parent != -1) {
                ++ancestors;
                md = (MD)array[md.parent].getUserData();
            }
        }
        return ancestors % 2 == 0;
    }

    @Override
    public void write(Geometry geometry, EndianDataOutputStream file) throws IOException {
        int t;
        if (geometry.isEmpty()) {
            file.writeIntLE(0);
            return;
        }
        MultiPolygon multi = geometry instanceof MultiPolygon ? (MultiPolygon)geometry : geometry.getFactory().createMultiPolygon(new Polygon[]{(Polygon)geometry});
        file.writeIntLE(this.getShapeType());
        Envelope box = multi.getEnvelopeInternal();
        file.writeDoubleLE(box.getMinX());
        file.writeDoubleLE(box.getMinY());
        file.writeDoubleLE(box.getMaxX());
        file.writeDoubleLE(box.getMaxY());
        int nrings = 0;
        for (int t2 = 0; t2 < multi.getNumGeometries(); ++t2) {
            Polygon p = (Polygon)multi.getGeometryN(t2);
            nrings = nrings + 1 + p.getNumInteriorRing();
        }
        int u = 0;
        int[] pointsPerRing = new int[nrings];
        for (int t3 = 0; t3 < multi.getNumGeometries(); ++t3) {
            Polygon p = (Polygon)multi.getGeometryN(t3);
            pointsPerRing[u] = p.getExteriorRing().getNumPoints();
            ++u;
            for (int v = 0; v < p.getNumInteriorRing(); ++v) {
                pointsPerRing[u] = p.getInteriorRingN(v).getNumPoints();
                ++u;
            }
        }
        int npoints = multi.getNumPoints();
        file.writeIntLE(nrings);
        file.writeIntLE(npoints);
        int count = 0;
        for (int t4 = 0; t4 < nrings; ++t4) {
            file.writeIntLE(count);
            count += pointsPerRing[t4];
        }
        Coordinate[] coords = multi.getCoordinates();
        int num = Array.getLength(coords);
        for (t = 0; t < num; ++t) {
            file.writeDoubleLE(coords[t].x);
            file.writeDoubleLE(coords[t].y);
        }
        if (this.myShapeType == 15) {
            double[] zExtreame = this.zMinMax((Geometry)multi);
            if (Double.isNaN(zExtreame[0])) {
                file.writeDoubleLE(0.0);
                file.writeDoubleLE(0.0);
            } else {
                file.writeDoubleLE(zExtreame[0]);
                file.writeDoubleLE(zExtreame[1]);
            }
            for (int t5 = 0; t5 < npoints; ++t5) {
                double z = coords[t5].z;
                if (Double.isNaN(z)) {
                    file.writeDoubleLE(0.0);
                    continue;
                }
                file.writeDoubleLE(z);
            }
        }
        if (this.myShapeType >= 15) {
            file.writeDoubleLE(-1.0E41);
            file.writeDoubleLE(-1.0E41);
            for (t = 0; t < npoints; ++t) {
                file.writeDoubleLE(-1.0E41);
            }
        }
    }

    @Override
    public int getShapeType() {
        return this.myShapeType;
    }

    @Override
    public int getLength(Geometry geometry) {
        if (geometry.isEmpty()) {
            return 2;
        }
        MultiPolygon multi = geometry instanceof MultiPolygon ? (MultiPolygon)geometry : geometry.getFactory().createMultiPolygon(new Polygon[]{(Polygon)geometry});
        int nrings = 0;
        for (int t = 0; t < multi.getNumGeometries(); ++t) {
            Polygon p = (Polygon)multi.getGeometryN(t);
            nrings = nrings + 1 + p.getNumInteriorRing();
        }
        int npoints = multi.getNumPoints();
        if (this.myShapeType == 15) {
            return 22 + 2 * nrings + 8 * npoints + 4 * npoints + 8 + 4 * npoints + 8;
        }
        if (this.myShapeType == 25) {
            return 22 + 2 * nrings + 8 * npoints + 4 * npoints + 8;
        }
        return 22 + 2 * nrings + 8 * npoints;
    }

    double[] zMinMax(Geometry g) {
        Coordinate[] cs;
        double zmin = Double.NaN;
        double zmax = Double.NaN;
        boolean validZFound = false;
        for (Coordinate c : cs = g.getCoordinates()) {
            double z = c.z;
            if (Double.isNaN(z)) continue;
            if (validZFound) {
                if (z < zmin) {
                    zmin = z;
                }
                if (!(z > zmax)) continue;
                zmax = z;
                continue;
            }
            validZFound = true;
            zmin = z;
            zmax = z;
        }
        return new double[]{zmin, zmax};
    }

    @Override
    public Geometry getEmptyGeometry(GeometryFactory factory) {
        return factory.createMultiPolygon(new Polygon[0]);
    }

    static class MD {
        int index = -1;
        double area;
        Coordinate c;
        int parent = -1;
        List<Integer> children = new ArrayList<Integer>();

        public MD(LinearRing ring) {
            Polygon p = ring.getFactory().createPolygon(ring);
            this.area = p.getArea();
            this.c = p.getInteriorPoint().getCoordinate();
        }

        public String toString() {
            return this.index + ": {area=" + this.area + ", parent=" + this.parent + ",c=" + this.c + "}";
        }
    }
}

