/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.deejump.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerTreeModel;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.ColorPanel;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.TreeLayerNamePanel;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.openjump.core.ui.images.IconLoader;
import org.openjump.core.ui.io.file.FileNameExtensionFilter;

public class SaveLegendPlugIn
extends AbstractPlugIn {
    JFileChooser fileChooser = new GUIUtil.FileChooserWithOverwritePrompting("png");

    public SaveLegendPlugIn() {
        GUIUtil.removeChoosableFileFilters(this.fileChooser);
        this.fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("PNG", new String[]{"png"}));
        this.fileChooser.addChoosableFileFilter(this.fileChooser.getAcceptAllFileFilter());
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setApproveButtonText(I18N.getInstance().get("deejump.plugin.SaveLegendPlugIn.Save"));
        this.fileChooser.setDialogTitle(I18N.getInstance().get("deejump.plugin.SaveLegendPlugIn.Save-legend-as-image-png"));
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.icon("save_legend.png");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Layer[] layers = context.getSelectedLayers();
        LayerNamePanel layerPanel = context.getLayerNamePanel();
        if (!(layerPanel instanceof TreeLayerNamePanel)) {
            return false;
        }
        JTree newTree = this.createLayerTree(layers, (TreeLayerNamePanel)layerPanel);
        this.saveLegend(context, newTree);
        return true;
    }

    private void saveLegend(PlugInContext context, JTree tree) throws IOException {
        JPanel p = new JPanel();
        p.add(tree);
        int oldHeigth = (int)this.fileChooser.getPreferredSize().getHeight();
        this.fileChooser.setAccessory(p);
        if (this.fileChooser.getPreferredSize().getHeight() > (double)(oldHeigth + 100)) {
            this.fileChooser.setPreferredSize(new Dimension((int)this.fileChooser.getPreferredSize().getWidth(), oldHeigth + 100));
        }
        if (0 == this.fileChooser.showOpenDialog(context.getWorkbenchFrame())) {
            JFrame f = new JFrame(I18N.getInstance().get("deejump.plugin.SaveLegendPlugIn.Save-legend-as-image-png"));
            f.getContentPane().add(tree);
            f.pack();
            SaveLegendPlugIn.saveComponentAsJPEG(tree, this.fileChooser.getSelectedFile().getAbsolutePath());
            f.setVisible(false);
            f.dispose();
        }
    }

    private JTree createLayerTree(Layer[] layers, TreeLayerNamePanel treePanel) {
        JTree tree = treePanel.getTree();
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(I18N.getInstance().get("ui.WorkbenchFrame.task") + " " + layers[0].getTask().getName());
        for (int l = 0; l < layers.length; ++l) {
            Layer layer = layers[l];
            DefaultMutableTreeNode layerNode = new DefaultMutableTreeNode(layer);
            for (int j = 0; j < tree.getModel().getChildCount(layer); ++j) {
                layerNode.add(new DefaultMutableTreeNode(tree.getModel().getChild(layer, j)));
            }
            rootNode.add(layerNode);
        }
        JTree newTree = new JTree(rootNode);
        for (int i = 0; i < newTree.getRowCount(); ++i) {
            newTree.expandRow(i);
        }
        newTree.setCellRenderer(this.createColorThemingValueRenderer());
        return newTree;
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("deejump.plugin.SaveLegendPlugIn.Save-legend");
    }

    public static void saveComponentAsJPEG(Component myComponent, String filename) throws IOException {
        if (!filename.endsWith(".png")) {
            filename = filename + ".png";
        }
        Dimension size = myComponent.getSize();
        BufferedImage myImage = new BufferedImage(size.width, size.height, 1);
        Graphics2D g2 = myImage.createGraphics();
        myComponent.paint(g2);
        ImageIO.write((RenderedImage)myImage, "PNG", new File(filename));
    }

    private TreeCellRenderer createColorThemingValueRenderer() {
        return new TreeCellRenderer(){
            private JPanel panel = new JPanel(new GridBagLayout());
            private ColorPanel colorPanel = new ColorPanel();
            private JLabel label = new JLabel();
            {
                this.panel.add((Component)this.colorPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.panel.add((Component)this.label, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
                this.panel.setBackground(Color.white);
                this.label.setBackground(Color.white);
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                String txt;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Object userObject = node.getUserObject();
                if (userObject instanceof LayerTreeModel.ColorThemingValue) {
                    LayerTreeModel.ColorThemingValue entry = (LayerTreeModel.ColorThemingValue)userObject;
                    txt = entry.toString();
                    this.colorPanel.setPreferredSize(new Dimension(10, 10));
                    BasicStyle style = entry.getStyle();
                    this.colorPanel.setLineColor(style.isRenderingLine() ? GUIUtil.alphaColor(style.getLineColor(), style.getAlpha()) : GUIUtil.alphaColor(Color.BLACK, 0));
                    this.colorPanel.setFillColor(style.isRenderingFill() ? GUIUtil.alphaColor(style.getFillColor(), style.getAlpha()) : GUIUtil.alphaColor(Color.BLACK, 0));
                } else if (userObject instanceof Layer) {
                    Layer layer = (Layer)userObject;
                    txt = layer.getName();
                    this.colorPanel.setPreferredSize(new Dimension(10, 10));
                    BasicStyle style = layer.getBasicStyle();
                    this.colorPanel.setLineColor(style.isRenderingLine() ? GUIUtil.alphaColor(style.getLineColor(), style.getAlpha()) : GUIUtil.alphaColor(Color.BLACK, 0));
                    this.colorPanel.setFillColor(style.isRenderingFill() ? GUIUtil.alphaColor(style.getFillColor(), style.getAlpha()) : GUIUtil.alphaColor(Color.BLACK, 0));
                } else {
                    txt = (String)userObject;
                    this.colorPanel.setPreferredSize(new Dimension(0, 0));
                }
                this.label.setText(txt);
                return this.panel;
            }
        };
    }
}

