/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.wms;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.wms.AbstractParser;
import com.vividsolutions.wms.BasicRequest;
import com.vividsolutions.wms.Capabilities;
import com.vividsolutions.wms.MapRequest;
import com.vividsolutions.wms.ParserWMS1_0;
import com.vividsolutions.wms.ParserWMS1_1;
import com.vividsolutions.wms.ParserWMS1_3;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.swing.JOptionPane;
import org.openjump.util.UriUtil;

public class WMService {
    public static final String WMS_1_0_0 = "1.0.0";
    public static final String WMS_1_1_0 = "1.1.0";
    public static final String WMS_1_1_1 = "1.1.1";
    public static final String WMS_1_3_0 = "1.3.0";
    private final List<String> serverUrlPossibleParameter = Arrays.asList("MAP");
    private final URL serverUrl;
    private final String apiKeyNameAndValue;
    private final boolean isApiKeyNeededForGetCapabilities;
    private String wmsVersion = "1.1.1";
    private Capabilities cap;

    public WMService(String serverUrl, String wmsVersion, String apiKeyNameAndValue, boolean apiKeyNeededFotGetCapabilities) {
        try {
            this.serverUrl = new URL(serverUrl);
            this.apiKeyNameAndValue = apiKeyNameAndValue;
            this.isApiKeyNeededForGetCapabilities = apiKeyNeededFotGetCapabilities;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        if (wmsVersion != null) {
            this.wmsVersion = wmsVersion;
        }
        this.cap = null;
    }

    public WMService(String serverUrl, String wmsVersion) {
        try {
            this.serverUrl = new URL(serverUrl);
            this.apiKeyNameAndValue = null;
            this.isApiKeyNeededForGetCapabilities = false;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        if (wmsVersion != null) {
            this.wmsVersion = wmsVersion;
        }
        this.cap = null;
    }

    public WMService(String serverUrl) {
        this(serverUrl, null);
    }

    public void initialize() throws IOException {
        this.initialize(false);
    }

    public String getWmsVersion() {
        return this.wmsVersion;
    }

    public void initialize(boolean alertDifferingURL) throws IOException {
        String compare_url2;
        String req = "request=capabilities&WMTVER=1.0";
        AbstractParser parser = new ParserWMS1_1();
        if (WMS_1_0_0.equals(this.wmsVersion)) {
            req = "SERVICE=WMS&VERSION=1.0.0&REQUEST=GetCapabilities";
            parser = new ParserWMS1_0();
        } else if (WMS_1_1_0.equals(this.wmsVersion)) {
            req = "SERVICE=WMS&VERSION=1.1.0&REQUEST=GetCapabilities";
            parser = new ParserWMS1_1();
        } else if (WMS_1_1_1.equals(this.wmsVersion)) {
            req = "SERVICE=WMS&VERSION=1.1.1&REQUEST=GetCapabilities";
            parser = new ParserWMS1_1();
        } else if (WMS_1_3_0.equals(this.wmsVersion)) {
            req = "SERVICE=WMS&VERSION=1.3.0&REQUEST=GetCapabilities";
            parser = new ParserWMS1_3();
        }
        String requestUrlString = UriUtil.urlMakeAppendSafe(this.serverUrl.toString()) + req;
        if (this.apiKeyNameAndValue != null && this.isApiKeyNeededForGetCapabilities) {
            requestUrlString = requestUrlString.endsWith("?") ? requestUrlString + this.apiKeyNameAndValue : requestUrlString + "&" + this.apiKeyNameAndValue;
        }
        URL requestUrl = new URL(requestUrlString);
        InputStream inputStream = new BasicRequest(this, requestUrl).getInputStream();
        this.cap = parser.parseCapabilities(this, inputStream);
        String url1 = this.cap.getService().getServerUrl();
        String url2 = this.cap.getGetMapURL();
        String noAuth_url1 = UriUtil.urlStripAuth(url1);
        String noAuth_url2 = UriUtil.urlStripAuth(url2);
        String compare_url1 = UriUtil.urlMakeAppendSafe(noAuth_url1);
        if (!compare_url1.equals(compare_url2 = UriUtil.urlMakeAppendSafe(noAuth_url2)) && alertDifferingURL) {
            int resp = JOptionPane.showConfirmDialog(null, I18N.getInstance().get("com.vididsolutions.wms.WMService.Other-GetMap-URL-Found", noAuth_url2, noAuth_url1), null, 0);
            if (resp == 1) {
                this.cap.setGetMapURL(url1);
            } else if (!UriUtil.urlGetUser(url1).isEmpty()) {
                String url2_withAuth = UriUtil.urlAddCredentials(url2, UriUtil.urlGetUser(url1), UriUtil.urlGetPassword(url1));
                this.cap.setGetMapURL(url2_withAuth);
            }
        } else {
            this.cap.setGetMapURL(url1);
        }
    }

    public String getServerUrl() {
        return this.serverUrl.toString();
    }

    public URL getServerUrlAsUrl() {
        return this.serverUrl;
    }

    public String getTitle() {
        return this.cap.getTitle();
    }

    public Capabilities getCapabilities() {
        return this.cap;
    }

    public MapRequest createMapRequest() {
        MapRequest mr = new MapRequest(this);
        mr.setWMSVersion(this.wmsVersion);
        return mr;
    }

    public String getVersion() {
        return this.wmsVersion;
    }
}

