/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.wms;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.wms.BoundingBox;
import com.vividsolutions.wms.Capabilities;
import com.vividsolutions.wms.MapLayer;
import com.vividsolutions.wms.MapStyle;
import com.vividsolutions.wms.WMSException;
import com.vividsolutions.wms.WMService;
import com.vividsolutions.wms.util.XMLTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Parser {
    public Capabilities parseCapabilities(WMService service, InputStream inStream) throws IOException {
        if ("1.1.1".equals(service.getVersion()) || "1.1.0".equals(service.getVersion())) {
            return this.parseCapabilities_1_1_1(service, inStream);
        }
        return this.parseCapabilities_1_0_0(service, inStream);
    }

    public MapLayer wmsLayerFromNode(Node layerNode) {
        String name = null;
        String title = null;
        LinkedList<String> srsList = new LinkedList<String>();
        LinkedList<MapLayer> subLayers = new LinkedList<MapLayer>();
        BoundingBox bbox = null;
        ArrayList<MapStyle> styles = new ArrayList<MapStyle>();
        ArrayList<BoundingBox> boundingBoxList = new ArrayList<BoundingBox>();
        NodeList nl = layerNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            try {
                if (n.getNodeType() != 1) continue;
                if (n.getNodeName().equals("Name")) {
                    name = ((CharacterData)n.getFirstChild()).getData();
                    continue;
                }
                if (n.getNodeName().equals("Title")) {
                    title = ((CharacterData)n.getFirstChild()).getData();
                    continue;
                }
                if (n.getNodeName().equals("SRS")) {
                    String srsStr = ((CharacterData)n.getFirstChild()).getData();
                    while (srsStr.length() > 0) {
                        int ws = srsStr.indexOf(32);
                        if (ws > 0) {
                            srsList.add(srsStr.substring(0, ws));
                            srsStr = srsStr.substring(ws + 1);
                            continue;
                        }
                        if (srsStr.length() <= 0) continue;
                        srsList.add(srsStr);
                        srsStr = "";
                    }
                    continue;
                }
                if (n.getNodeName().equals("LatLonBoundingBox")) {
                    bbox = this.boundingBoxFromNode(n);
                    boundingBoxList.add(bbox);
                    continue;
                }
                if (n.getNodeName().equals("BoundingBox")) {
                    bbox = this.boundingBoxFromNode(n);
                    boundingBoxList.add(bbox);
                    continue;
                }
                if (n.getNodeName().equals("Layer")) {
                    subLayers.add(this.wmsLayerFromNode(n));
                    continue;
                }
                if (!n.getNodeName().equals("Style")) continue;
                String styleName = "";
                String titleName = "";
                String legendFormat = "";
                String url = "";
                int h = 0;
                int w = 0;
                NodeList nodeStyle = n.getChildNodes();
                for (int k = 0; k < nodeStyle.getLength(); ++k) {
                    Node n1 = nodeStyle.item(k);
                    if (n1.getNodeName().equals("Name")) {
                        styleName = ((CharacterData)n1.getFirstChild()).getData();
                        continue;
                    }
                    if (n1.getNodeName().equals("Title") & n1.hasChildNodes()) {
                        titleName = ((CharacterData)n1.getFirstChild()).getData();
                        continue;
                    }
                    if (!n1.getNodeName().equals("LegendURL")) continue;
                    try {
                        h = Integer.parseInt(n1.getAttributes().getNamedItem("height").getNodeValue());
                        w = Integer.parseInt(n1.getAttributes().getNamedItem("width").getNodeValue());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new Exception(e.toString());
                    }
                    NodeList nodelegend = n1.getChildNodes();
                    for (int k1 = 0; k1 < nodelegend.getLength(); ++k1) {
                        Node n2 = nodelegend.item(k1);
                        if (n2.getNodeName().equals("Format")) {
                            legendFormat = ((CharacterData)n2.getFirstChild()).getData();
                            continue;
                        }
                        if (!n2.getNodeName().equals("OnlineResource")) continue;
                        url = n2.getAttributes().getNamedItem("xlink:href").getNodeValue();
                    }
                }
                styles.add(new MapStyle(styleName, titleName, url, legendFormat, w, h));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Logger.error("Exception caught in wmsLayerFromNode(): " + e.toString());
            }
        }
        return new MapLayer(name, title, srsList, subLayers, bbox, boundingBoxList, styles);
    }

    public BoundingBox boundingBoxFromNode(Node n) throws Exception {
        try {
            String srs = "";
            NamedNodeMap nm = n.getAttributes();
            if (n.getNodeName().equals("LatLonBoundingBox")) {
                srs = "LatLon";
            } else if (n.getNodeName().equals("BoundingBox")) {
                srs = nm.getNamedItem("SRS").getNodeValue();
            }
            double minx = nm.getNamedItem("minx").getNodeValue().equals("inf") ? Double.NEGATIVE_INFINITY : Double.parseDouble(nm.getNamedItem("minx").getNodeValue());
            double miny = nm.getNamedItem("miny").getNodeValue().equals("inf") ? Double.NEGATIVE_INFINITY : Double.parseDouble(nm.getNamedItem("miny").getNodeValue());
            double maxx = nm.getNamedItem("maxx").getNodeValue().equals("inf") ? Double.POSITIVE_INFINITY : Double.parseDouble(nm.getNamedItem("maxx").getNodeValue());
            double maxy = nm.getNamedItem("maxy").getNodeValue().equals("inf") ? Double.POSITIVE_INFINITY : Double.parseDouble(nm.getNamedItem("maxy").getNodeValue());
            return new BoundingBox(srs, minx, miny, maxx, maxy);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(I18N.getInstance().get("com.vividsolutions.wms.Parser.invalid-bounding-box-element-node") + ": " + e.toString());
        }
    }

    private Capabilities parseCapabilities_1_0_0(WMService service, InputStream inStream) throws IOException {
        Document doc;
        MapLayer topLayer = null;
        String title = "";
        LinkedList<String> formatList = new LinkedList<String>();
        try {
            DOMParser parser = new DOMParser();
            parser.setFeature("http://xml.org/sax/features/validation", false);
            parser.parse(new InputSource(inStream));
            doc = parser.getDocument();
        }
        catch (SAXException saxe) {
            throw new IOException(saxe.toString());
        }
        try {
            title = ((CharacterData)XMLTools.simpleXPath(doc, "WMT_MS_Capabilities/Service/Title").getFirstChild()).getData();
        }
        catch (Exception e) {
            Logger.warn("<Title/> unset or empty.", e);
        }
        Node formatNode = XMLTools.simpleXPath(doc, "WMT_MS_Capabilities/Capability/Request/Map/Format");
        NodeList nl = formatNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            formatList.add(n.getNodeName());
        }
        topLayer = this.wmsLayerFromNode(XMLTools.simpleXPath(doc, "WMT_MS_Capabilities/Capability/Layer"));
        return new Capabilities(service, title, topLayer, formatList, this.getInfoFormats(doc, "WMT_MS_Capabilities"));
    }

    private Capabilities parseCapabilities_1_1_1(WMService service, InputStream inStream) throws IOException {
        Document doc;
        MapLayer topLayer = null;
        String title = "";
        LinkedList<String> formatList = new LinkedList<String>();
        try {
            DOMParser parser = new DOMParser();
            parser.setFeature("http://xml.org/sax/features/validation", false);
            parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            InputStreamReader ireader = new InputStreamReader(inStream);
            parser.parse(new InputSource(ireader));
            doc = parser.getDocument();
        }
        catch (SAXException saxe) {
            throw new IOException(saxe.toString());
        }
        if (XMLTools.simpleXPath(doc, "WMT_MS_Capabilities") == null) {
            String str = "";
            try {
                DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
                LSSerializer writer = impl.createLSSerializer();
                str = writer.writeToString(doc);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            throw new WMSException("Unexpected answer from server. Missing node <WMT_MS_Capabilities>.", str);
        }
        try {
            title = ((CharacterData)XMLTools.simpleXPath(doc, "WMT_MS_Capabilities/Service/Title").getFirstChild()).getData();
        }
        catch (Exception e) {
            Logger.warn("<Title/> unset or empty.", e);
        }
        Node formatNode = XMLTools.simpleXPath(doc, "WMT_MS_Capabilities/Capability/Request/GetMap");
        NodeList nl = formatNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !"Format".equals(n.getNodeName())) continue;
            formatList.add(n.getFirstChild().getNodeValue());
        }
        String xp = "DCPType/HTTP/Get/OnlineResource";
        String xlink = "http://www.w3.org/1999/xlink";
        Element e = (Element)XMLTools.simpleXPath(formatNode, xp);
        String getMapURL = e.getAttributeNS(xlink, "href");
        xp = "WMT_MS_Capabilities/Capability/Request/GetFeatureInfo/DCPType/HTTP/Get/OnlineResource";
        e = (Element)XMLTools.simpleXPath(doc, xp);
        String getFeatureInfoURL = e != null ? e.getAttributeNS(xlink, "href") : "";
        topLayer = this.wmsLayerFromNode(XMLTools.simpleXPath(doc, "WMT_MS_Capabilities/Capability/Layer"));
        return new Capabilities(service, title, topLayer, formatList, this.getInfoFormats(doc, "WMT_MS_Capabilities"), getMapURL, getFeatureInfoURL);
    }

    protected LinkedList<String> getInfoFormats(Document doc, String rootPath) {
        Node formatNode = XMLTools.simpleXPath(doc, rootPath + "/Capability/Request/GetMap");
        NodeList nl = formatNode.getChildNodes();
        Node infoFormatNode = XMLTools.simpleXPath(doc, "WMT_MS_Capabilities/Capability/Request/GetFeatureInfo");
        LinkedList<String> infoFormatList = new LinkedList<String>();
        if (infoFormatNode != null) {
            nl = infoFormatNode.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (n.getNodeType() != 1 || !"Format".equals(n.getNodeName())) continue;
                infoFormatList.add(n.getFirstChild().getNodeValue());
            }
        }
        return infoFormatList;
    }
}

