/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.wms;

import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.wms.WMSException;
import com.vividsolutions.wms.WMSRequest;
import com.vividsolutions.wms.WMService;
import java.awt.Image;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.openjump.util.URLConnectionProvider;

public abstract class AbstractWMSRequest
implements WMSRequest {
    protected WMService service;
    protected String version;
    protected HttpURLConnection con = null;
    private static Pattern charsetPattern = null;

    protected AbstractWMSRequest(WMService service) {
        this.service = service;
        this.version = service.getWmsVersion();
    }

    @Override
    public WMService getService() {
        return this.service;
    }

    @Override
    public void setWMSVersion(String version) {
        this.version = version;
    }

    @Override
    public abstract URL getURL() throws MalformedURLException;

    protected HttpURLConnection prepareConnection() throws IOException {
        URL requestUrl = this.getURL();
        this.con = URLConnectionProvider.getInstance().getHttpConnection(requestUrl, true);
        return this.con;
    }

    @Override
    public HttpURLConnection getConnection() throws IOException {
        if (this.con == null) {
            this.con = this.prepareConnection();
        }
        return this.con;
    }

    public Image getImage() throws IOException {
        HttpURLConnection con = this.getConnection();
        boolean httpOk = con.getResponseCode() == 200;
        boolean isImage = false;
        if (httpOk) {
            for (Map.Entry<String, List<String>> entry : con.getHeaderFields().entrySet()) {
                String key = entry.getKey() != null ? entry.getKey() : "";
                String value = null;
                try {
                    value = entry.getValue().get(0).toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!key.matches("^(?i)Content-Type$") || !value.matches("^(?i)image/.*")) continue;
                isImage = true;
            }
        }
        if (isImage) {
            return ImageIO.read(con.getInputStream());
        }
        this.readToError(con);
        return null;
    }

    public InputStream getInputStream() throws IOException {
        boolean httpOk;
        HttpURLConnection con = this.getConnection();
        boolean bl = httpOk = con.getResponseCode() == 200;
        if (!httpOk) {
            this.readToError(con);
        }
        return con.getInputStream();
    }

    public String getText() throws IOException {
        boolean httpOk;
        HttpURLConnection con = this.getConnection();
        boolean bl = httpOk = con.getResponseCode() == 200;
        if (!httpOk) {
            this.readToError(con);
        }
        return this.readConnection(con, 0L);
    }

    protected String readToError(HttpURLConnection con) throws IOException {
        String url = con.getURL().toExternalForm();
        String headers = con.getHeaderFields().toString();
        String result = this.readConnection(con, 1024L);
        throw new WMSException("Request url: " + url + "\nResponse code: " + con.getResponseCode() + "\nHeaders:\n" + headers + "\nResponse body:\n" + result);
    }

    protected String readConnection(HttpURLConnection con, long limit) throws IOException {
        boolean httpOk = con.getResponseCode() == 200;
        InputStream in = httpOk ? con.getInputStream() : con.getErrorStream();
        String contentType = con.getContentType();
        Charset charset = StandardCharsets.UTF_8;
        try {
            if (contentType != null) {
                Matcher matcher;
                if (charsetPattern == null) {
                    charsetPattern = Pattern.compile("(?i:charset)=[\"']?([\\w-]+)[\\\"']?");
                }
                if ((matcher = charsetPattern.matcher(contentType)).find()) {
                    String charsetName = matcher.group(1);
                    charset = Charset.forName(charsetName);
                }
            }
        }
        catch (Exception e) {
            Logger.error("Content-type charset raised error. " + contentType, e);
        }
        String result = "";
        if (in != null) {
            BoundedInputStream bin = new BoundedInputStream(in, limit > 0L ? limit : -1L);
            result = IOUtils.toString((InputStream)bin, (Charset)charset);
            FileUtil.close((Closeable)bin);
        }
        return result;
    }
}

