/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.toolbox;

import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.CheckBoxed;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxDialog;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;

public abstract class ToolboxPlugIn
extends AbstractPlugIn
implements CheckBoxed {
    private static HashMap toolboxMap = new HashMap();

    public ToolboxDialog getToolbox() {
        return this.getToolbox(JUMPWorkbench.getInstance().getContext());
    }

    public ToolboxDialog getToolbox(WorkbenchContext context) {
        String name = this.getName();
        ToolboxDialog toolbox = (ToolboxDialog)toolboxMap.get(name);
        if (toolbox == null) {
            toolbox = new ToolboxDialog(context);
            toolbox.setTitle(name);
            this.initializeToolbox(toolbox);
            toolbox.finishAddingComponents();
            toolboxMap.put(name, toolbox);
        }
        return toolbox;
    }

    protected abstract void initializeToolbox(ToolboxDialog var1);

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        ToolboxDialog tb = this.getToolbox(context.getWorkbenchContext());
        tb.setVisible(!this.getToolbox(context.getWorkbenchContext()).isVisible());
        return true;
    }

    public void createMainMenuItem(String[] menuPath, Icon icon, WorkbenchContext context) throws Exception {
        FeatureInstaller.getInstance(context).addMainMenuPlugin(this, menuPath, this.getName() + "...", true, icon, this.getEnableCheck());
    }

    @Override
    public EnableCheck getEnableCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                String name = ToolboxPlugIn.this.getName();
                ToolboxDialog tb = (ToolboxDialog)toolboxMap.get(name);
                if (component instanceof JCheckBoxMenuItem) {
                    ((JCheckBoxMenuItem)component).setSelected(tb != null && tb.isVisible());
                }
                return null;
            }
        };
    }
}

