/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.ImageCachingFeatureCollectionRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.Renderer;
import com.vividsolutions.jump.workbench.ui.renderer.SimpleFeatureCollectionRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import java.awt.Graphics2D;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class FeatureCollectionRenderer
implements Renderer {
    private int maxFeatures = 100;
    private ImageCachingFeatureCollectionRenderer imageCachingFeatureCollectionRenderer;
    private SimpleFeatureCollectionRenderer simpleFeatureCollectionRenderer;
    private Renderer currentFeatureCollectionRenderer;

    public FeatureCollectionRenderer(Object contentID, LayerViewPanel panel) {
        this(contentID, panel, new ImageCachingFeatureCollectionRenderer(contentID, panel));
    }

    public FeatureCollectionRenderer(Object contentID, LayerViewPanel panel, ImageCachingFeatureCollectionRenderer imageCachingFeatureCollectionRenderer) {
        this.imageCachingFeatureCollectionRenderer = imageCachingFeatureCollectionRenderer;
        this.simpleFeatureCollectionRenderer = new SimpleFeatureCollectionRenderer(contentID, panel);
        this.currentFeatureCollectionRenderer = this.simpleFeatureCollectionRenderer;
    }

    @Override
    public void clearImageCache() {
        this.imageCachingFeatureCollectionRenderer.clearImageCache();
        this.simpleFeatureCollectionRenderer.clearImageCache();
    }

    @Override
    public boolean isRendering() {
        return this.currentFeatureCollectionRenderer.isRendering();
    }

    @Override
    public Object getContentID() {
        return this.currentFeatureCollectionRenderer.getContentID();
    }

    @Override
    public void copyTo(Graphics2D graphics) {
        this.currentFeatureCollectionRenderer.copyTo(graphics);
    }

    @Override
    public Runnable createRunnable() {
        Map<Layer, Collection<Feature>> layerToFeaturesMap = this.layerToFeaturesMap();
        Collection<Style> styles = this.styles();
        this.imageCachingFeatureCollectionRenderer.setLayerToFeaturesMap(layerToFeaturesMap);
        this.imageCachingFeatureCollectionRenderer.setStyles(styles);
        this.simpleFeatureCollectionRenderer.setLayerToFeaturesMap(layerToFeaturesMap);
        this.simpleFeatureCollectionRenderer.setStyles(styles);
        this.currentFeatureCollectionRenderer = this.useImageCaching(layerToFeaturesMap) ? this.imageCachingFeatureCollectionRenderer : this.simpleFeatureCollectionRenderer;
        return this.currentFeatureCollectionRenderer.createRunnable();
    }

    protected boolean useImageCaching(Map<Layer, List<Feature>> layerToFeaturesMap) {
        return this.featureCount(layerToFeaturesMap) >= this.maxFeatures;
    }

    private int featureCount(Map<Layer, List<Feature>> layerToFeaturesMap) {
        int count = 0;
        for (List<Feature> features : layerToFeaturesMap.values()) {
            count += features.size();
        }
        return count;
    }

    protected abstract Map<Layer, Collection<Feature>> layerToFeaturesMap();

    protected abstract Collection<Style> styles();

    @Override
    public void cancel() {
        this.imageCachingFeatureCollectionRenderer.cancel();
        this.simpleFeatureCollectionRenderer.cancel();
    }

    public int getMaxFeatures() {
        return this.maxFeatures;
    }

    public void setMaxFeatures(int maxFeatures) {
        this.maxFeatures = maxFeatures;
    }

    public SimpleFeatureCollectionRenderer getSimpleFeatureCollectionRenderer() {
        return this.simpleFeatureCollectionRenderer;
    }
}

