/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.datastore;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;

public class DataStoreLayerWhereEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    JTextArea textArea = new ResizableTextArea();
    protected int clickCountToStart = 2;

    DataStoreLayerWhereEditor() {
        this.textArea.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.textArea.registerKeyboardAction(this, KeyStroke.getKeyStroke(10, 2), 0);
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public void setClickCountToStart(int clickCountToStart) {
        this.clickCountToStart = clickCountToStart;
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        return !(e instanceof MouseEvent) || ((MouseEvent)e).getClickCount() >= this.clickCountToStart;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.stopCellEditing();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        String text = value != null ? value.toString() : "";
        this.textArea.setText(text);
        return this.textArea;
    }

    @Override
    public Object getCellEditorValue() {
        return this.textArea.getText();
    }

    class ResizableTextArea
    extends JTextArea {
        DocumentListener listener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ResizableTextArea.this.updateBounds();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ResizableTextArea.this.updateBounds();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ResizableTextArea.this.updateBounds();
            }
        };

        ResizableTextArea() {
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.getDocument().addDocumentListener(this.listener);
            this.updateBounds();
        }

        @Override
        public void removeNotify() {
            this.getDocument().removeDocumentListener(this.listener);
            super.removeNotify();
        }

        private void updateBounds() {
            JTable table;
            if (this.getParent() instanceof JTable && (table = (JTable)this.getParent()).isEditing()) {
                Rectangle cellRect = table.getCellRect(table.getEditingRow(), table.getEditingColumn(), false);
                Dimension prefSize = this.getPreferredSize();
                this.setBounds(this.getX(), this.getY(), Math.max(cellRect.width, prefSize.width), Math.max(cellRect.height, prefSize.height));
                this.validate();
            }
        }
    }
}

