/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.clipboard;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.coordsys.CoordinateSystem;
import com.vividsolutions.jump.coordsys.Reprojector;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.WKTReader;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.CollectionOfFeaturesTransferable;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.openjump.core.ccordsys.srid.SRIDStyle;
import org.openjump.core.ui.images.IconLoader;

public class PasteItemsPlugIn
extends AbstractPlugIn {
    public static ImageIcon ICON = IconLoader.icon("items_paste.png");
    public static final String MUST_NOT_BE_EMPTY = I18N.getInstance().get("ui.plugin.PasteItemsPlugIn.clipboard-must-not-be-empty");
    public static final String MUST_CONTAIN_GEOMETRY = I18N.getInstance().get("ui.plugin.PasteItemsPlugIn.clipboard-must-contain-geometries-or-wkt");
    private static final String DECIMAL_PATTERN = "\\d+(?:\\.\\d+)?";
    private static final String WHITESPACE_OR_COMMA = "(?:\\s+|(?:\\s*,\\s*))";
    private static final Pattern pointCoordsPattern = Pattern.compile("\\s*\\(?\\s*(\\d+(?:\\.\\d+)?)(?:\\s+|(?:\\s*,\\s*))(\\d+(?:\\.\\d+)?)(?:(?:\\s+|(?:\\s*,\\s*))(\\d+(?:\\.\\d+)?))?\\s*\\)?\\s*");
    private WKTReader reader = new WKTReader();

    public PasteItemsPlugIn() {
        this.setShortcutKeys(86);
        this.setShortcutModifiers(2);
    }

    protected PasteItemsPlugIn(String name) {
        super(name);
    }

    public String getNameWithMnemonic() {
        return StringUtil.replace(this.getName(), "P", "&P", false);
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(final PlugInContext context) throws Exception {
        Collection<Feature> features;
        this.reportNothingToUndoYet(context);
        Transferable transferable = GUIUtil.getContents(Toolkit.getDefaultToolkit().getSystemClipboard());
        if (transferable.isDataFlavorSupported(CollectionOfFeaturesTransferable.COLLECTION_OF_FEATURES_FLAVOR)) {
            features = (Collection<Feature>)GUIUtil.getContents(Toolkit.getDefaultToolkit().getSystemClipboard()).getTransferData(CollectionOfFeaturesTransferable.COLLECTION_OF_FEATURES_FLAVOR);
        } else {
            String value = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            features = this.processCoordinates(value);
            if (features.isEmpty()) {
                features = this.reader.read(new StringReader(value)).getFeatures();
            }
        }
        final Layer layer = context.getSelectedLayer(0);
        final Collection featureCopies = PasteItemsPlugIn.conform(features, layer.getFeatureCollectionWrapper().getFeatureSchema());
        this.execute(new UndoableCommand(this.getName()){

            @Override
            public void execute() {
                layer.getFeatureCollectionWrapper().addAll(featureCopies);
                context.getLayerViewPanel().getSelectionManager().getFeatureSelection().unselectItems();
                context.getLayerViewPanel().getSelectionManager().getFeatureSelection().selectItems(layer, featureCopies);
                if (layer.getStyle(SRIDStyle.class) != null) {
                    ((SRIDStyle)layer.getStyle(SRIDStyle.class)).updateSRIDs(layer);
                }
            }

            @Override
            public void unexecute() {
                layer.getFeatureCollectionWrapper().removeAll(featureCopies);
            }
        }, context);
        return true;
    }

    private Collection<Feature> processCoordinates(String value) {
        Matcher matcher = pointCoordsPattern.matcher(value);
        ArrayList<Feature> features = new ArrayList<Feature>();
        if (matcher.find() && matcher.start() == 0) {
            do {
                double x = Double.parseDouble(matcher.group(1));
                double y = Double.parseDouble(matcher.group(2));
                Coordinate coordinate = new Coordinate(x, y);
                String zString = matcher.group(3);
                if (zString != null) {
                    coordinate.z = Double.parseDouble(zString);
                }
                FeatureSchema featureSchema = new FeatureSchema();
                featureSchema.addAttribute("Geometry", AttributeType.GEOMETRY);
                BasicFeature feature = new BasicFeature(featureSchema);
                Point point = new GeometryFactory().createPoint(coordinate);
                feature.setGeometry((Geometry)point);
                features.add(feature);
            } while (matcher.find());
        }
        return features;
    }

    public static Collection conform(Collection features, FeatureSchema targetFeatureSchema) {
        ArrayList<Feature> featureCopies = new ArrayList<Feature>();
        for (Feature feature : features) {
            featureCopies.add(PasteItemsPlugIn.conform(feature, targetFeatureSchema));
        }
        return featureCopies;
    }

    private static Feature conform(Feature original, FeatureSchema targetFeatureSchema) {
        BasicFeature copy = new BasicFeature(targetFeatureSchema);
        copy.setGeometry((Geometry)original.getGeometry().clone());
        for (int i = 0; i < original.getSchema().getAttributeCount(); ++i) {
            if (i == original.getSchema().getGeometryIndex()) continue;
            String attributeName = original.getSchema().getAttributeName(i);
            if (!copy.getSchema().hasAttribute(attributeName) || copy.getSchema().getAttributeType(attributeName) != original.getSchema().getAttributeType(attributeName) || copy.getSchema().getAttributeIndex(attributeName) == copy.getSchema().getExternalPrimaryKeyIndex()) continue;
            copy.setAttribute(attributeName, original.getAttribute(attributeName));
        }
        if (original.getSchema().getCoordinateSystem() != CoordinateSystem.UNSPECIFIED && copy.getSchema().getCoordinateSystem() != CoordinateSystem.UNSPECIFIED) {
            Reprojector.instance().reproject(copy.getGeometry(), original.getSchema().getCoordinateSystem(), copy.getSchema().getCoordinateSystem());
        }
        return copy;
    }

    public static MultiEnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1)).add(checkFactory.createSelectedLayersMustBeEditableCheck()).add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                Transferable transferable = GUIUtil.getContents(Toolkit.getDefaultToolkit().getSystemClipboard());
                if (transferable == null) {
                    return MUST_NOT_BE_EMPTY;
                }
                if (transferable.isDataFlavorSupported(CollectionOfFeaturesTransferable.COLLECTION_OF_FEATURES_FLAVOR)) {
                    return null;
                }
                try {
                    String value;
                    if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor) && (this.isWKT(value = (String)transferable.getTransferData(DataFlavor.stringFlavor)) || this.isCoordinates(value))) {
                        return null;
                    }
                }
                catch (Exception e) {
                    workbenchContext.getWorkbench().getFrame().warnUser(e.getMessage());
                }
                return MUST_CONTAIN_GEOMETRY;
            }

            private boolean isCoordinates(String value) {
                return pointCoordsPattern.matcher(value).find();
            }

            private boolean isWKT(String s) {
                try {
                    new WKTReader().read(new StringReader(s));
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        });
    }

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }
}

