/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureDatasetFactory;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.FeatureUtil;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.Collection;
import java.util.List;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.operation.overlayng.OverlayNGRobust;
import org.locationtech.jts.operation.overlayng.UnaryUnionNG;
import org.locationtech.jts.operation.union.UnaryUnionOp;

public class UnionPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private final String LAYER = I18N.JUMP.get("ui.plugin.analysis.UnionPlugIn.layer");
    private final String SELECTED_ONLY = I18N.JUMP.get("ui.plugin.analysis.UnionPlugIn.selected-features-only");
    private final String LEGACY_ALGO = I18N.JUMP.get("ui.plugin.analysis.UnionPlugIn.legacy-algo");
    private final String LEGACY_ALGO_TT = I18N.JUMP.get("ui.plugin.analysis.UnionPlugIn.legacy-algo-tt");
    private final String OVERLAY_NG_ALGO = I18N.JUMP.get("ui.plugin.analysis.UnionPlugIn.overlay-ng-algo");
    private final String OVERLAY_NG_ALGO_TT = I18N.JUMP.get("ui.plugin.analysis.UnionPlugIn.overlay-ng-algo-tt");
    private final String FLOATING_PRECISION_MODEL = I18N.JUMP.get("ui.plugin.analysis.UnionPlugIn.floating-precision-model");
    private final String FLOATING_PRECISION_MODEL_TT = I18N.JUMP.get("ui.plugin.analysis.UnionPlugIn.floating-precision-model-tt");
    private final String FIXED_PRECISION_MODEL = I18N.JUMP.get("ui.plugin.analysis.UnionPlugIn.fixed-precision-model");
    private final String FIXED_PRECISION_MODEL_TT = I18N.JUMP.get("ui.plugin.analysis.UnionPlugIn.fixed-precision-model-tt");
    private final String PRECISION = I18N.JUMP.get("ui.plugin.analysis.UnionPlugIn.fixed-precision-model");
    private final String PRECISION_TT = I18N.JUMP.get("ui.plugin.analysis.UnionPlugIn.fixed-precision-model-tt");
    private boolean useSelected = false;
    private boolean overlayNgAlgo = true;
    private boolean legacyAlgo = false;
    private boolean floatingPrecision = true;
    private boolean fixedPrecision = false;
    private double precision = 0.001;
    private MultiInputDialog dialog;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_ANALYSIS}, this.getName() + "...", false, null, UnionPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        int n = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems().size();
        this.useSelected = n > 0;
        this.initDialog(context);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    private void initDialog(PlugInContext context) {
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), I18N.getInstance().get("ui.plugin.analysis.UnionPlugIn.union"), true);
        if (this.useSelected) {
            this.dialog.setSideBarDescription(I18N.getInstance().get("ui.plugin.analysis.UnionPlugIn.creates-a-new-layer-containing-the-union-of-selected-features-in-the-input-layer"));
        } else {
            this.dialog.setSideBarDescription(I18N.getInstance().get("ui.plugin.analysis.UnionPlugIn.creates-a-new-layer-containing-the-union-of-all-the-features-in-the-input-layer"));
        }
        if (this.useSelected) {
            this.dialog.addLabel(this.SELECTED_ONLY);
        } else {
            this.dialog.addLayerComboBox(this.LAYER, context.getCandidateLayer(0), null, context.getLayerManager());
        }
        JRadioButton overlayNgAlgoRB = this.dialog.addRadioButton(this.OVERLAY_NG_ALGO, "ALGO_TYPE", this.overlayNgAlgo, this.OVERLAY_NG_ALGO_TT);
        JRadioButton legacyAlgoRB = this.dialog.addRadioButton(this.LEGACY_ALGO, "ALGO_TYPE", this.legacyAlgo, this.LEGACY_ALGO_TT);
        JRadioButton floatingPrecisionRB = this.dialog.addRadioButton(this.FLOATING_PRECISION_MODEL, "MODEL", this.floatingPrecision, this.FLOATING_PRECISION_MODEL_TT);
        JRadioButton fixedPrecisionRB = this.dialog.addRadioButton(this.FIXED_PRECISION_MODEL, "MODEL", this.fixedPrecision, this.FIXED_PRECISION_MODEL_TT);
        JTextField precisionModelTF = this.dialog.addDoubleField(this.PRECISION, this.precision, 12, this.PRECISION_TT);
        legacyAlgoRB.addActionListener(e -> {
            floatingPrecisionRB.setEnabled(!legacyAlgoRB.isSelected());
            fixedPrecisionRB.setEnabled(!legacyAlgoRB.isSelected());
            precisionModelTF.setEnabled(!legacyAlgoRB.isSelected() && fixedPrecisionRB.isSelected());
        });
        overlayNgAlgoRB.addActionListener(e -> {
            floatingPrecisionRB.setEnabled(overlayNgAlgoRB.isSelected());
            fixedPrecisionRB.setEnabled(overlayNgAlgoRB.isSelected());
            precisionModelTF.setEnabled(overlayNgAlgoRB.isSelected() && fixedPrecisionRB.isSelected());
        });
        floatingPrecisionRB.addActionListener(e -> precisionModelTF.setEnabled(!floatingPrecisionRB.isSelected()));
        fixedPrecisionRB.addActionListener(e -> precisionModelTF.setEnabled(fixedPrecisionRB.isSelected()));
        GUIUtil.centreOnWindow(this.dialog);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.legacyAlgo = dialog.getBoolean(this.LEGACY_ALGO);
        this.overlayNgAlgo = dialog.getBoolean(this.OVERLAY_NG_ALGO);
        this.floatingPrecision = dialog.getBoolean(this.FLOATING_PRECISION_MODEL);
        this.fixedPrecision = dialog.getBoolean(this.FIXED_PRECISION_MODEL);
        this.precision = dialog.getDouble(this.PRECISION);
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        FeatureCollection a;
        if (this.useSelected) {
            Collection<Feature> inputC = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
            FeatureSchema featureSchema = new FeatureSchema();
            featureSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
            a = new FeatureDataset(inputC, featureSchema);
        } else {
            a = this.dialog.getLayer(this.LAYER).getFeatureCollectionWrapper();
        }
        List<Geometry> geoms = FeatureUtil.toGeometries(a.getFeatures());
        Geometry g = this.legacyAlgo ? UnaryUnionOp.union(geoms) : (this.floatingPrecision ? OverlayNGRobust.union(geoms) : UnaryUnionNG.union(geoms, (PrecisionModel)new PrecisionModel(this.precision)));
        geoms.clear();
        geoms.add(g);
        FeatureCollection fc = FeatureDatasetFactory.createFromGeometry(geoms);
        context.getLayerManager().addCategory(StandardCategoryNames.RESULT);
        context.addLayer(StandardCategoryNames.RESULT, I18N.getInstance().get("ui.plugin.analysis.UnionPlugIn.union"), fc);
    }
}

