/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.plugin.analysis.GeometryPredicate;
import com.vividsolutions.jump.workbench.ui.plugin.analysis.SpatialJoinExecuter;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class SpatialJoinPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private Layer tgtLayerA;
    private Layer srcLayerB;
    private JTextField paramField;
    private Collection functionNames;
    private MultiInputDialog dialog;
    private String funcNameToRun;
    private GeometryPredicate functionToRun = null;
    private double[] params = new double[2];
    private String categoryName = StandardCategoryNames.RESULT;
    private static final String LAYER_A = GenericNames.LAYER_A + " (" + GenericNames.TARGET_LAYER + ")";
    private static final String LAYER_B = GenericNames.LAYER_B + " (" + GenericNames.SOURCE_LAYER + ")";
    private static final String PREDICATE = GenericNames.RELATION;
    private static final String PARAM = GenericNames.PARAMETER;

    public SpatialJoinPlugIn() {
        this.functionNames = GeometryPredicate.getNames();
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("ui.plugin.analysis.SpatialJoinPlugIn.Spatial-Join");
    }

    public void setCategoryName(String value) {
        this.categoryName = value;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_ANALYSIS}, this.getName() + "...", false, null, SpatialJoinPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(2));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(this.dialog, context);
        GUIUtil.centreOnWindow(this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        if (this.functionToRun == null) {
            return;
        }
        if (this.tgtLayerA == null) {
            return;
        }
        if (this.srcLayerB == null) {
            return;
        }
        monitor.report(I18N.getInstance().get("ui.plugin.analysis.SpatialJoinPlugIn.Executing-join") + " " + this.functionToRun.getName() + "...");
        FeatureCollectionWrapper tgtAFC = this.tgtLayerA.getFeatureCollectionWrapper();
        FeatureCollectionWrapper srcBFC = this.srcLayerB.getFeatureCollectionWrapper();
        SpatialJoinExecuter executer = new SpatialJoinExecuter(srcBFC, tgtAFC);
        FeatureCollection resultFC = executer.getResultFC();
        executer.execute(monitor, this.functionToRun, this.params, resultFC);
        if (monitor.isCancelRequested()) {
            return;
        }
        String outputLayerName = I18N.getInstance().get("ui.plugin.analysis.SpatialJoinPlugIn.Join") + "-" + this.funcNameToRun;
        context.getLayerManager().addCategory(this.categoryName);
        context.addLayer(this.categoryName, outputLayerName, resultFC);
        if (executer.isExceptionThrown()) {
            context.getWorkbenchFrame().warnUser("Errors found while executing query: " + executer.getException());
        }
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(I18N.getInstance().get("org.openjump.sigle.plugin.SpatialJoinPlugIn.Transfers-the-attributes-of-Layer-B-to-Layer-A-using-a-spatial-criterion"));
        Layer initLayer1 = this.tgtLayerA == null ? context.getCandidateLayer(0) : this.tgtLayerA;
        Layer initLayer2 = this.srcLayerB == null ? context.getCandidateLayer(1) : this.srcLayerB;
        dialog.addLayerComboBox(LAYER_A, initLayer1, context.getLayerManager());
        JComboBox<String> functionComboBox = dialog.addComboBox(PREDICATE, this.funcNameToRun, this.functionNames, null);
        functionComboBox.addItemListener(new MethodItemListener());
        this.paramField = dialog.addDoubleField(PARAM, this.params[0], 10);
        dialog.addLayerComboBox(LAYER_B, initLayer2, context.getLayerManager());
        this.updateUIForFunction(this.funcNameToRun);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.tgtLayerA = dialog.getLayer(LAYER_A);
        this.srcLayerB = dialog.getLayer(LAYER_B);
        this.funcNameToRun = dialog.getText(PREDICATE);
        this.functionToRun = GeometryPredicate.getPredicate(this.funcNameToRun);
        this.params[0] = dialog.getDouble(PARAM);
    }

    private void updateUIForFunction(String funcName) {
        boolean paramUsed = false;
        GeometryPredicate func = GeometryPredicate.getPredicate(funcName);
        if (func != null) {
            paramUsed = func.getParameterCount() > 0;
        }
        this.paramField.setEnabled(paramUsed);
        this.paramField.setOpaque(paramUsed);
    }

    private class MethodItemListener
    implements ItemListener {
        private MethodItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            SpatialJoinPlugIn.this.updateUIForFunction((String)e.getItem());
        }
    }
}

