/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.plugin.analysis.AttributePredicate;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Polygon;

public class AttributeQueryPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private static String ATTR_GEOMETRY_AREA = I18N.getInstance().get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.Area");
    private static String ATTR_GEOMETRY_LENGTH = I18N.getInstance().get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.Length");
    private static String ATTR_GEOMETRY_NUMPOINTS = I18N.getInstance().get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.NumPoints");
    private static String ATTR_GEOMETRY_NUMCOMPONENTS = I18N.getInstance().get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.NumComponents");
    private static String ATTR_GEOMETRY_NUMHOLES = I18N.getInstance().get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.NumHoles");
    private static String ATTR_GEOMETRY_ISCLOSED = I18N.getInstance().get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.IsClosed");
    private static String ATTR_GEOMETRY_ISEMPTY = I18N.getInstance().get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.IsEmpty");
    private static String ATTR_GEOMETRY_ISSIMPLE = I18N.getInstance().get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.IsSimple");
    private static String ATTR_GEOMETRY_ISVALID = I18N.getInstance().get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.IsValid");
    private static String ATTR_GEOMETRY_TYPE = I18N.getInstance().get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.Type");
    private static String ATTR_GEOMETRY_DIMENSION = I18N.getInstance().get("ui.plugin.analysis.AttributeQueryPlugIn.Geometry.Dimension");
    private Collection<String> functionNames;
    private Layer srcLayer;
    private String attrName;
    private String funcNameToRun;
    private String value = "";
    private boolean complementResult = false;
    private boolean caseInsensitive = false;
    private boolean createLayer = true;
    private String categoryName = StandardCategoryNames.RESULT;
    private static String LAYER = GenericNames.SOURCE_LAYER;
    private static String ATTRIBUTE = I18N.getInstance().get("ui.plugin.analysis.AttributeQueryPlugIn.Attribute");
    private static String PREDICATE = I18N.getInstance().get("ui.plugin.analysis.AttributeQueryPlugIn.Condition");
    private static String VALUE = I18N.getInstance().get("ui.plugin.analysis.AttributeQueryPlugIn.Value");
    private static String DIALOG_CASE_INSENSITIVE = I18N.getInstance().get("ui.plugin.analysis.AttributeQueryPlugIn.Case-Insensitive");
    private static String DIALOG_COMPLEMENT = I18N.getInstance().get("ui.plugin.analysis.SpatialQueryPlugIn.Complement-Result");
    private static String UPDATE_SRC = I18N.getInstance().get("ui.plugin.analysis.SpatialQueryPlugIn.Select-features-in-the-source-layer");
    private static String CREATE_LYR = I18N.getInstance().get("ui.plugin.analysis.SpatialQueryPlugIn.Create-a-new-layer-for-the-results");
    private JComboBox<String> attrComboBox;

    public AttributeQueryPlugIn() {
        this.functionNames = AttributePredicate.getNames();
    }

    public void setCategoryName(String value) {
        this.categoryName = value;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_QUERIES}, this.getName() + "...", false, null, AttributeQueryPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("ui.plugin.analysis.AttributeQueryPlugIn.Attribute-Query");
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.icon("fugue/regular-expression-search.png");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        if (this.srcLayer == null) {
            return false;
        }
        if (StringUtil.isEmpty(this.value)) {
            return false;
        }
        if (StringUtil.isEmpty(this.attrName)) {
            return false;
        }
        return !StringUtil.isEmpty(this.funcNameToRun);
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        monitor.report(I18N.getInstance().get("ui.plugin.analysis.SpatialQueryPlugIn.Executing-query") + "...");
        FeatureCollectionWrapper sourceFC = this.srcLayer.getFeatureCollectionWrapper();
        if (monitor.isCancelRequested()) {
            return;
        }
        FeatureCollection resultFC = this.executeQuery(sourceFC, this.attrName, this.value);
        if (this.createLayer) {
            String outputLayerName = this.srcLayer.getName() + "_" + this.attrName.replaceAll(".*\\.", "") + "_" + this.funcNameToRun + "_" + this.value;
            if (this.complementResult) {
                outputLayerName = outputLayerName + "_" + I18N.getInstance().get("ui.plugin.analysis.SpatialQueryPlugIn.Complement");
            }
            context.getLayerManager().addCategory(this.categoryName);
            context.addLayer(this.categoryName, outputLayerName, resultFC);
        } else {
            SelectionManager selectionManager = context.getLayerViewPanel().getSelectionManager();
            selectionManager.clear();
            selectionManager.getFeatureSelection().selectItems(this.srcLayer, resultFC.getFeatures());
        }
    }

    private FeatureCollection executeQuery(FeatureCollection sourceFC, String attrName, String value) {
        AttributePredicate pred = AttributePredicate.getPredicate(this.funcNameToRun, this.caseInsensitive);
        FeatureDataset resultFC = new FeatureDataset(sourceFC.getFeatureSchema());
        for (Feature f : sourceFC) {
            Object fVal = this.getValue(f, attrName);
            boolean predResult = pred.isTrue(fVal, value);
            if (this.complementResult) {
                boolean bl = predResult = !predResult;
            }
            if (!predResult) continue;
            if (this.createLayer) {
                resultFC.add(f.clone(true));
                continue;
            }
            resultFC.add(f);
        }
        return resultFC;
    }

    private Object getValue(Feature f, String attrName) {
        if (attrName.equals(ATTR_GEOMETRY_AREA)) {
            Geometry g = f.getGeometry();
            return g == null ? 0.0 : g.getArea();
        }
        if (attrName.equals(ATTR_GEOMETRY_LENGTH)) {
            Geometry g = f.getGeometry();
            return g == null ? 0.0 : g.getLength();
        }
        if (attrName.equals(ATTR_GEOMETRY_NUMPOINTS)) {
            Geometry g = f.getGeometry();
            return g == null ? 0.0 : (double)g.getNumPoints();
        }
        if (attrName.equals(ATTR_GEOMETRY_NUMCOMPONENTS)) {
            Geometry g = f.getGeometry();
            return g == null ? 0.0 : (double)g.getNumGeometries();
        }
        if (attrName.equals(ATTR_GEOMETRY_NUMHOLES)) {
            Geometry g = f.getGeometry();
            int numHoles = 0;
            for (int i = 0; i < g.getNumGeometries(); ++i) {
                if (!(g.getGeometryN(i) instanceof Polygon)) continue;
                numHoles += ((Polygon)g.getGeometryN(i)).getNumInteriorRing();
            }
            return numHoles;
        }
        if (attrName.equals(ATTR_GEOMETRY_ISCLOSED)) {
            Geometry g = f.getGeometry();
            if (g instanceof LineString) {
                return ((LineString)g).isClosed();
            }
            if (g instanceof MultiLineString) {
                return ((MultiLineString)g).isClosed();
            }
            return false;
        }
        if (attrName.equals(ATTR_GEOMETRY_ISEMPTY)) {
            Geometry g = f.getGeometry();
            return g.isEmpty();
        }
        if (attrName.equals(ATTR_GEOMETRY_ISSIMPLE)) {
            Geometry g = f.getGeometry();
            return g.isSimple();
        }
        if (attrName.equals(ATTR_GEOMETRY_ISVALID)) {
            Geometry g = f.getGeometry();
            return g.isValid();
        }
        if (attrName.equals(ATTR_GEOMETRY_TYPE)) {
            Geometry g = f.getGeometry();
            return StringUtil.classNameWithoutQualifiers(g.getClass().getName());
        }
        if (attrName.equals(ATTR_GEOMETRY_DIMENSION)) {
            Geometry g = f.getGeometry();
            return g.getDimension();
        }
        return f.getAttribute(attrName);
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(I18N.getInstance().get("ui.plugin.analysis.AttributeQueryPlugIn.Finds-the-Source-features-which-have-attribute-values-satisfying-a-given-condition"));
        Layer initLayer = context.getCandidateLayer(0);
        JComboBox<Layer> lyrCombo = dialog.addLayerComboBox(LAYER, initLayer, context.getLayerManager());
        lyrCombo.addItemListener(new LayerItemListener());
        this.attrComboBox = dialog.addComboBox(ATTRIBUTE, this.attrName, this.functionNames, null);
        final JComboBox<String> dropBox = dialog.addComboBox(PREDICATE, this.funcNameToRun, this.functionNames, null);
        dialog.addTextField(VALUE, this.value, 20, null, null);
        final JCheckBox caseBox = dialog.addCheckBox(DIALOG_CASE_INSENSITIVE, this.caseInsensitive);
        caseBox.setEnabled(AttributeQueryPlugIn.caseBoxEnabled(dropBox));
        dropBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = AttributeQueryPlugIn.caseBoxEnabled(dropBox);
                caseBox.setEnabled(enabled);
            }
        });
        dialog.addCheckBox(DIALOG_COMPLEMENT, this.complementResult);
        String OUTPUT_GROUP = "OUTPUT_GROUP";
        dialog.addRadioButton(CREATE_LYR, "OUTPUT_GROUP", this.createLayer, CREATE_LYR);
        dialog.addRadioButton(UPDATE_SRC, "OUTPUT_GROUP", !this.createLayer, UPDATE_SRC);
        this.updateUI(initLayer);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.srcLayer = dialog.getLayer(LAYER);
        this.attrName = dialog.getText(ATTRIBUTE);
        this.funcNameToRun = dialog.getText(PREDICATE);
        this.value = dialog.getText(VALUE);
        this.caseInsensitive = dialog.getBoolean(DIALOG_CASE_INSENSITIVE);
        this.complementResult = dialog.getBoolean(DIALOG_COMPLEMENT);
        this.createLayer = dialog.getBoolean(CREATE_LYR);
    }

    private void updateUI(Layer lyr) {
        List<Object> attrNames;
        if (lyr != null) {
            FeatureCollectionWrapper fc = lyr.getFeatureCollectionWrapper();
            FeatureSchema fs = fc.getFeatureSchema();
            attrNames = AttributeQueryPlugIn.getAttributeNames(fs);
        } else {
            attrNames = new ArrayList();
        }
        this.attrComboBox.setModel(new DefaultComboBoxModel(new Vector(attrNames)));
        this.attrComboBox.setSelectedItem(this.attrName);
    }

    private static boolean caseBoxEnabled(JComboBox dropBox) {
        Object selectedItem = dropBox.getSelectedItem();
        boolean enabled = false;
        for (String function : AttributePredicate.getNamesCI()) {
            if (selectedItem == null || !selectedItem.equals(function)) continue;
            enabled = true;
            break;
        }
        return enabled;
    }

    private static List<String> getAttributeNames(FeatureSchema fs) {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < fs.getAttributeCount(); ++i) {
            if (fs.getAttributeType(i) == AttributeType.GEOMETRY) continue;
            names.add(fs.getAttributeName(i));
        }
        names.add(ATTR_GEOMETRY_AREA);
        names.add(ATTR_GEOMETRY_LENGTH);
        names.add(ATTR_GEOMETRY_NUMPOINTS);
        names.add(ATTR_GEOMETRY_NUMCOMPONENTS);
        names.add(ATTR_GEOMETRY_NUMHOLES);
        names.add(ATTR_GEOMETRY_ISCLOSED);
        names.add(ATTR_GEOMETRY_ISEMPTY);
        names.add(ATTR_GEOMETRY_ISSIMPLE);
        names.add(ATTR_GEOMETRY_ISVALID);
        names.add(ATTR_GEOMETRY_TYPE);
        names.add(ATTR_GEOMETRY_DIMENSION);
        return names;
    }

    private class LayerItemListener
    implements ItemListener {
        private LayerItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            AttributeQueryPlugIn.this.updateUI((Layer)e.getItem());
        }
    }
}

