/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.CopySchemaPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Collection;
import java.util.List;
import javax.swing.ImageIcon;

public class PasteSchemaPlugIn
extends AbstractPlugIn {
    public static ImageIcon ICON = IconLoader.icon("schema_paste.png");

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        WorkbenchContext workbenchContext = context.getWorkbenchContext();
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        TitledPopupMenu layerNamePopupMenu = context.getWorkbenchContext().getWorkbench().getFrame().getLayerNamePopupMenu();
        featureInstaller.addPopupMenuItem(layerNamePopupMenu, this, new String[]{I18N.getInstance().get("ui.MenuNames.SCHEMA")}, this.getName(), false, this.getIcon(), CopySchemaPlugIn.createEnableCheck(workbenchContext));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Transferable transferable = GUIUtil.getContents(Toolkit.getDefaultToolkit().getSystemClipboard());
        if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            boolean isSchema;
            String schemaString = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            if (!schemaString.endsWith("\n")) {
                schemaString = schemaString + "\n";
            }
            FeatureSchema cbFeatureSchema = new FeatureSchema();
            boolean bl = isSchema = schemaString.length() > 0;
            if (isSchema) {
                boolean endOfString;
                int tabIndex = schemaString.indexOf("\t");
                int crIndex = schemaString.indexOf("\n");
                boolean bl2 = endOfString = tabIndex < 0 || crIndex < 0;
                while (!endOfString) {
                    String name = schemaString.substring(0, tabIndex);
                    String typeStr = schemaString.substring(tabIndex + 1, crIndex);
                    AttributeType type = AttributeType.STRING;
                    if (typeStr.compareToIgnoreCase("STRING") == 0) {
                        type = AttributeType.STRING;
                    } else if (typeStr.compareToIgnoreCase("DOUBLE") == 0) {
                        type = AttributeType.DOUBLE;
                    } else if (typeStr.compareToIgnoreCase("INTEGER") == 0) {
                        type = AttributeType.INTEGER;
                    } else if (typeStr.compareToIgnoreCase("DATE") == 0) {
                        type = AttributeType.DATE;
                    } else if (typeStr.compareToIgnoreCase("GEOMETRY") == 0) {
                        type = AttributeType.GEOMETRY;
                    } else if (typeStr.compareToIgnoreCase("BOOLEAN") == 0) {
                        type = AttributeType.BOOLEAN;
                    } else if (typeStr.compareToIgnoreCase("LONG") == 0) {
                        type = AttributeType.LONG;
                    } else if (typeStr.compareToIgnoreCase("OBJECT") == 0) {
                        type = AttributeType.OBJECT;
                    } else {
                        isSchema = false;
                        break;
                    }
                    cbFeatureSchema.addAttribute(name, type);
                    schemaString = schemaString.substring(crIndex + 1);
                    tabIndex = schemaString.indexOf("\t");
                    crIndex = schemaString.indexOf("\n");
                    endOfString = tabIndex < 0 || crIndex < 0;
                }
                boolean bl3 = isSchema = cbFeatureSchema.getAttributeCount() > 0;
            }
            if (isSchema) {
                Collection<Layer> layerCollection = context.getWorkbenchContext().getLayerNamePanel().selectedNodes(Layer.class);
                for (Layer layer : layerCollection) {
                    FeatureSchema layerSchema = layer.getFeatureCollectionWrapper().getFeatureSchema();
                    int numAttributes = cbFeatureSchema.getAttributeCount();
                    boolean changedSchema = false;
                    for (int index = 0; index < numAttributes; ++index) {
                        String name = cbFeatureSchema.getAttributeName(index);
                        AttributeType type = cbFeatureSchema.getAttributeType(index);
                        if (layerSchema.hasAttribute(name) || type != AttributeType.STRING && type != AttributeType.DOUBLE && type != AttributeType.INTEGER && type != AttributeType.DATE && type != AttributeType.BOOLEAN && type != AttributeType.LONG && type != AttributeType.OBJECT) continue;
                        layerSchema.addAttribute(name, type);
                        changedSchema = true;
                    }
                    if (!changedSchema) continue;
                    List<Feature> layerFeatures = layer.getFeatureCollectionWrapper().getFeatures();
                    for (int j = 0; j < layerFeatures.size(); ++j) {
                        BasicFeature newFeature = new BasicFeature(layerSchema);
                        Feature origFeature = layerFeatures.get(j);
                        int numAttribs = origFeature.getAttributes().length;
                        for (int k = 0; k < numAttribs; ++k) {
                            newFeature.setAttribute(k, origFeature.getAttribute(k));
                        }
                        origFeature.setSchema(newFeature.getSchema());
                        origFeature.setAttributes(newFeature.getAttributes());
                    }
                    layer.setFeatureCollectionModified(true);
                    layer.fireLayerChanged(LayerEventType.METADATA_CHANGED);
                }
            }
        }
        return true;
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithSelectionManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(1)).add(checkFactory.createSelectedLayersMustBeEditableCheck());
    }

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }
}

