/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class MoveLayerablePlugIn
extends AbstractPlugIn {
    public static final ImageIcon UPICON = IconLoader.icon("bullet_arrow_up.png");
    public static final ImageIcon DOWNICON = IconLoader.icon("bullet_arrow_down.png");
    private int displacement;

    private MoveLayerablePlugIn(int displacement) {
        this.displacement = displacement;
    }

    protected Layerable selectedLayerable(LayerNamePanel layerNamePanel) {
        return layerNamePanel.selectedNodes(Layerable.class).iterator().next();
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(final PlugInContext context) throws Exception {
        final Layerable layerable = this.selectedLayerable(context.getLayerNamePanel());
        final int index = this.index(layerable);
        final Category category = context.getLayerManager().getCategory(layerable);
        this.execute(new UndoableCommand(this.getName()){

            @Override
            public void execute() {
                this.moveLayerable(index + MoveLayerablePlugIn.this.displacement);
            }

            @Override
            public void unexecute() {
                this.moveLayerable(index);
            }

            private void moveLayerable(int newIndex) {
                context.getLayerManager().remove(layerable);
                category.add(newIndex, layerable);
            }
        }, context);
        return true;
    }

    protected int index(Layerable layerable) {
        return layerable.getLayerManager().getCategory(layerable).indexOf(layerable);
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, Layerable.class));
    }

    public static class MoveLayerableDownPlugIn
    extends MoveLayerablePlugIn {
        public static final Icon ICON = DOWNICON;

        public MoveLayerableDownPlugIn() {
            super(1);
        }

        @Override
        public String getName() {
            return I18N.getInstance().get("ui.plugin.MoveLayerablePlugIn.move-layer-down");
        }

        @Override
        public MultiEnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
            return super.createEnableCheck(workbenchContext).add(new EnableCheck(){

                @Override
                public String check(JComponent component) {
                    return this.index(this.selectedLayerable(workbenchContext.getLayerableNamePanel())) == workbenchContext.getLayerViewPanel().getLayerManager().getCategory(this.selectedLayerable(workbenchContext.getLayerableNamePanel())).getLayerables().size() - 1 ? I18N.getInstance().get("ui.plugin.MoveLayerablePlugIn.layer-is-already-at-the-bottom") : null;
                }
            });
        }
    }

    public static class MoveLayerableUpPlugIn
    extends MoveLayerablePlugIn {
        public static final Icon ICON = UPICON;

        public MoveLayerableUpPlugIn() {
            super(-1);
        }

        @Override
        public String getName() {
            return I18N.getInstance().get("ui.plugin.MoveLayerablePlugIn.move-layer-up");
        }

        @Override
        public MultiEnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
            return super.createEnableCheck(workbenchContext).add(new EnableCheck(){

                @Override
                public String check(JComponent component) {
                    return this.index(this.selectedLayerable(workbenchContext.getLayerableNamePanel())) == 0 ? I18N.getInstance().get("ui.plugin.MoveLayerablePlugIn.layer-is-already-at-the-top") : null;
                }
            });
        }
    }
}

