/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import com.vividsolutions.jump.workbench.ui.cursortool.QuasimodeTool;
import com.vividsolutions.jump.workbench.ui.cursortool.ShortcutsDescriptor;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.openjump.core.geomutils.GeoUtils;
import org.openjump.core.geomutils.MathVector;

public class MoveSelectedItemsTool
extends DragTool
implements ShortcutsDescriptor {
    private final EnableCheckFactory checkFactory;
    private final GeometryFactory geometryFactory = new GeometryFactory();
    private final Cursor rotateCursor = MoveSelectedItemsTool.createCursor(IconLoader.icon("RotateSelCursor.gif").getImage());
    private Shape selectedFeaturesShape;
    private List<Coordinate> verticesToSnap = null;
    private Coordinate centerCoord = null;
    protected boolean clockwise = true;
    private double fullAngle = 0.0;
    private boolean shiftDown = false;

    public MoveSelectedItemsTool(WorkbenchContext context) {
        super(context);
        this.checkFactory = EnableCheckFactory.getInstance(context);
        this.setStroke(new BasicStroke(1.0f, 0, 2));
        this.allowSnapping();
    }

    @Override
    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        Coordinate displacement = CoordUtil.subtract(this.getModelDestination(), this.getModelSource());
        ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
        for (Layer layerWithSelectedItems : this.getPanel().getSelectionManager().getLayersWithSelectedItems()) {
            transactions.add(this.createTransaction(layerWithSelectedItems, displacement));
        }
        EditTransaction.commit(transactions);
    }

    private EditTransaction createTransaction(Layer layer, final Coordinate displacement) {
        EditTransaction transaction = EditTransaction.createTransactionOnSelection(new EditTransaction.SelectionEditor(){

            @Override
            public Geometry edit(Geometry geometryWithSelectedItems, Collection<Geometry> selectedItems) {
                for (Geometry item : selectedItems) {
                    if (MoveSelectedItemsTool.this.shiftDown) {
                        MoveSelectedItemsTool.this.rotate(item);
                        continue;
                    }
                    MoveSelectedItemsTool.this.move(item, displacement);
                }
                return geometryWithSelectedItems;
            }
        }, this.getPanel(), this.getPanel().getContext(), this.getName(), layer, this.isRollingBackInvalidEdits(), false);
        return transaction;
    }

    private void move(Geometry geometry, Coordinate displacement) {
        geometry.apply(coordinate -> {
            coordinate.x += displacement.x;
            coordinate.y += displacement.y;
        });
    }

    @Override
    public Cursor getCursor() {
        if (this.shiftDown) {
            return this.rotateCursor;
        }
        return Cursor.getPredefinedCursor(13);
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("Move.gif");
    }

    private void rotate(Geometry geometry) {
        geometry.apply(new CoordinateFilter(){

            public void filter(Coordinate coordinate) {
                double cosAngle = Math.cos(MoveSelectedItemsTool.this.fullAngle);
                double sinAngle = Math.sin(MoveSelectedItemsTool.this.fullAngle);
                double x = coordinate.x - ((MoveSelectedItemsTool)MoveSelectedItemsTool.this).centerCoord.x;
                double y = coordinate.y - ((MoveSelectedItemsTool)MoveSelectedItemsTool.this).centerCoord.y;
                coordinate.x = ((MoveSelectedItemsTool)MoveSelectedItemsTool.this).centerCoord.x + x * cosAngle + y * sinAngle;
                coordinate.y = ((MoveSelectedItemsTool)MoveSelectedItemsTool.this).centerCoord.y + y * cosAngle - x * sinAngle;
            }
        });
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        boolean shiftWasDown = this.shiftDown;
        this.shiftDown = e.isShiftDown();
        if (shiftWasDown != this.shiftDown) {
            this.getPanel().setCursor(this.getCursor());
        }
        super.mouseMoved(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        try {
            if (!this.check(this.checkFactory.createAtLeastNItemsMustBeSelectedCheck(1))) {
                return;
            }
            if (!this.check(this.checkFactory.createSelectedItemsLayersMustBeEditableCheck())) {
                return;
            }
            this.verticesToSnap = null;
            this.centerCoord = null;
            this.selectedFeaturesShape = this.createSelectedItemsShape();
            super.mousePressed(e);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    private Collection<Coordinate> verticesToSnap() {
        Envelope viewportEnvelope = this.getPanel().getViewport().getEnvelopeInModelCoordinates();
        if (this.verticesToSnap == null) {
            this.verticesToSnap = new ArrayList<Coordinate>();
            for (Geometry selectedItem : this.getPanel().getSelectionManager().getSelectedItems()) {
                Coordinate[] coordinates;
                for (Coordinate coordinate : coordinates = selectedItem.getCoordinates()) {
                    if (!viewportEnvelope.contains(coordinate)) continue;
                    this.verticesToSnap.add(coordinate);
                }
            }
            if (this.verticesToSnap.size() > 100) {
                Collections.shuffle(this.verticesToSnap);
                this.verticesToSnap = this.verticesToSnap.subList(0, 99);
            }
        }
        return this.verticesToSnap;
    }

    private Shape createSelectedItemsShape() throws NoninvertibleTransformException {
        List<Object> itemsToRender = new ArrayList<Geometry>(this.getPanel().getSelectionManager().getSelectedItems());
        if (itemsToRender.size() > 100) {
            Collections.shuffle(itemsToRender);
            itemsToRender = itemsToRender.subList(0, 99);
        }
        GeometryCollection gc = this.geometryFactory.createGeometryCollection(itemsToRender.toArray(new Geometry[0]));
        if (this.centerCoord == null) {
            this.centerCoord = gc.getCentroid().getCoordinate();
        }
        return this.getPanel().getJava2DConverter().toShape((Geometry)gc);
    }

    @Override
    protected Shape getShape() throws Exception {
        if (this.shiftDown) {
            boolean ccwQuad;
            AffineTransform transform = new AffineTransform();
            Point2D centerPt = this.getPanel().getViewport().toViewPoint(new Point2D.Double(this.centerCoord.x, this.centerCoord.y));
            Point2D initialPt = this.getViewSource();
            Point2D currPt = this.getViewDestination();
            MathVector center = new MathVector(centerPt.getX(), centerPt.getY());
            MathVector initial = new MathVector(initialPt.getX(), initialPt.getY());
            MathVector curr = new MathVector(currPt.getX(), currPt.getY());
            MathVector initVec = initial.vectorBetween(center);
            MathVector currVec = curr.vectorBetween(center);
            double arcAngle = initVec.angleRad(currVec);
            Coordinate initialCoord = this.getPanel().getViewport().toModelCoordinate(initialPt);
            Coordinate currCoord = this.getPanel().getViewport().toModelCoordinate(currPt);
            boolean toRight = GeoUtils.pointToRight(currCoord, this.centerCoord, initialCoord);
            boolean cwQuad = this.fullAngle >= 0.0 && this.fullAngle <= 90.0 && this.clockwise;
            boolean bl = ccwQuad = this.fullAngle < 0.0 && this.fullAngle >= -90.0 && !this.clockwise;
            if (arcAngle <= 90.0 && (cwQuad || ccwQuad)) {
                this.clockwise = toRight;
            }
            this.fullAngle = this.fullAngle > 90.0 || this.fullAngle < -90.0 ? (this.clockwise && !toRight || !this.clockwise && toRight ? 360.0 - arcAngle : arcAngle) : arcAngle;
            if (!this.clockwise) {
                this.fullAngle = -this.fullAngle;
            }
            transform.rotate(this.fullAngle, centerPt.getX(), centerPt.getY());
            return transform.createTransformedShape(this.selectedFeaturesShape);
        }
        AffineTransform transform = new AffineTransform();
        transform.translate(this.getViewDestination().getX() - this.getViewSource().getX(), this.getViewDestination().getY() - this.getViewSource().getY());
        return transform.createTransformedShape(this.selectedFeaturesShape);
    }

    @Override
    protected void setModelDestination(Coordinate modelDestination) {
        for (Coordinate vertex : this.verticesToSnap()) {
            Coordinate displacement = CoordUtil.subtract(vertex, this.getModelSource());
            Coordinate snapPoint = this.snap(CoordUtil.add(modelDestination, displacement));
            if (!this.getSnapManager().wasSnapCoordinateFound()) continue;
            this.modelDestination = CoordUtil.subtract(snapPoint, displacement);
            return;
        }
        this.modelDestination = modelDestination;
    }

    @Override
    public Map<QuasimodeTool.ModifierKeySpec, String> describeShortcuts() {
        HashMap<QuasimodeTool.ModifierKeySpec, String> map = new HashMap<QuasimodeTool.ModifierKeySpec, String>();
        map.put(new QuasimodeTool.ModifierKeySpec(new int[]{16}), I18N.getInstance().get(this.getClass().getName() + ".rotate-item"));
        return map;
    }
}

