/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.cursortool.CoordinateListMetrics;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.MultiClickTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.snap.SnapPolicy;
import com.vividsolutions.jump.workbench.ui.snap.SnapToFeaturesPolicy;
import com.vividsolutions.jump.workbench.ui.snap.SnapToGridPolicy;
import com.vividsolutions.jump.workbench.ui.snap.SnapToLineStringBeingEditedPolicy;
import com.vividsolutions.jump.workbench.ui.snap.SnapToVerticesPolicy;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.operation.valid.IsValidOp;

public class DrawLineStringTool
extends MultiClickTool {
    private final FeatureDrawingUtil featureDrawingUtil;

    private DrawLineStringTool(WorkbenchContext context, FeatureDrawingUtil featureDrawingUtil) {
        super(context);
        this.featureDrawingUtil = featureDrawingUtil;
        this.setMetricsDisplay(new CoordinateListMetrics());
    }

    public static CursorTool create(WorkbenchContext context) {
        FeatureDrawingUtil featureDrawingUtil = new FeatureDrawingUtil(context);
        return featureDrawingUtil.prepare(new DrawLineStringTool(context, featureDrawingUtil), true);
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("DrawLineString.gif");
    }

    @Override
    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        if (!this.checkLineString()) {
            return;
        }
        this.featureDrawingUtil.drawLineString(this.getLineString(), this.isRollingBackInvalidEdits(), this, this.getPanel());
    }

    @Override
    protected List<SnapPolicy> createStandardSnappingPolicies(Blackboard blackboard) {
        ArrayList<SnapPolicy> policies = new ArrayList<SnapPolicy>();
        policies.add(new SnapToVerticesPolicy(blackboard));
        policies.add(new SnapToFeaturesPolicy(blackboard));
        policies.add(new SnapToGridPolicy(blackboard));
        policies.add(new SnapToLineStringBeingEditedPolicy(blackboard, this));
        return policies;
    }

    protected LineString getLineString() throws NoninvertibleTransformException {
        return new GeometryFactory().createLineString(this.toArray(this.getCoordinates()));
    }

    protected boolean checkLineString() throws NoninvertibleTransformException {
        if (this.getCoordinates().size() < 2) {
            this.getPanel().getContext().warnUser(I18N.getInstance().get("ui.cursortool.editing.DrawLineString.the-linestring-must-have-at-least-2-points"));
            return false;
        }
        IsValidOp isValidOp = new IsValidOp((Geometry)this.getLineString());
        if (!isValidOp.isValid()) {
            this.getPanel().getContext().warnUser(isValidOp.getValidationError().getMessage());
            if (PersistentBlackboardPlugIn.get(this.getWorkbench().getContext()).get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false)) {
                return false;
            }
        }
        return true;
    }
}

