/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.geom.EnvelopeIntersector;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.locationtech.jts.geom.Envelope;

public abstract class SpecifyFeaturesTool
extends DragTool {
    public SpecifyFeaturesTool(WorkbenchContext context) {
        super(context);
    }

    protected Iterator<Layer> candidateLayersIterator() {
        return this.getPanel().getLayerManager().iterator(Layer.class);
    }

    private static Set<Feature> intersectingFeatures(Layer layer, Envelope envelope) {
        HashSet<Feature> intersectingFeatures = new HashSet<Feature>();
        List<Feature> candidateFeatures = layer.getFeatureCollectionWrapper().query(envelope);
        for (Feature feature : candidateFeatures) {
            if (!envelope.contains(feature.getGeometry().getEnvelopeInternal()) && !EnvelopeIntersector.intersects(feature.getGeometry(), envelope)) continue;
            intersectingFeatures.add(feature);
        }
        return intersectingFeatures;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        try {
            super.mouseClicked(e);
            this.setViewSource(e.getPoint());
            this.setViewDestination(e.getPoint());
            this.fireGestureFinished();
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    protected Set<Feature> specifiedFeatures() throws NoninvertibleTransformException {
        LinkedHashSet<Feature> allFeatures = new LinkedHashSet<Feature>();
        for (Set<Feature> features : this.layerToSpecifiedFeaturesMap().values()) {
            allFeatures.addAll(features);
        }
        return allFeatures;
    }

    protected Map<Layer, Set<Feature>> layerToSpecifiedFeaturesMap() throws NoninvertibleTransformException {
        return SpecifyFeaturesTool.layerToSpecifiedFeaturesMap(this.candidateLayersIterator(), this.getBoxInModelCoordinates());
    }

    public static Map<Layer, Set<Feature>> layerToSpecifiedFeaturesMap(Iterator<Layer> layerIterator, Envelope boxInModelCoordinates) throws NoninvertibleTransformException {
        HashMap<Layer, Set<Feature>> layerToFeaturesMap = new HashMap<Layer, Set<Feature>>();
        while (layerIterator.hasNext()) {
            Set<Feature> intersectingFeatures;
            Layer layer = layerIterator.next();
            if (!layer.isVisible() || (intersectingFeatures = SpecifyFeaturesTool.intersectingFeatures(layer, boxInModelCoordinates)).isEmpty()) continue;
            layerToFeaturesMap.put(layer, intersectingFeatures);
        }
        return layerToFeaturesMap;
    }

    protected Collection<Feature> specifiedFeatures(Collection<Layer> layers) throws NoninvertibleTransformException {
        ArrayList<Feature> specifiedFeatures = new ArrayList<Feature>();
        Map<Layer, Set<Feature>> layerToSpecifiedFeaturesMap = this.layerToSpecifiedFeaturesMap();
        for (Layer layer : layerToSpecifiedFeaturesMap.keySet()) {
            if (!layers.contains(layer)) continue;
            specifiedFeatures.addAll((Collection<Feature>)layerToSpecifiedFeaturesMap.get(layer));
        }
        return specifiedFeatures;
    }
}

