/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.FenceLayerFinder;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.ui.InfoFrame;
import com.vividsolutions.jump.workbench.ui.cursortool.SpecifyFeaturesTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.wms.FeatureInfoRequest;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.CheckOS;
import org.openjump.core.rasterimage.RasterImageLayer;

public class FeatureInfoTool
extends SpecifyFeaturesTool {
    public static final ImageIcon ICON = IconLoader.icon("information_20x20.png");

    public FeatureInfoTool(WorkbenchContext context) {
        super(context);
        this.setColor(Color.magenta);
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public Cursor getCursor() {
        BufferedImage i = !CheckOS.isLinux() ? IconLoader.image("information_cursor.png") : IconLoader.image("information_cursor_2color.gif");
        return FeatureInfoTool.createCursor(i);
    }

    @Override
    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        InfoFrame infoFrame = this.getTaskFrame().getInfoFrame();
        if (!this.wasShiftPressed()) {
            infoFrame.getModel().clear();
        }
        Map<Layer, Set<Feature>> map = this.layerToSpecifiedFeaturesMap();
        for (Layer layer : map.keySet()) {
            if (layer.getName().equals(FenceLayerFinder.LAYER_NAME)) continue;
            Collection features = map.get(layer);
            infoFrame.getModel().add(layer, features);
        }
        Coordinate coord = this.getPanel().getViewport().toModelCoordinate(this.getViewSource());
        List<WMSLayer> wmsLay_l = this.getWorkbench().getContext().getLayerManager().getLayerables(WMSLayer.class);
        String response = "";
        String newLine = System.getProperty("line.separator");
        for (WMSLayer wmsLayer : wmsLay_l) {
            String wmsResponse;
            if (!wmsLayer.isVisible()) continue;
            Point2D point = this.getPanel().getViewport().toViewPoint(coord);
            Envelope bbox = this.getPanel().getViewport().getEnvelopeInModelCoordinates();
            FeatureInfoRequest request = new FeatureInfoRequest(wmsLayer);
            request.setBbox(bbox);
            request.setPoint(point);
            request.setHeight(this.getPanel().getHeight());
            request.setWidth(this.getPanel().getWidth());
            try {
                wmsResponse = request.getText();
                wmsResponse = this.cleanWmsResponse(wmsResponse);
            }
            catch (Exception ex) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                wmsResponse = sw.toString();
                Logger.warn(sw.toString());
                wmsResponse = wmsResponse.concat(newLine);
                Logger.debug(ex);
            }
            response = response.concat(wmsResponse);
            response = response.concat(newLine);
        }
        infoFrame.setWmsInfo(response);
        List<RasterImageLayer> layerables_l = this.getWorkbench().getContext().getLayerManager().getLayerables(RasterImageLayer.class);
        String[] layerNames = new String[layerables_l.size()];
        String[] cellValues = new String[layerables_l.size()];
        int l = 0;
        for (RasterImageLayer rasterImageLayer : layerables_l) {
            layerNames[l] = rasterImageLayer.getName();
            cellValues[l] = "";
            for (int b = 0; b < rasterImageLayer.getNumBands(); ++b) {
                Double cellValue = rasterImageLayer.getCellValue(coord.x, coord.y, b);
                cellValues[l] = cellValue != null ? (rasterImageLayer.isNoData(cellValue) ? Double.toString(Double.NaN) : cellValues[l].concat(Double.toString(cellValue))) : "???";
                cellValues[l] = cellValues[l].concat(";");
            }
            ++l;
        }
        infoFrame.setRasterValues(layerNames, cellValues);
        infoFrame.surface();
    }

    private String cleanWmsResponse(String inputWms) {
        int endIndex;
        String pattern = "GetFeatureInfo results:";
        int index = inputWms.indexOf(pattern);
        if (index != -1 && (inputWms = inputWms.substring(endIndex = index + pattern.length())).startsWith("\n\n")) {
            inputWms = inputWms.replaceFirst("\n\n", "");
        }
        return inputWms;
    }
}

