/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;

public abstract class CompositeTool
implements CursorTool {
    protected List<CursorTool> cursorTools;
    private LayerViewPanel panel = null;

    public CompositeTool(CursorTool[] cursorTools) {
        this.cursorTools = new ArrayList<CursorTool>(Arrays.asList(cursorTools));
    }

    @Override
    public void deactivate() {
        for (CursorTool cursorTool : this.cursorTools) {
            cursorTool.deactivate();
        }
    }

    @Override
    public Cursor getCursor() {
        for (CursorTool cursorTool : this.cursorTools) {
            if (cursorTool.getCursor() == Cursor.getDefaultCursor()) continue;
            return cursorTool.getCursor();
        }
        return Cursor.getDefaultCursor();
    }

    @Override
    public boolean isRightMouseButtonUsed() {
        for (CursorTool cursorTool : this.cursorTools) {
            if (!cursorTool.isRightMouseButtonUsed()) continue;
            return true;
        }
        return false;
    }

    protected CursorTool firstCursorTool() {
        return this.cursorTools.get(0);
    }

    @Override
    public void activate(LayerViewPanel layerViewPanel) {
        this.panel = layerViewPanel;
        for (CursorTool cursorTool : this.cursorTools) {
            cursorTool.activate(layerViewPanel);
        }
    }

    public CompositeTool add(CursorTool tool) {
        this.cursorTools.add(tool);
        return this;
    }

    @Override
    public void cancelGesture() {
        for (CursorTool cursorTool : this.cursorTools) {
            cursorTool.cancelGesture();
        }
    }

    @Override
    public Icon getIcon() {
        for (CursorTool cursorTool : this.cursorTools) {
            if (cursorTool.getIcon() == null) continue;
            return cursorTool.getIcon();
        }
        return null;
    }

    protected String getName(String delimiter) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < this.cursorTools.size(); ++i) {
            if (i > 0) {
                name.append(" ").append(delimiter).append(" ");
            }
            name.append(this.cursorTools.get(i).getName());
        }
        return name.toString();
    }

    @Override
    public boolean isGestureInProgress() {
        for (CursorTool cursorTool : this.cursorTools) {
            if (!cursorTool.isGestureInProgress()) continue;
            return true;
        }
        return false;
    }

    public LayerViewPanel getPanel() {
        return this.panel;
    }
}

