/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.openjump.swing.listener.InvokeMethodActionListener;

public class EnableableToolBar
extends JToolBar {
    protected HashMap<JComponent, EnableCheck> buttonToEnableCheckMap = new HashMap();
    protected HashMap<JComponent, String> buttonToNameMap = new HashMap();
    private final InvokeMethodActionListener updateStateListener = new InvokeMethodActionListener(this, "updateEnabledState");

    public EnableCheck getEnableCheck(AbstractButton button) {
        return this.buttonToEnableCheckMap.get(button);
    }

    public void setEnableCheck(AbstractButton button, EnableCheck check) {
        this.buttonToEnableCheckMap.put(button, check);
    }

    public EnableableToolBar() {
        this.setFloatable(false);
    }

    public void updateEnabledState() {
        for (JComponent component : this.buttonToEnableCheckMap.keySet()) {
            EnableCheck enableCheck = this.buttonToEnableCheckMap.get(component);
            String name = this.buttonToNameMap.get(component);
            String check = enableCheck.check(component);
            if (check != null) {
                component.setEnabled(false);
                component.setToolTipText(name + " - " + check);
                continue;
            }
            component.setEnabled(true);
            component.setToolTipText(name);
        }
    }

    public void addSpacer() {
        JPanel filler = new JPanel();
        filler.setPreferredSize(new Dimension(5, 5));
        filler.setMinimumSize(new Dimension(5, 5));
        filler.setMaximumSize(new Dimension(5, 5));
        this.add(filler);
    }

    public void add(AbstractButton button, String tooltip, Icon icon, ActionListener actionListener, EnableCheck enableCheck) {
        this.add(-1, button, tooltip, icon, actionListener, enableCheck);
    }

    public void add(int index, AbstractButton button, String tooltip, Icon icon, ActionListener actionListener, EnableCheck enableCheck) {
        if (enableCheck != null) {
            this.buttonToEnableCheckMap.put(button, enableCheck);
        }
        this.buttonToNameMap.put(button, tooltip);
        int dim = 20;
        if (icon != null) {
            int w = icon.getIconWidth();
            int h = icon.getIconHeight();
            if (h > dim || w > dim) {
                icon = GUIUtil.resize(GUIUtil.toImageIcon(icon), dim);
            }
            button.setIcon(icon);
        }
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setToolTipText(tooltip);
        button.addActionListener(actionListener);
        button.addActionListener(this.updateStateListener);
        this.add((Component)button, index);
    }
}

