/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.ui.AttributeTypeFilter;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class DualPaneInputDialog
extends MultiInputDialog {
    JPanel leftPanel;
    JPanel rightPanel;

    public DualPaneInputDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
    }

    public DualPaneInputDialog() {
        this((Frame)null, "", false);
    }

    @Override
    protected void setMainComponent() {
        this.mainComponent = new JPanel();
        ((JPanel)this.mainComponent).setBorder(BorderFactory.createEtchedBorder());
        this.mainComponent.setLayout(new BoxLayout(this.mainComponent, 0));
        this.leftPanel = new JPanel(new GridBagLayout());
        JPanel separator = new JPanel();
        separator.setBackground(Color.BLACK);
        separator.setMinimumSize(new Dimension(1, 1));
        separator.setPreferredSize(new Dimension(1, 1));
        this.rightPanel = new JPanel(new GridBagLayout());
        this.mainComponent.add(this.leftPanel);
        this.mainComponent.add(separator);
        this.mainComponent.add(this.rightPanel);
        this.currentPanel = this.leftPanel;
    }

    public void setLeftPane() {
        this.currentPanel = this.leftPanel;
    }

    public void setRightPane() {
        this.currentPanel = this.rightPanel;
    }

    public static void main(String[] args) {
        final LayerManager lm = new LayerManager();
        FeatureSchema fs1 = new FeatureSchema();
        fs1.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        FeatureDataset ds1 = new FeatureDataset(fs1);
        lm.addLayer("", "LayerWithJustGeometry", ds1);
        FeatureSchema fs2 = new FeatureSchema();
        fs2.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        fs2.addAttribute("Name", AttributeType.STRING);
        FeatureDataset ds2 = new FeatureDataset(fs2);
        lm.addLayer("", "LayerWithStringAttribute", ds2);
        FeatureSchema fs3 = new FeatureSchema();
        fs3.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        fs3.addAttribute("Name", AttributeType.STRING);
        fs3.addAttribute("Age", AttributeType.INTEGER);
        FeatureDataset ds3 = new FeatureDataset(fs3);
        lm.addLayer("", "LayerWithNumericAttribute", ds3);
        final DualPaneInputDialog d = new DualPaneInputDialog(null, "Title!", true);
        d.addSubTitle("Sous-titre 1");
        d.addLabel("This is just a label");
        d.addTextField("Nom", "", 24, null, "");
        d.addPositiveIntegerField("Age", 0, 6, "");
        d.addNonNegativeDoubleField("Salaire", 0.0, 12, "");
        d.addComboBox("M\ufffdtier", "Cadre", Arrays.asList("Cadre", "Charpentier", "Ma\ufffdon", "Boulanger"), "");
        d.addSubTitle("Layer and attribute selection");
        AttributeTypeFilter STRING_FILTER = new AttributeTypeFilter(2);
        AttributeTypeFilter NUMERIC_FILTER = AttributeTypeFilter.NUMERIC_FILTER;
        AttributeTypeFilter NOGEOM_FILTER = AttributeTypeFilter.NO_GEOMETRY_FILTER;
        AttributeTypeFilter ALL_FILTER = AttributeTypeFilter.ALL_FILTER;
        final JComboBox<Object> typeChooser = d.addComboBox("Choose Attribute Type", "ALL", Arrays.asList(STRING_FILTER, NUMERIC_FILTER, ALL_FILTER, NOGEOM_FILTER), "");
        final JComboBox<Layer> layerChooser = d.addLayerComboBox("LayerField", null, "ToolTip", lm);
        JComboBox<String> attributeChooser = d.addAttributeComboBox("Attribute field", "LayerField", NUMERIC_FILTER, "");
        typeChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributeTypeFilter atf = (AttributeTypeFilter)typeChooser.getSelectedItem();
                layerChooser.setModel(new DefaultComboBoxModel<Layer>(atf.filter(lm).toArray(new Layer[0])));
            }
        });
        d.addSeparator();
        d.setRightPane();
        final JCheckBox jcb = d.addCheckBox("Afficher l'icone", false, "");
        JButton button = d.addButton("switch image panel");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (d.getDescriptionPanel().getDescription().equals("")) {
                    d.setSideBarDescription("Description de la bo\ufffdte de dialogue et des param\ufffdtres pour aider l'utilisateur");
                    d.getConsole().flashMessage("Add description");
                } else {
                    d.setSideBarDescription("");
                    d.getConsole().flashMessage("Remove description");
                }
            }
        });
        jcb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (jcb.isSelected()) {
                    d.setSideBarImage(new ImageIcon(MultiInputDialog.class.getResource("Butt.gif")));
                    d.getConsole().flashMessage("Add image");
                } else {
                    d.setSideBarImage(null);
                    d.getConsole().flashMessage("Remove image");
                }
            }
        });
        JButton button2 = d.addButton("Deuxi\ufffdme bouton", "OK", "");
        d.addRow();
        d.setVisible(true);
        GUIUtil.centreOnScreen(d);
        System.exit(0);
    }
}

