/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.util.CollectionMap;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.ui.AttributeTypeFilter;
import com.vividsolutions.jump.workbench.ui.LayerNameRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.text.JTextComponent;
import org.openjump.core.rasterimage.RasterImageLayer;

public abstract class AbstractMultiInputDialog
extends JDialog {
    public static final int NO_LABEL = 0;
    public static final int LEFT_LABEL = 1;
    public static final int RIGHT_LABEL = 2;
    public static final int HORIZONTAL = 2;
    public static final int VERTICAL = 3;
    public static final int BOTH = 1;
    public static final int NONE = 0;
    public static final String NO_VALID_ATTRIBUTE = I18N.getInstance().get("ui.MultiInputDialog.no-valid-attribute");
    private final HashMap<String, Component> fieldNameToComponentMap = new HashMap();
    private final HashMap<String, Component> fieldNameToLabelMap = new HashMap();
    private final Map<String, ButtonGroup> buttonGroupMap = new HashMap<String, ButtonGroup>();
    private final CollectionMap<String, EnableCheck> fieldNameToEnableCheckListMap = new CollectionMap();

    protected AbstractMultiInputDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
    }

    public EnableCheck createDoubleCheck(final String fieldName) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                try {
                    Double.parseDouble(AbstractMultiInputDialog.this.getText(fieldName).trim());
                    return null;
                }
                catch (NumberFormatException e) {
                    return "\"" + AbstractMultiInputDialog.this.getText(fieldName).trim() + "\" " + I18N.getInstance().get("ui.MultiInputDialog.is-an-invalid-double") + " (" + fieldName + ")";
                }
            }
        };
    }

    public EnableCheck createIntegerCheck(final String fieldName) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                try {
                    Integer.parseInt(AbstractMultiInputDialog.this.getText(fieldName).trim());
                    return null;
                }
                catch (NumberFormatException e) {
                    return "\"" + AbstractMultiInputDialog.this.getText(fieldName).trim() + "\" " + I18N.getInstance().get("ui.MultiInputDialog.is-an-invalid-integer") + " (" + fieldName + ")";
                }
            }
        };
    }

    public EnableCheck createPositiveCheck(final String fieldName) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                if (Double.parseDouble(AbstractMultiInputDialog.this.getText(fieldName).trim()) > 0.0) {
                    return null;
                }
                return "\"" + AbstractMultiInputDialog.this.getText(fieldName).trim() + "\" " + I18N.getInstance().get("ui.MultiInputDialog.must-be") + " > 0 (" + fieldName + ")";
            }
        };
    }

    public EnableCheck createNonNegativeCheck(final String fieldName) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                if (Double.parseDouble(AbstractMultiInputDialog.this.getText(fieldName).trim()) >= 0.0) {
                    return null;
                }
                return "\"" + AbstractMultiInputDialog.this.getText(fieldName).trim() + "\" " + I18N.getInstance().get("ui.MultiInputDialog.must-be") + " >= 0 (" + fieldName + ")";
            }
        };
    }

    protected void addComponent(String fieldName, Component label, Component component) {
        if (label != null) {
            this.fieldNameToLabelMap.put(fieldName, label);
        }
        if (component != null) {
            this.fieldNameToComponentMap.put(fieldName, component);
        }
    }

    protected Component getComponent(String fieldName) {
        return this.fieldNameToComponentMap.get(fieldName);
    }

    public JLabel getLabel(String fieldName) {
        return (JLabel)this.fieldNameToLabelMap.get(fieldName);
    }

    public <T> JComboBox<T> getComboBox(String fieldName) {
        return (JComboBox)this.getComponent(fieldName);
    }

    public JCheckBox getCheckBox(String fieldName) {
        return (JCheckBox)this.getComponent(fieldName);
    }

    public JRadioButton getRadioButton(String fieldName) {
        return (JRadioButton)this.getComponent(fieldName);
    }

    public JFileChooser getFileChooser(String fieldName) {
        return (JFileChooser)this.getComponent(fieldName);
    }

    public Object getValue(Component component) {
        if (component instanceof JTextComponent) {
            return ((JTextComponent)component).getText();
        }
        if (component instanceof JComboBox) {
            return ((JComboBox)component).getSelectedItem();
        }
        if (component instanceof JScrollPane) {
            component = ((JScrollPane)component).getViewport().getView();
            return this.getValue(component);
        }
        if (component instanceof JButton) {
            return component.isEnabled();
        }
        if (component instanceof JToggleButton) {
            return ((JToggleButton)component).isSelected();
        }
        if (component instanceof JFileChooser) {
            File[] files;
            JFileChooser fc = (JFileChooser)component;
            if (fc.isMultiSelectionEnabled()) {
                files = fc.getSelectedFiles();
            } else {
                File[] fileArray;
                File file = fc.getSelectedFile();
                if (file == null) {
                    fileArray = new File[]{};
                } else {
                    File[] fileArray2 = new File[1];
                    fileArray = fileArray2;
                    fileArray2[0] = file;
                }
                files = fileArray;
            }
            return Arrays.asList(files);
        }
        return null;
    }

    public Object getValue(String fieldName) {
        Component component = this.fieldNameToComponentMap.get(fieldName);
        if (component == null) {
            Logger.error("No component labelled '" + fieldName + "' in this dialog.");
            return null;
        }
        return this.getValue(component);
    }

    public String getText(String fieldName) {
        Object value = this.getValue(fieldName);
        if (value == null) {
            return "";
        }
        return String.valueOf(value);
    }

    public boolean getBoolean(String fieldName) {
        return (Boolean)this.getValue(fieldName);
    }

    public double getDouble(String fieldName) {
        return Double.parseDouble(this.getValue(fieldName).toString().trim());
    }

    public int getInteger(String fieldName) {
        return Integer.parseInt(this.getValue(fieldName).toString().trim());
    }

    public Layer getLayer(String fieldName) {
        return (Layer)this.getValue(fieldName);
    }

    public RasterImageLayer getRasterLayer(String fieldName) {
        return (RasterImageLayer)this.getValue(fieldName);
    }

    public Layerable getLayerable(String fieldName) {
        return (Layerable)this.getValue(fieldName);
    }

    public List<File> getFiles(String fieldName) {
        return (List)this.getValue(fieldName);
    }

    public void addEnableChecks(String fieldName, Collection<EnableCheck> enableChecks) {
        this.fieldNameToEnableCheckListMap.addItems(fieldName, enableChecks);
    }

    public void addEnableChecks(String fieldName, EnableCheck ... enableChecks) {
        this.fieldNameToEnableCheckListMap.addItems(fieldName, Arrays.asList(enableChecks));
    }

    public JTextField addTextField(String fieldName, String initialValue, int approxWidthInChars, EnableCheck[] enableChecks, String toolTipText) {
        JTextField textField = new JTextField(initialValue, approxWidthInChars);
        textField.setMinimumSize(textField.getPreferredSize());
        this.addRow(fieldName, new JLabel(fieldName), textField, enableChecks, toolTipText, 1, 2);
        return textField;
    }

    public <T> JComboBox<T> addComboBox(String fieldName, T selectedItem, Collection<T> items, String toolTipText) {
        JComboBox<T> comboBox = new JComboBox<T>(new Vector<T>(items));
        comboBox.setSelectedItem(selectedItem);
        this.addRow(fieldName, new JLabel(fieldName), comboBox, null, toolTipText, 1, 0);
        return comboBox;
    }

    public JLabel addLabel(String text) {
        JLabel lbl = new JLabel(text);
        this.addRow(lbl);
        return lbl;
    }

    public JLabel addSubTitle(String text) {
        JLabel lbl = new JLabel("<html><b>" + text + "</b></html>");
        this.addRow(lbl);
        return lbl;
    }

    public JButton addButton(String fieldName, String text, String toolTipText) {
        JButton button = new JButton(text);
        this.addRow(fieldName, new JLabel(fieldName), button, null, toolTipText, 1, 0);
        return button;
    }

    public JButton addButton(String text) {
        JButton button = new JButton(text);
        this.addRow("DUMMY", new JLabel(""), button, null, null, 1, 0);
        return button;
    }

    public void addSeparator() {
        JPanel separator = new JPanel();
        separator.setBackground(Color.black);
        separator.setMinimumSize(new Dimension(1, 1));
        separator.setPreferredSize(new Dimension(1, 1));
        this.addRow(separator);
    }

    private JTextField addNumericField(String fieldName, String initialValue, int approxWidthInChars, EnableCheck[] enableChecks, String toolTipText) {
        JTextField textField = new JTextField(initialValue, approxWidthInChars);
        textField.setMinimumSize(textField.getPreferredSize());
        textField.setHorizontalAlignment(4);
        this.addRow(fieldName, new JLabel(fieldName), textField, enableChecks, toolTipText, 1, 0);
        return textField;
    }

    public JTextField addIntegerField(String fieldName, int initialValue, int approxWidthInChars, String toolTipText) {
        return this.addNumericField(fieldName, String.valueOf(initialValue), approxWidthInChars, new EnableCheck[]{this.createIntegerCheck(fieldName)}, toolTipText);
    }

    public JTextField addPositiveIntegerField(String fieldName, int initialValue, int approxWidthInChars, String toolTipText) {
        return this.addNumericField(fieldName, String.valueOf(initialValue), approxWidthInChars, new EnableCheck[]{this.createIntegerCheck(fieldName), this.createPositiveCheck(fieldName)}, toolTipText);
    }

    public JTextField addPositiveIntegerField(String fieldName, int initialValue, int approxWidthInChars) {
        return this.addPositiveIntegerField(fieldName, initialValue, approxWidthInChars, null);
    }

    public JTextField addDoubleField(String fieldName, double initialValue, int decimals, int approxWidthInChars, String toolTipText) {
        if (decimals < 0) {
            decimals = 0;
        }
        return this.addNumericField(fieldName, String.format("%." + decimals + "f", initialValue), approxWidthInChars, new EnableCheck[]{this.createDoubleCheck(fieldName)}, toolTipText);
    }

    public JTextField addDoubleField(String fieldName, double initialValue, int approxWidthInChars) {
        return this.addDoubleField(fieldName, initialValue, approxWidthInChars, null);
    }

    public JTextField addDoubleField(String fieldName, double initialValue, int approxWidthInChars, String toolTipText) {
        return this.addNumericField(fieldName, StringUtil.toString(initialValue), approxWidthInChars, new EnableCheck[]{this.createDoubleCheck(fieldName)}, toolTipText);
    }

    public JTextField addPositiveDoubleField(String fieldName, double initialValue, int approxWidthInChars, String toolTipText) {
        return this.addNumericField(fieldName, StringUtil.toString(initialValue), approxWidthInChars, new EnableCheck[]{this.createDoubleCheck(fieldName), this.createPositiveCheck(fieldName)}, toolTipText);
    }

    public JTextField addPositiveDoubleField(String fieldName, double initialValue, int approxWidthInChars) {
        return this.addPositiveDoubleField(fieldName, initialValue, approxWidthInChars, null);
    }

    public JTextField addNonNegativeDoubleField(String fieldName, double initialValue, int approxWidthInChars, String toolTipText) {
        return this.addNumericField(fieldName, StringUtil.toString(initialValue), approxWidthInChars, new EnableCheck[]{this.createDoubleCheck(fieldName), this.createNonNegativeCheck(fieldName)}, toolTipText);
    }

    public JTextField addNonNegativeDoubleField(String fieldName, double initialValue, int approxWidthInChars) {
        return this.addNonNegativeDoubleField(fieldName, initialValue, approxWidthInChars, null);
    }

    public JComboBox<Layer> addLayerComboBox(String fieldName, Layer initialValue, String toolTipText, Collection<Layer> layers) {
        JComboBox<Layer> comboBox = this.addComboBox(fieldName, initialValue, layers, toolTipText);
        LayerNameRenderer layerListCellRenderer = new LayerNameRenderer();
        layerListCellRenderer.setCheckBoxVisible(false);
        layerListCellRenderer.setProgressIconLabelVisible(false);
        comboBox.setRenderer(layerListCellRenderer);
        comboBox.invalidate();
        return comboBox;
    }

    public JComboBox<Layer> addLayerComboBox(String fieldName, Layer initialValue, LayerManager layerManager) {
        return this.addLayerComboBox(fieldName, initialValue, null, layerManager);
    }

    public JComboBox<Layer> addLayerComboBox(String fieldName, Layer initialValue, String toolTipText, LayerManager layerManager) {
        return this.addLayerComboBox(fieldName, initialValue, toolTipText, layerManager.getLayers());
    }

    public JComboBox<Layer> addEditableLayerComboBox(String fieldName, Layer initialValue, String toolTipText, LayerManager layerManager) {
        return this.addLayerComboBox(fieldName, initialValue, toolTipText, layerManager.getEditableLayers());
    }

    public JComboBox<Layer> addLayerComboBox(String fieldName, String toolTipText, LayerManager layerManager, AttributeTypeFilter filter) {
        ArrayList<Layer> layerList = new ArrayList<Layer>();
        for (Layer layer : layerManager.getLayers()) {
            FeatureSchema schema = layer.getFeatureCollectionWrapper().getFeatureSchema();
            if (filter.filter(schema).size() <= 0) continue;
            layerList.add(layer);
        }
        Layer initialLayer = layerList.size() > 0 ? (Layer)layerList.get(0) : null;
        return this.addLayerComboBox(fieldName, initialLayer, toolTipText, layerList);
    }

    public JComboBox<RasterImageLayer> addRasterLayerComboBox(String fieldName, RasterImageLayer initialValue, String toolTipText, LayerManager layerManager) {
        return this.addLayerableComboBox(fieldName, initialValue, toolTipText, layerManager, RasterImageLayer.class);
    }

    public <T extends Layerable> JComboBox<T> addLayerableComboBox(String fieldName, T initialValue, String toolTipText, LayerManager layerManager, Class<T> clazz) {
        JComboBox<T> comboBox = this.addComboBox(fieldName, initialValue, layerManager.getLayerables(clazz), toolTipText);
        LayerNameRenderer layerListCellRenderer = new LayerNameRenderer();
        layerListCellRenderer.setCheckBoxVisible(false);
        layerListCellRenderer.setProgressIconLabelVisible(false);
        comboBox.setRenderer(layerListCellRenderer);
        comboBox.invalidate();
        return comboBox;
    }

    public JComboBox<String> addAttributeComboBox(String fieldName, String layerFieldName, final AttributeTypeFilter filter, String toolTipText) {
        final JComboBox layerComboBox = this.getComboBox(layerFieldName);
        final JComboBox<Object> attributeComboBox = this.addComboBox(fieldName, null, new ArrayList(), toolTipText);
        final DefaultComboBoxModel<String> DEFAULT = new DefaultComboBoxModel<String>(new String[]{NO_VALID_ATTRIBUTE});
        Layer layer = (Layer)layerComboBox.getSelectedItem();
        if (layer != null) {
            FeatureSchema schema = layer.getFeatureCollectionWrapper().getFeatureSchema();
            List<String> attributes = filter.filter(schema);
            if (attributes.size() > 0) {
                attributeComboBox.setModel(new DefaultComboBoxModel<String>(attributes.toArray(new String[0])));
            } else {
                attributeComboBox.setModel(DEFAULT);
            }
        } else {
            attributeComboBox.setModel(DEFAULT);
        }
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Layer lyr = (Layer)layerComboBox.getSelectedItem();
                FeatureSchema schema = lyr.getFeatureCollectionWrapper().getFeatureSchema();
                List<String> attributes = filter.filter(schema);
                if (attributes.size() > 0) {
                    String oldAttr = (String)attributeComboBox.getSelectedItem();
                    attributeComboBox.setModel(new DefaultComboBoxModel<String>(attributes.toArray(new String[0])));
                    if (attributes.contains(oldAttr)) {
                        attributeComboBox.setSelectedItem(oldAttr);
                    }
                } else {
                    attributeComboBox.setModel(DEFAULT);
                }
            }
        };
        layerComboBox.addActionListener(listener);
        return attributeComboBox;
    }

    public JCheckBox addCheckBox(String fieldName, boolean initialValue) {
        return this.addCheckBox(fieldName, initialValue, null);
    }

    public JCheckBox addCheckBox(String fieldName, boolean initialValue, String toolTipText) {
        JCheckBox checkBox = new JCheckBox(fieldName, initialValue);
        this.addRow(fieldName, new JLabel(""), checkBox, null, toolTipText, 0, 2);
        return checkBox;
    }

    public JRadioButton addRadioButton(String fieldName, String buttonGroupName, boolean initialValue, String toolTipText) {
        JRadioButton radioButton = new JRadioButton(fieldName, initialValue);
        this.addRow(fieldName, new JLabel(""), radioButton, null, toolTipText, 0, 2);
        if (buttonGroupName != null) {
            ButtonGroup group = this.buttonGroupMap.get(buttonGroupName);
            if (group == null) {
                group = new ButtonGroup();
                this.buttonGroupMap.put(buttonGroupName, group);
            }
            group.add(radioButton);
        }
        return radioButton;
    }

    public JTextArea addTextAreaField(String fieldName, String initialValue, int rowNumber, int columnNumber, boolean scrollable, EnableCheck[] enableChecks, String toolTipText) {
        JTextArea textArea = new JTextArea(initialValue, rowNumber, columnNumber);
        JComponent component = scrollable ? new JScrollPane(textArea) : textArea;
        this.addRow(fieldName, new JLabel(fieldName), component, enableChecks, toolTipText, 1, 1);
        return textArea;
    }

    protected abstract void addRow(String var1, JComponent var2, JComponent var3, EnableCheck[] var4, String var5, int var6, int var7);

    protected abstract void addRow(JComponent var1);

    protected abstract void addRow();

    public void setFieldEnabled(String fieldName, boolean enable) {
        Component component = this.getComponent(fieldName);
        if (component != null) {
            component.setEnabled(enable);
        }
    }

    public void setFieldVisible(String fieldName, boolean visible) {
        if (this.getComponent(fieldName) != null) {
            this.getComponent(fieldName).setVisible(visible);
        }
        if (this.getLabel(fieldName) != null) {
            this.getLabel(fieldName).setVisible(visible);
        }
    }

    protected void reportValidationError(String errorMessage) {
        JOptionPane.showMessageDialog(this, errorMessage, "JUMP", 0);
    }

    protected boolean isInputValid() {
        return this.firstValidationErrorMessage() == null;
    }

    protected String firstValidationErrorMessage() {
        for (String fieldName : this.fieldNameToEnableCheckListMap.keySet()) {
            for (EnableCheck enableCheck : this.fieldNameToEnableCheckListMap.getItems(fieldName)) {
                String message = enableCheck.check(null);
                if (message == null) continue;
                return message;
            }
        }
        return null;
    }

    public <T> JComboBox<T> addLayerableComboBox(String fieldName, T initialValue, String toolTipText, Collection<T> layerable) {
        JComboBox<T> comboBox = this.addComboBox(fieldName, initialValue, layerable, toolTipText);
        LayerNameRenderer layerListCellRenderer = new LayerNameRenderer();
        layerListCellRenderer.setCheckBoxVisible(false);
        layerListCellRenderer.setProgressIconLabelVisible(false);
        comboBox.setRenderer(layerListCellRenderer);
        comboBox.invalidate();
        return comboBox;
    }
}

