/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model.cache;

import com.vividsolutions.jump.datastore.DataStoreConnection;
import com.vividsolutions.jump.datastore.DataStoreMetadata;
import com.vividsolutions.jump.datastore.FilterQuery;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.FeatureInputStream;
import com.vividsolutions.jump.util.ListWrapper;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.datastore.ConnectionManager;
import com.vividsolutions.jump.workbench.ui.plugin.AddNewLayerPlugIn;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.SwingUtilities;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.util.Assert;

public class DynamicFeatureCollection
implements FeatureCollection {
    private Integer featureLimit = null;
    private FilterQuery spatialQuery;
    private ConnectionManager connectionManager;
    private ConnectionDescriptor connectionDescriptor;
    private volatile Object currentQueryContext;
    private FeatureSchema schema = AddNewLayerPlugIn.createBlankFeatureCollection().getFeatureSchema();

    public DynamicFeatureCollection(ConnectionDescriptor connectionDescriptor, ConnectionManager connectionManager, FilterQuery spatialQuery) {
        this.connectionManager = connectionManager;
        this.connectionDescriptor = connectionDescriptor;
        this.spatialQuery = spatialQuery;
    }

    public void setFeatureLimit(Integer featureLimit) {
        this.featureLimit = featureLimit;
    }

    @Override
    public FeatureSchema getFeatureSchema() {
        return this.schema;
    }

    @Override
    public List<Feature> query(Envelope envelope) {
        FeatureInputStream myFeatureInputStream;
        Object myQueryContext;
        this.currentQueryContext = myQueryContext = new Object();
        this.spatialQuery.setFilterGeometry(new GeometryFactory().toGeometry(envelope));
        try {
            myFeatureInputStream = this.connectionManager.getOpenConnection(this.connectionDescriptor).execute(this.spatialQuery);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (myQueryContext != this.currentQueryContext) {
            return Collections.emptyList();
        }
        this.schema = myFeatureInputStream.getFeatureSchema();
        return new ListWrapper<Feature>(){

            @Override
            public Collection<Feature> getCollection() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterator<Feature> iterator() {
                return new Iterator<Feature>(){
                    private int featuresReturned = 0;
                    private boolean featureInputStreamOpen = true;

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean hasNext() {
                        try {
                            if (DynamicFeatureCollection.this.featureLimit != null && this.featuresReturned >= DynamicFeatureCollection.this.featureLimit) {
                                this.closeFeatureInputStream();
                                return false;
                            }
                            if (myQueryContext != DynamicFeatureCollection.this.currentQueryContext) {
                                this.closeFeatureInputStream();
                                return false;
                            }
                            if (!this.featureInputStreamOpen) {
                                return false;
                            }
                            if (!myFeatureInputStream.hasNext()) {
                                this.closeFeatureInputStream();
                                return false;
                            }
                            return true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new RuntimeException(e);
                        }
                    }

                    private void closeFeatureInputStream() throws Exception {
                        myFeatureInputStream.close();
                        this.featureInputStreamOpen = false;
                    }

                    @Override
                    public Feature next() {
                        DynamicFeatureCollection.this.assertNotInGUIThread();
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        try {
                            ++this.featuresReturned;
                            return myFeatureInputStream.next();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
        };
    }

    @Override
    public void add(Feature feature) {
        throw new UnsupportedOperationException();
    }

    public void addAll(Collection features) {
        throw new UnsupportedOperationException();
    }

    public void removeAll(Collection features) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(Feature feature) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Feature> remove(Envelope env) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Envelope getEnvelope() {
        DataStoreMetadata dsm;
        DataStoreConnection dsc;
        try {
            dsc = this.connectionManager.getOpenConnection(this.connectionDescriptor);
        }
        catch (Exception e1) {
            return new Envelope();
        }
        Envelope e = null;
        if (dsc != null && (dsm = dsc.getMetadata()) != null && this.spatialQuery != null) {
            e = dsm.getExtents(this.spatialQuery.getDatasetName(), this.spatialQuery.getGeometryAttributeName());
        }
        return e;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Feature> getFeatures() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Feature> iterator() {
        throw new UnsupportedOperationException();
    }

    private void assertNotInGUIThread() {
        Assert.isTrue((!SwingUtilities.isEventDispatchThread() ? 1 : 0) != 0, (String)"This operation should be done outside of the GUI thread");
    }
}

