/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDatasetFactory;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.ObservableFeatureCollection;
import java.util.ArrayList;
import java.util.Collection;

public class LayerView
extends Layer {
    private Layer layer;
    String layerName;

    public LayerView() {
    }

    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    @Override
    public void setLayerManager(LayerManager layerManager) {
        super.setLayerManager(layerManager);
        this.layer = layerManager.getLayer(this.getLayerName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayerView(String layerName, LayerManager layerManager) {
        super(layerName, layerManager.generateLayerFillColor(), layerManager.getLayer(layerName).getFeatureCollectionWrapper(), layerManager);
        this.layerName = layerName;
        this.layer = layerManager.getLayer(layerName);
        boolean firingEvents = this.getLayerManager().isFiringEvents();
        this.getLayerManager().setFiringEvents(false);
        try {
            this.setName("v");
            this.setName(layerManager.uniqueLayerName(this.getName()));
        }
        finally {
            this.getLayerManager().setFiringEvents(firingEvents);
        }
    }

    public String getFullName() {
        if (this.layer instanceof LayerView) {
            return ((LayerView)this.layer).getFullName() + " - " + this.getName();
        }
        return "-> " + this.getLayerName() + " - " + this.getName();
    }

    @Override
    public void setFeatureCollection(FeatureCollection featureCollection) {
        ObservableFeatureCollection observableFeatureCollection = (ObservableFeatureCollection)featureCollection;
        observableFeatureCollection.add(new ObservableFeatureCollection.Listener(){

            @Override
            public void featuresAdded(Collection<Feature> features) {
                LayerView.this.getLayerManager().fireFeaturesChanged(features, FeatureEventType.ADDED, LayerView.this);
            }

            @Override
            public void featuresRemoved(Collection<Feature> features) {
                LayerView.this.getLayerManager().fireFeaturesChanged(features, FeatureEventType.DELETED, LayerView.this);
            }
        });
        super.setFeatureCollectionWrapper(observableFeatureCollection);
    }

    @Override
    public FeatureCollectionWrapper getFeatureCollectionWrapper() {
        if (this.layer != null) {
            return this.layer.getFeatureCollectionWrapper();
        }
        this.layer = this.getLayerManager().getLayer(this.layerName);
        if (this.layer != null) {
            return this.layer.getFeatureCollectionWrapper();
        }
        return new ObservableFeatureCollection(FeatureDatasetFactory.createFromGeometry(new ArrayList()));
    }

    public Layer getLayer() {
        return this.layer;
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public void dispose() {
    }
}

