/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jump.util.LangUtil;
import com.vividsolutions.jump.util.SimpleTreeModel;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingStyle;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreePath;
import org.locationtech.jts.util.Assert;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.RasterSymbology;

public class LayerTreeModel
extends SimpleTreeModel {
    private final LayerManagerProxy layerManagerProxy;

    public LayerTreeModel(LayerManagerProxy layerManagerProxy) {
        super(new Root());
        this.layerManagerProxy = layerManagerProxy;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        for (int i = 0; i < this.getChildCount(parent); ++i) {
            if (child instanceof ColorThemingValue && this.getChild(parent, i) instanceof ColorThemingValue && this.getChild(parent, i).equals(child)) {
                return i;
            }
            if (child instanceof RasterStyleValueIntv && this.getChild(parent, i) instanceof RasterStyleValueIntv && this.getChild(parent, i).equals(child)) {
                return i;
            }
            if (!(child instanceof RasterStyleValueRamp) || !(this.getChild(parent, i) instanceof RasterStyleValueRamp) || !this.getChild(parent, i).equals(child)) continue;
            return i;
        }
        return super.getIndexOfChild(parent, child);
    }

    @Override
    public List<?> getChildren(Object parent) {
        if (parent == this.getRoot()) {
            return this.layerManagerProxy.getLayerManager().getCategories();
        }
        if (parent instanceof Category) {
            return ((Category)parent).getLayerables();
        }
        if (parent instanceof Layerable) {
            if (parent instanceof Layer) {
                ColorThemingStyle colorThemingStyle = ColorThemingStyle.get((Layer)parent);
                if (colorThemingStyle.isEnabled()) {
                    Map<Object, BasicStyle> attributeValueToBasicStyleMap = colorThemingStyle.getAttributeValueToBasicStyleMap();
                    HashMap<Object, String> attributeValueToLabelMap = new HashMap<Object, String>(colorThemingStyle.getAttributeValueToLabelMap());
                    ArrayList<ColorThemingValue> colorThemingValues = new ArrayList<ColorThemingValue>();
                    for (Map.Entry<Object, BasicStyle> entry : attributeValueToBasicStyleMap.entrySet()) {
                        colorThemingValues.add(new ColorThemingValue(entry.getKey(), entry.getValue(), (String)attributeValueToLabelMap.get(entry.getKey())));
                    }
                    return colorThemingValues;
                }
                return Collections.EMPTY_LIST;
            }
            if (parent instanceof RasterImageLayer) {
                RasterImageLayer rasterImageLayer = (RasterImageLayer)parent;
                if (rasterImageLayer.getSymbology() != null && rasterImageLayer.getMetadata() != null) {
                    RasterSymbology rasterSymbology = rasterImageLayer.getSymbology();
                    double bottomValue = rasterImageLayer.getMetadata().getStats().getMin(0);
                    double topValue = rasterImageLayer.getMetadata().getStats().getMax(0);
                    Double[] keys = rasterSymbology.getColorMapEntries_tm().keySet().toArray(new Double[0]);
                    if (!rasterImageLayer.getSymbology().getColorMapType().equals("RAMP")) {
                        ArrayList<RasterStyleValueIntv> styleValues_l = new ArrayList<RasterStyleValueIntv>();
                        for (int i = 0; i < keys.length; ++i) {
                            Double key = keys[i];
                            if (rasterImageLayer.isNoData(key)) continue;
                            double nextValue = i == keys.length - 1 ? topValue : keys[i + 1];
                            Color color = rasterSymbology.getColorMapEntries_tm().get(key);
                            styleValues_l.add(new RasterStyleValueIntv(rasterSymbology.getColorMapType(), color, key, nextValue, key.toString()));
                        }
                        return styleValues_l;
                    }
                    ArrayList<RasterStyleValueRamp> styleValues_l = new ArrayList<RasterStyleValueRamp>();
                    ArrayList<Color> colors_l = new ArrayList<Color>();
                    for (int i = keys.length - 1; i >= 0; --i) {
                        Double key = keys[i];
                        if (rasterImageLayer.isNoData(key)) continue;
                        Color color = rasterSymbology.getColorMapEntries_tm().get(key);
                        colors_l.add(color);
                    }
                    Color[] colors = colors_l.toArray(new Color[0]);
                    RasterStyleValueRamp ramp = new RasterStyleValueRamp(topValue, bottomValue, colors);
                    styleValues_l.add(ramp);
                    return styleValues_l;
                }
                return Collections.EMPTY_LIST;
            }
            return Collections.EMPTY_LIST;
        }
        if (parent instanceof SymbolizationLeafNode) {
            return Collections.EMPTY_LIST;
        }
        Assert.shouldNeverReachHere((String)parent.getClass().getName());
        return null;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        if (path.getLastPathComponent() instanceof Layerable) {
            ((Layerable)path.getLastPathComponent()).setName((String)newValue);
        } else if (path.getLastPathComponent() instanceof Category) {
            ((Category)path.getLastPathComponent()).setName((String)newValue);
        } else {
            Assert.shouldNeverReachHere();
        }
    }

    public static class RasterStyleValueRamp
    implements SymbolizationLeafNode {
        private final Double topValue;
        private final Double bottomValue;
        private final Color[] colors;

        RasterStyleValueRamp(Double topValue, Double bottomValue, Color[] colors) {
            this.topValue = topValue;
            this.bottomValue = bottomValue;
            this.colors = colors;
        }

        public String toString() {
            return this.bottomValue + "-" + this.topValue;
        }

        public Double getTopValue() {
            return this.topValue;
        }

        public Double getBottomValue() {
            return this.bottomValue;
        }

        public Color[] getColors() {
            return this.colors;
        }

        public boolean equals(Object other) {
            return other instanceof RasterStyleValueRamp && LangUtil.bothNullOrEqual(this.topValue, ((RasterStyleValueRamp)other).topValue) && LangUtil.bothNullOrEqual(this.bottomValue, ((RasterStyleValueRamp)other).bottomValue);
        }
    }

    public static class RasterStyleValueIntv
    implements SymbolizationLeafNode {
        private final String colorMapType;
        private final Color color;
        private final Double nextValue;
        private final Double value;
        private final String label;

        RasterStyleValueIntv(String colorMapType, Color color, Double value, Double nextValue, String label) {
            this.colorMapType = colorMapType;
            this.color = color;
            this.nextValue = nextValue;
            this.value = value;
            this.label = label;
        }

        public String getColorMapType() {
            return this.colorMapType;
        }

        public Color getColor() {
            return this.color;
        }

        public Double getNextValue() {
            return this.nextValue;
        }

        public Double getValue() {
            return this.value;
        }

        public String getLabel() {
            return this.label;
        }

        public String toString() {
            return this.label;
        }

        public boolean equals(Object other) {
            return other instanceof RasterStyleValueIntv && LangUtil.bothNullOrEqual(this.value, ((RasterStyleValueIntv)other).value) && this.getValue().doubleValue() == ((RasterStyleValueIntv)other).getValue().doubleValue();
        }

        public int hashCode() {
            int hash = 3;
            hash = 89 * hash + (this.color != null ? this.color.hashCode() : 0);
            hash = 89 * hash + (this.value != null ? this.value.hashCode() : 0);
            return hash;
        }
    }

    public static class ColorThemingValue
    implements SymbolizationLeafNode {
        private final Object value;
        private final BasicStyle style;
        private final String label;

        ColorThemingValue(Object value, BasicStyle style, String label) {
            this.value = value;
            this.style = style;
            Assert.isTrue((label != null ? 1 : 0) != 0);
            this.label = label;
        }

        public String toString() {
            return this.label;
        }

        public boolean equals(Object other) {
            return other instanceof ColorThemingValue && LangUtil.bothNullOrEqual(this.value, ((ColorThemingValue)other).value) && this.style == ((ColorThemingValue)other).style;
        }

        public BasicStyle getStyle() {
            return this.style;
        }
    }

    public static interface SymbolizationLeafNode {
    }

    public static class Root {
        private Root() {
        }
    }
}

