/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.graphic;

import com.vividsolutions.jump.io.CompressedFile;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageException;
import com.vividsolutions.jump.workbench.imagery.graphic.AbstractGraphicImage;
import com.vividsolutions.jump.workbench.imagery.graphic.WorldFile;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.imageio.ImageIO;

public class IOGraphicImage
extends AbstractGraphicImage {
    InputStream is = null;

    public IOGraphicImage(String uri, WorldFile wf) {
        super(uri, wf);
    }

    @Override
    protected void initImage() throws ReferencedImageException {
        BufferedImage image = this.getImage();
        if (image != null) {
            return;
        }
        try {
            URI uri = new URI(this.getUri());
            if (CompressedFile.isArchive(uri) || CompressedFile.isCompressed(uri)) {
                this.is = CompressedFile.openFile(uri);
                image = ImageIO.read(this.is);
                IOGraphicImage.close(this.is);
            } else {
                image = ImageIO.read(new File(uri));
            }
            if (image == null) {
                throw new IOException("ImageIO read returned null");
            }
            image.getData().getParent().getDataBuffer();
            this.setImage(image);
            this.setType(FileUtil.getExtension(CompressedFile.getTargetFileWithPath(uri)));
        }
        catch (Exception e) {
            throw new ReferencedImageException(e);
        }
        finally {
            IOGraphicImage.close(this.is);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

