/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.graphic;

import com.vividsolutions.jump.io.CompressedFile;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageException;
import com.vividsolutions.jump.workbench.imagery.graphic.CommonsImage;
import com.vividsolutions.jump.workbench.imagery.graphic.WorldFile;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.imaging.FormatCompliance;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.tiff.TiffContents;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.apache.commons.imaging.formats.tiff.TiffRasterData;
import org.apache.commons.imaging.formats.tiff.TiffRasterStatistics;
import org.apache.commons.imaging.formats.tiff.TiffReader;
import org.apache.commons.imaging.formats.tiff.constants.GdalLibraryTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldTypeAscii;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldTypeByte;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.floatingpoint.PaletteEntryForRange;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.floatingpoint.PaletteEntryForValue;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.floatingpoint.PhotometricInterpreterFloat;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.locationtech.jts.geom.Envelope;
import org.openjump.util.UriUtil;

public class CommonsTIFFImage
extends CommonsImage {
    public CommonsTIFFImage(String location, WorldFile wf) {
        super(location, wf);
    }

    @Override
    protected void initImage() throws ReferencedImageException {
        BufferedImage image = this.getImage();
        if (image != null) {
            return;
        }
        String uri = this.getUri();
        try {
            ByteSource byteSource = ByteSource.inputStream((InputStream)CompressedFile.openFile(uri), (String)UriUtil.getFileName(uri));
            TiffReader tiffReader = new TiffReader(true);
            TiffContents contents = tiffReader.readDirectories(byteSource, true, FormatCompliance.getDefault());
            TiffDirectory directory = (TiffDirectory)contents.directories.get(0);
            if (!directory.hasTiffRasterData()) {
                super.initImage();
                return;
            }
            TiffImagingParameters params = new TiffImagingParameters();
            TiffRasterData rasterData = directory.getRasterData(params);
            List fieldList = directory.getDirectoryEntries();
            Float noData = Float.valueOf(Float.NaN);
            for (TiffField tiffField : fieldList) {
                Logger.info("TiffField: " + tiffField.toString());
                if (tiffField.getTag() != GdalLibraryTagConstants.EXIF_TAG_GDAL_NO_DATA.tag) continue;
                try {
                    String noDataString = "";
                    if (tiffField.getFieldType() instanceof FieldTypeAscii) {
                        noDataString = tiffField.getStringValue();
                        if (noDataString.equalsIgnoreCase("NaN")) {
                            noDataString = "NaN";
                        }
                    } else if (tiffField.getFieldType() instanceof FieldTypeByte) {
                        noDataString = new String(tiffField.getByteArrayValue());
                    }
                    noData = Float.valueOf(Float.parseFloat(noDataString));
                }
                catch (NumberFormatException e) {
                    Logger.error(e);
                }
            }
            TiffRasterStatistics simpleStats = rasterData.getSimpleStatistics(noData.floatValue());
            int w = rasterData.getWidth();
            int h = rasterData.getHeight();
            float minValue = simpleStats.getMinValue();
            float maxValue = simpleStats.getMaxValue();
            TiffField piField = directory.findField((TagInfo)TiffTagConstants.TIFF_TAG_PHOTOMETRIC_INTERPRETATION);
            boolean ascendingGrayTones = piField == null || piField.getIntValue() != 0;
            ArrayList<Object> paletteList = new ArrayList<Object>();
            paletteList.add(new PaletteEntryForValue(noData.floatValue(), new Color(1.0f, 0.0f, 0.0f, 0.0f)));
            if (minValue == maxValue) {
                paletteList.add(new PaletteEntryForValue(minValue, Color.gray));
            } else {
                paletteList.add(new PaletteEntryForRange(minValue, maxValue, ascendingGrayTones ? Color.black : Color.white, ascendingGrayTones ? Color.white : Color.black));
            }
            PhotometricInterpreterFloat photometricInterpreter = new PhotometricInterpreterFloat(paletteList);
            ImageBuilder builder = new ImageBuilder(w, h, true);
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    float f = rasterData.getValue(x, y);
                    int argb = photometricInterpreter.mapValueToArgb(f);
                    builder.setRgb(x, y, argb);
                }
            }
            BufferedImage bImage = builder.getBufferedImage();
            this.setImage(bImage);
        }
        catch (Exception e) {
            throw new ReferencedImageException(e);
        }
    }

    @Override
    public Envelope getEnvelope() throws ReferencedImageException {
        return super.getEnvelope();
    }
}

