/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.geotiff;

import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.imagery.geotiff.GeoReferencedRaster;
import com.vividsolutions.jump.workbench.imagery.graphic.WorldFile;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.geotiff.image.jai.GeoTIFFDescriptor;
import org.geotiff.image.jai.GeoTIFFDirectory;
import org.libtiff.jai.codec.XTIFFField;
import org.locationtech.jts.geom.Coordinate;

public class GeoTIFFRaster
extends GeoReferencedRaster {
    private final String MSG_GENERAL = "This is not a valid GeoTIFF file.";
    String fileName;
    boolean hoPatch = false;

    public GeoTIFFRaster(String imageFileLocation) throws Exception {
        super(imageFileLocation);
        this.fileName = imageFileLocation;
        this.registerWithJAI();
        this.readRasterfile();
    }

    private void registerWithJAI() {
        GeoTIFFDescriptor.register();
    }

    private void parseGeoTIFFDirectory(GeoTIFFDirectory dir) throws Exception {
        XTIFFField fieldModelTiePoints = dir.getField(33922);
        if (fieldModelTiePoints == null) {
            XTIFFField fieldModelGeoTransform = dir.getField(34264);
            if (fieldModelGeoTransform == null) {
                throw new Exception("Missing tiepoints-tag and tranformation matrix-tag parameters in file.\nThis is not a valid GeoTIFF file.");
            }
            double[] tags = new double[]{fieldModelGeoTransform.getAsDouble(0), fieldModelGeoTransform.getAsDouble(1), fieldModelGeoTransform.getAsDouble(4), fieldModelGeoTransform.getAsDouble(5), fieldModelGeoTransform.getAsDouble(3), fieldModelGeoTransform.getAsDouble(7)};
            this.setEnvelope(tags);
        } else {
            this.setCoorRasterTiff_tiepointLT(new Coordinate(fieldModelTiePoints.getAsDouble(0), fieldModelTiePoints.getAsDouble(1), 0.0));
            this.setCoorModel_tiepointLT(new Coordinate(fieldModelTiePoints.getAsDouble(3), fieldModelTiePoints.getAsDouble(4), 0.0));
            this.setEnvelope();
            XTIFFField fieldModelPixelScale = dir.getField(33550);
            if (fieldModelPixelScale == null) {
                throw new Exception("Missing pixelscale-tag in file.\nThis is not a valid GeoTIFF file.");
            }
            this.setDblModelUnitsPerRasterUnit_X(fieldModelPixelScale.getAsDouble(0));
            this.setDblModelUnitsPerRasterUnit_Y(fieldModelPixelScale.getAsDouble(1));
        }
    }

    private String worldFileName() {
        int posDot = this.fileName.lastIndexOf(46);
        if (posDot == -1) {
            posDot = this.fileName.length();
        }
        return this.fileName.substring(0, posDot) + ".tfw";
    }

    private void parseWorldFile() throws IOException {
        InputStream is = WorldFile.find(this.fileName);
        List<String> lines = FileUtil.getContents(is);
        if (is != null) {
            is.close();
        }
        double[] tags = new double[6];
        for (int i = 0; i < 6; ++i) {
            String line = lines.get(i);
            tags[i] = Double.parseDouble(line);
        }
        this.setEnvelope(tags);
    }

    private void setEnvelope(double[] tags) {
        this.setCoorRasterTiff_tiepointLT(new Coordinate(-0.5, -0.5));
        this.setCoorModel_tiepointLT(new Coordinate(0.0, 0.0));
        this.setAffineTransformation(new AffineTransform(tags));
    }

    @Override
    protected void readRasterfile() throws Exception {
        super.readRasterfile();
        try {
            Object dir = this.src.getProperty("tiff.directory");
            if (dir instanceof GeoTIFFDirectory) {
                this.parseGeoTIFFDirectory((GeoTIFFDirectory)dir);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.parseWorldFile();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Exception("Neither geotiff tags nor valid worldfile found for file '" + this.fileName + "'.\n" + "This is not a valid GeoTIFF file.");
        }
    }
}

