/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.geoimg;

import com.vividsolutions.jump.JUMPException;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.imagery.ReferencedImage;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageException;
import com.vividsolutions.jump.workbench.imagery.geoimg.GeoReferencedRaster;
import com.vividsolutions.jump.workbench.model.Disposable;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.AlphaSetting;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.lang.reflect.InvocationTargetException;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.locationtech.jts.geom.Envelope;

public class GeoImage
implements ReferencedImage,
Disposable,
AlphaSetting {
    private GeoReferencedRaster gtr;
    private int alpha = 255;
    private double last_scale;
    private RenderedOp last_scale_img;
    private Envelope last_img_env;
    private RenderedImage last_rendering;
    private AffineTransform last_transform;
    private Envelope last_vwp_env;
    private BufferedImage full_scale_img;
    private double full_scale;

    public GeoImage(String location, Object reader) throws JUMPException {
        this.init(location, reader);
    }

    @Override
    public Envelope getEnvelope() {
        return this.gtr.getEnvelope();
    }

    private void init(String location, Object reader) throws ReferencedImageException {
        try {
            this.gtr = new GeoReferencedRaster(location, reader);
            this.gtr.src.getData();
        }
        catch (Exception ex) {
            this.dispose();
            throw new ReferencedImageException(ex);
        }
    }

    @Override
    public synchronized void paint(Feature f, Graphics2D g, Viewport viewport) throws ReferencedImageException {
        try {
            ParameterBlock pb;
            RenderedOp img;
            Envelope envImage = this.gtr.getEnvelope(f);
            RenderedOp src_img = this.gtr.getRenderedOp();
            RenderingHints hints = this.gtr.createCacheRenderingHints();
            double scale = viewport.getScale();
            Envelope envModel_viewport = viewport.getEnvelopeInModelCoordinates();
            if (this.last_scale == scale && this.last_img_env != null && this.last_img_env.equals((Object)envImage) && this.last_vwp_env != null && this.last_vwp_env.equals((Object)envModel_viewport) && this.last_rendering != null && this.last_transform != null) {
                this.draw(g, null);
                return;
            }
            try {
                if (this.last_scale == scale && this.last_scale_img != null && this.last_img_env != null && this.last_img_env.equals((Object)envImage)) {
                    img = this.last_scale_img;
                } else {
                    Object scale_src_img;
                    double scaleY_toUse;
                    double scaleX_toUse;
                    double scaleX = scale * Math.abs(this.gtr.getScaleX());
                    double scaleY = scale * Math.abs(this.gtr.getScaleY());
                    double scaledW = scaleX * (double)src_img.getWidth();
                    double scaledH = scaleY * (double)src_img.getHeight();
                    double imgW = src_img.getWidth();
                    double imgH = src_img.getHeight();
                    if (scaledW < 2.0 || scaledH < 2.0) {
                        return;
                    }
                    if ((imgW > 2000.0 || imgH > 2000.0) && scaledW < 2000.0 && scaledH < 2000.0) {
                        if (this.full_scale_img == null) {
                            this.full_scale = imgW > imgH ? 2000.0 / imgW : 2000.0 / imgH;
                            pb = new ParameterBlock();
                            pb.addSource(src_img);
                            pb.add(this.full_scale);
                            pb.add(this.full_scale);
                            this.full_scale_img = JAI.create((String)"subsampleaverage", (ParameterBlock)pb, null).getAsBufferedImage();
                        }
                        scaleX_toUse = scaleX / this.full_scale;
                        scaleY_toUse = scaleY / this.full_scale;
                        scale_src_img = this.full_scale_img;
                    } else {
                        scaleX_toUse = scaleX;
                        scaleY_toUse = scaleY;
                        scale_src_img = src_img;
                    }
                    pb = new ParameterBlock();
                    pb.addSource(scale_src_img);
                    if (scaleX > 0.1 || scaleY > 0.1) {
                        pb.add((float)scaleX_toUse);
                        pb.add((float)scaleY_toUse);
                        pb.add(0.0f);
                        pb.add(0.0f);
                        AffineTransform tr = new AffineTransform(scaleX_toUse, 0.0, 0.0, scaleY_toUse, 0.0, 0.0);
                        img = JAI.create((String)"affine", (RenderedImage)scale_src_img, (Object)tr, (Object)new InterpolationNearest());
                    } else {
                        pb.add(scaleX_toUse);
                        pb.add(scaleY_toUse);
                        img = JAI.create((String)"subsampleaverage", (ParameterBlock)pb, (RenderingHints)hints);
                    }
                    this.last_scale = scale;
                    this.last_scale_img = img;
                }
                this.last_img_env = envImage;
                this.last_vwp_env = envModel_viewport;
                if (img.getWidth() < 1 || img.getHeight() < 1) {
                    return;
                }
            }
            catch (Exception e) {
                if (!e.getClass().getName().endsWith("ImagingException")) {
                    throw e;
                }
                Throwable cause = e.getCause();
                if (!(cause instanceof Throwable) || !(cause instanceof InvocationTargetException)) {
                    throw e;
                }
                if (!((cause = cause.getCause()) instanceof Throwable) || !(cause instanceof IllegalArgumentException)) {
                    throw e;
                }
                return;
            }
            double ratio_cropX = (envModel_viewport.getMinX() - envImage.getMinX()) / envImage.getWidth();
            double ratio_cropY = (envImage.getMaxY() - envModel_viewport.getMaxY()) / envImage.getHeight();
            double ratio_cropW = envModel_viewport.getWidth() / envImage.getWidth();
            double ratio_cropH = envModel_viewport.getHeight() / envImage.getHeight();
            double raster_cropX = ratio_cropX * (double)img.getWidth();
            double raster_cropY = ratio_cropY * (double)img.getHeight();
            double raster_cropW = ratio_cropW * (double)img.getWidth();
            double raster_cropH = ratio_cropH * (double)img.getHeight();
            double raster_offsetX = 0.0;
            double raster_offsetY = 0.0;
            if (raster_cropX < 0.0) {
                raster_offsetX = -raster_cropX;
                raster_cropX = 0.0;
            }
            if (raster_cropY < 0.0) {
                raster_offsetY = -raster_cropY;
                raster_cropY = 0.0;
            }
            raster_cropX = Math.min((float)raster_cropX, (float)img.getWidth());
            raster_cropY = Math.min((float)raster_cropY, (float)img.getHeight());
            raster_cropW = Math.min((float)raster_cropW, (float)((double)img.getWidth() - raster_cropX));
            raster_cropH = Math.min((float)raster_cropH, (float)((double)img.getHeight() - raster_cropY));
            pb = new ParameterBlock();
            pb.addSource(img);
            pb.add((float)raster_cropX);
            pb.add((float)raster_cropY);
            pb.add((float)raster_cropW - Math.ulp((float)raster_cropW));
            pb.add((float)raster_cropH - Math.ulp((float)raster_cropH));
            img = JAI.create((String)"crop", (ParameterBlock)pb, null);
            pb = new ParameterBlock();
            pb.addSource(img);
            pb.add((float)(raster_offsetX - (double)img.getMinX()));
            pb.add((float)(raster_offsetY - (double)img.getMinY()));
            img = JAI.create((String)"translate", (ParameterBlock)pb, null);
            this.last_rendering = img.getAsBufferedImage();
            Rectangle b = img.getBounds();
            this.last_transform = AffineTransform.getTranslateInstance(b.getX(), b.getY());
            this.draw(g, (RenderedImage)img);
        }
        catch (Exception ex) {
            throw new ReferencedImageException(ex);
        }
    }

    private void draw(Graphics2D g, RenderedImage img) {
        AffineTransform aft;
        Composite composite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / 255.0f));
        if (img != null) {
            aft = new AffineTransform();
        } else {
            img = this.last_rendering;
            aft = this.last_transform;
        }
        g.drawRenderedImage(img, aft);
        g.setComposite(composite);
    }

    @Override
    public String getType() {
        return this.gtr != null ? this.gtr.getType() : "";
    }

    @Override
    public String getLoader() {
        return this.gtr != null ? this.gtr.getLoader().getClass().getName() : "";
    }

    @Override
    public void dispose() {
        if (this.gtr != null) {
            this.gtr.dispose();
        }
    }

    @Override
    public int getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }
}

