/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.datasource;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.DataSourceQueryChooserDialog;
import com.vividsolutions.jump.workbench.datasource.FileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.openjump.core.ui.plugin.file.open.JFCWithEnterAction;

public class SaveFileDataSourceQueryChooser
extends FileDataSourceQueryChooser {
    private static final String FILE_CHOOSER_DIRECTORY_KEY = SaveFileDataSourceQueryChooser.class.getName() + " - FILE CHOOSER DIRECTORY";
    public static final String FILE_CHOOSER_PANEL_KEY = SaveFileDataSourceQueryChooser.class.getName() + " - SAVE FILE CHOOSER PANEL";
    private static final Pattern fileNameRegex = Pattern.compile("^([a-zA-Z]:|\\\\\\\\[^/\\\\\\?%\\*:\\|\"<>]+|\\.\\.|\\.)?([/\\\\]([^/\\\\\\?%\\*:\\|\"<>]+|\\.\\.|\\.))*([^/\\\\\\?%\\*:\\|\"<>\\.]+)(\\.[^/\\\\\\?%\\*:\\|\"<>\\.]+)?$");
    private WorkbenchContext context;

    public SaveFileDataSourceQueryChooser(Class dataSourceClass, String description, String[] extensions, WorkbenchContext context) {
        super(dataSourceClass, description, extensions);
        this.context = context;
    }

    @Override
    protected FileDataSourceQueryChooser.FileChooserPanel getFileChooserPanel() {
        if (this.blackboard().get(FILE_CHOOSER_PANEL_KEY) == null) {
            final JFCWithEnterAction fileChooser = new JFCWithEnterAction();
            fileChooser.setDialogType(1);
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setControlButtonsAreShown(false);
            this.blackboard().put(FILE_CHOOSER_PANEL_KEY, new FileDataSourceQueryChooser.FileChooserPanel(fileChooser, this.blackboard()));
            if (PersistentBlackboardPlugIn.get(this.context).get(FILE_CHOOSER_DIRECTORY_KEY) != null) {
                fileChooser.setCurrentDirectory(new File((String)PersistentBlackboardPlugIn.get(this.context).get(FILE_CHOOSER_DIRECTORY_KEY)));
            }
            fileChooser.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    if (event.getAncestor() instanceof DataSourceQueryChooserDialog) {
                        fileChooser.rescanCurrentDirectory();
                    }
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                }
            });
            fileChooser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (Container c = fileChooser.getParent(); c != null; c = c.getParent()) {
                        if (!(c instanceof DataSourceQueryChooserDialog)) continue;
                        ((DataSourceQueryChooserDialog)c).setOKPressed();
                        break;
                    }
                }
            });
        }
        return (FileDataSourceQueryChooser.FileChooserPanel)this.blackboard().get(FILE_CHOOSER_PANEL_KEY);
    }

    private Blackboard blackboard() {
        return this.context.getBlackboard();
    }

    @Override
    public Collection<DataSourceQuery> getDataSourceQueries() {
        PersistentBlackboardPlugIn.get(this.context).put(FILE_CHOOSER_DIRECTORY_KEY, this.getFileChooserPanel().getChooser().getCurrentDirectory().toString());
        return super.getDataSourceQueries();
    }

    @Override
    public File[] getSelectedFiles() {
        String extension;
        File[] files = new File[]{this.getFileChooserPanel().getChooser().getSelectedFile()};
        String string = extension = this.getExtensions().length > 0 ? this.getExtensions()[0] : null;
        if (extension == null || extension.isEmpty()) {
            return files;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory() || this.hasValidExtension(file)) continue;
            files[i] = new File(file.getPath() + "." + extension);
        }
        return files;
    }

    private boolean hasValidExtension(File file) {
        String[] validExtensions = this.getExtensions();
        String fileName = file.getName();
        for (String validExt : validExtensions) {
            if (!fileName.toLowerCase().endsWith("." + validExt.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInputValid() {
        boolean overwrite;
        File file;
        if (!super.isInputValid()) {
            return false;
        }
        File file2 = file = this.getSelectedFiles().length > 0 ? this.getSelectedFiles()[0] : null;
        if (file == null) {
            return false;
        }
        if (!fileNameRegex.matcher(file.getPath()).matches()) {
            this.context.getWorkbench().getFrame().warnUser(I18N.getInstance().get("com.vividsolutions.jump.workbench.datasource.SaveFileDataSourceQueryChooser.Invalid-file-name"));
            return false;
        }
        if (file.exists() && !(overwrite = GUIUtil.showConfirmOverwriteDialog(null, file))) {
            return false;
        }
        return super.isInputValid();
    }
}

