/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.datasource;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.io.datasource.Connection;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.AbstractLoadSaveDatasetPlugIn;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.util.Assert;

public abstract class AbstractSaveDatasetAsPlugIn
extends AbstractLoadSaveDatasetPlugIn {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        Assert.isTrue((this.getDataSourceQueries().size() == 1 ? 1 : 0) != 0);
        DataSourceQuery dataSourceQuery = this.getDataSourceQueries().iterator().next();
        monitor.allowCancellationRequests();
        monitor.report(I18N.getInstance().get("datasource.SaveDatasetAsPlugIn.saving") + " " + dataSourceQuery.toString() + "...");
        Connection connection = dataSourceQuery.getDataSource().getConnection();
        Layer layer = context.getSelectedLayer(0);
        FeatureCollectionWrapper fc = layer.getFeatureCollectionWrapper();
        try {
            connection.executeUpdate(dataSourceQuery.getQuery(), fc, monitor);
            layer.setDataSourceQuery(dataSourceQuery).setFeatureCollectionModified(false);
        }
        finally {
            connection.close();
        }
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }
}

