/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.datasource;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.coordsys.CoordinateSystemRegistry;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.datasource.Connection;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.AbstractLoadSaveDatasetPlugIn;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import java.util.ArrayList;
import org.locationtech.jts.util.Assert;
import org.openjump.core.ui.util.ExceptionUtil;

public abstract class AbstractLoadDatasetPlugIn
extends AbstractLoadSaveDatasetPlugIn {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        Assert.isTrue((!this.getDataSourceQueries().isEmpty() ? 1 : 0) != 0);
        boolean exceptionsEncountered = false;
        for (DataSourceQuery dataSourceQuery : this.getDataSourceQueries()) {
            ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
            Assert.isTrue((boolean)dataSourceQuery.getDataSource().isReadable());
            monitor.report(I18N.getInstance().get("datasource.LoadDatasetPlugIn.loading") + " " + dataSourceQuery.toString() + "...");
            try (Connection connection = dataSourceQuery.getDataSource().getConnection();){
                FeatureCollection dataset = dataSourceQuery.getDataSource().installCoordinateSystem(connection.executeQuery(dataSourceQuery.getQuery(), exceptions, monitor), CoordinateSystemRegistry.instance(context.getWorkbenchContext().getBlackboard()));
                if (dataset != null) {
                    context.getLayerManager().addLayer(this.chooseCategory(context), dataSourceQuery.toString(), dataset).setDataSourceQuery(dataSourceQuery).setFeatureCollectionModified(false);
                }
            }
            if (exceptions.isEmpty()) continue;
            if (!exceptionsEncountered) {
                context.getOutputFrame().createNewDocument();
                exceptionsEncountered = true;
            }
            this.reportExceptions(exceptions, dataSourceQuery, context);
        }
        if (exceptionsEncountered) {
            context.getWorkbenchFrame().warnUser(I18N.getInstance().get("datasource.LoadDatasetPlugIn.problems-were-encountered"));
        }
    }

    private void reportExceptions(ArrayList<Throwable> exceptions, DataSourceQuery dataSourceQuery, PlugInContext context) {
        context.getOutputFrame().addHeader(1, exceptions.size() + " " + I18N.getInstance().get("datasource.LoadDatasetPlugIn.problem") + StringUtil.s(exceptions.size()) + " " + I18N.getInstance().get("datasource.LoadDatasetPlugIn.loading") + " " + dataSourceQuery.toString() + "." + (exceptions.size() > 10 ? " " + I18N.getInstance().get("datasource.LoadDatasetPlugIn.first-and-last-five") : ""));
        context.getOutputFrame().addText(I18N.getInstance().get("datasource.LoadDatasetPlugIn.see-view-log"));
        ExceptionUtil.reportExceptions(context, exceptions);
    }

    private String chooseCategory(PlugInContext context) {
        return context.getLayerNamePanel().getSelectedCategories().isEmpty() ? StandardCategoryNames.WORKING : context.getLayerNamePanel().getSelectedCategories().iterator().next().toString();
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck());
    }
}

