/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class Logger {
    private static boolean initialized = false;

    private static void init() {
        if (initialized) {
            return;
        }
        org.apache.log4j.Logger rootLogger = org.apache.log4j.Logger.getRootLogger();
        if (!rootLogger.getAllAppenders().hasMoreElements()) {
            rootLogger.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("[%p] %d{HH:mm:ss.SSS} %m%n"), "System.out"));
        }
        initialized = true;
    }

    public static void fatal(String msg) {
        Logger.log(msg, null, Level.FATAL, new Exception().getStackTrace()[0]);
    }

    public static void error(String msg) {
        Logger.log(msg, null, Level.ERROR, new Exception().getStackTrace()[0]);
    }

    public static void warn(String msg) {
        Logger.log(msg, null, Level.WARN, new Exception().getStackTrace()[0]);
    }

    public static void info(String msg) {
        Logger.log(msg, null, Level.INFO, new Exception().getStackTrace()[0]);
    }

    public static void debug(String msg) {
        Logger.log(msg, null, Level.DEBUG, new Exception().getStackTrace()[0]);
    }

    public static void trace(String msg) {
        Logger.log(msg, null, Level.TRACE, new Exception().getStackTrace()[0]);
    }

    public static void fatal(Throwable t) {
        Logger.log(null, t, Level.FATAL, new Exception().getStackTrace()[0]);
    }

    public static void error(Throwable t) {
        Logger.log(null, t, Level.ERROR, new Exception().getStackTrace()[0]);
    }

    public static void warn(Throwable t) {
        Logger.log(null, t, Level.WARN, new Exception().getStackTrace()[0]);
    }

    public static void info(Throwable t) {
        Logger.log(null, t, Level.INFO, new Exception().getStackTrace()[0]);
    }

    public static void debug(Throwable t) {
        Logger.log(null, t, Level.DEBUG, new Exception().getStackTrace()[0]);
    }

    public static void trace(Throwable t) {
        Logger.log(null, t, Level.TRACE, new Exception().getStackTrace()[0]);
    }

    public static void fatal(String msg, Throwable t) {
        Logger.log(msg, t, Level.FATAL, new Exception().getStackTrace()[0]);
    }

    public static void error(String msg, Throwable t) {
        Logger.log(msg, t, Level.ERROR, new Exception().getStackTrace()[0]);
    }

    public static void warn(String msg, Throwable t) {
        Logger.log(msg, t, Level.WARN, new Exception().getStackTrace()[0]);
    }

    public static void info(String msg, Throwable t) {
        Logger.log(msg, t, Level.INFO, new Exception().getStackTrace()[0]);
    }

    public static void debug(String msg, Throwable t) {
        Logger.log(msg, t, Level.DEBUG, new Exception().getStackTrace()[0]);
    }

    public static void trace(String msg, Throwable t) {
        Logger.log(msg, t, Level.TRACE, new Exception().getStackTrace()[0]);
    }

    public static void log(String msg, Throwable t, LogLevel logLevel, StackTraceElement calledFrom) {
        Logger.log(msg, t, logLevel.getEquivalent(), calledFrom);
    }

    private static void log(String msg, Throwable t, Level logLevel, StackTraceElement calledFrom) {
        StackTraceElement element = Logger.getCaller(calledFrom);
        org.apache.log4j.Logger logger = null;
        if (element != null) {
            logger = org.apache.log4j.Logger.getLogger((String)element.getClassName());
        }
        Logger.init();
        Level loggerLevel = logger.getEffectiveLevel();
        String msgAppend = "";
        if (element != null && !loggerLevel.isGreaterOrEqual((Priority)Level.INFO)) {
            msgAppend = " at " + element + "";
        }
        if (msg != null && msg.isEmpty()) {
            Logger.error("Logger: string message was empty but not null at " + element);
        }
        if (t == null && msg == null) {
            throw new IllegalArgumentException("Logger: either message or throwable must be given. " + element);
        }
        if (msg == null && ((msg = t.getMessage()) == null || msg.isEmpty())) {
            msg = t.getClass().getName();
        }
        logger.log((Priority)logLevel, (Object)(msg + msgAppend), t);
    }

    private static StackTraceElement getCaller(StackTraceElement calledFrom) {
        if (calledFrom == null) {
            throw new IllegalArgumentException();
        }
        StackTraceElement[] stack = new Exception().getStackTrace();
        boolean seenCaller = false;
        for (StackTraceElement element : stack) {
            if (seenCaller) {
                return element;
            }
            seenCaller = element.equals(calledFrom);
        }
        return null;
    }

    public static List<File> getLogFiles() {
        ArrayList<File> files = new ArrayList<File>();
        Enumeration loggers = LogManager.getCurrentLoggers();
        org.apache.log4j.Logger rootlogger = LogManager.getRootLogger();
        ArrayList<org.apache.log4j.Logger> list = Collections.list(loggers);
        list.add(rootlogger);
        for (org.apache.log4j.Logger logger : list) {
            Enumeration apps = logger.getAllAppenders();
            while (apps.hasMoreElements()) {
                Appender app = (Appender)apps.nextElement();
                if (!(app instanceof FileAppender)) continue;
                files.add(new File(((FileAppender)app).getFile()));
            }
        }
        return files;
    }

    public static void setLevel(String levelString) {
        Level level = Level.toLevel((String)levelString);
        if (level.equals((Object)Level.DEBUG) && !levelString.equalsIgnoreCase("debug")) {
            throw new IllegalArgumentException("unknown log verbosity level.");
        }
        org.apache.log4j.Logger.getRootLogger().setLevel(level);
        Logger.info(new MessageFormat("Setting log level to {0}").format(new Object[]{level}));
    }

    public static LogLevel getLevel() {
        StackTraceElement element = Logger.getCaller(new Exception().getStackTrace()[0]);
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)element.getClassName());
        return LogLevel.fromEquivalent(logger.getEffectiveLevel());
    }

    private static boolean isLoggerLevelEnabled(Level level) {
        StackTraceElement element = Logger.getCaller(new Exception().getStackTrace()[1]);
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)element.getClassName());
        return level.isGreaterOrEqual((Priority)logger.getEffectiveLevel());
    }

    public static boolean isFatalEnabled() {
        return Logger.isLoggerLevelEnabled(Level.FATAL);
    }

    public static boolean isErrorEnabled() {
        return Logger.isLoggerLevelEnabled(Level.ERROR);
    }

    public static boolean isWarnEnabled() {
        return Logger.isLoggerLevelEnabled(Level.WARN);
    }

    public static boolean isInfoEnabled() {
        return Logger.isLoggerLevelEnabled(Level.INFO);
    }

    public static boolean isDebugEnabled() {
        return Logger.isLoggerLevelEnabled(Level.DEBUG);
    }

    public static boolean isTraceEnabled() {
        return Logger.isLoggerLevelEnabled(Level.TRACE);
    }

    public static enum LogLevel {
        OFF(Level.OFF),
        FATAL(Level.FATAL),
        ERROR(Level.ERROR),
        WARN(Level.WARN),
        INFO(Level.INFO),
        DEBUG(Level.DEBUG),
        TRACE(Level.TRACE),
        ALL(Level.ALL);

        private final Level equivalent;

        public static LogLevel fromEquivalent(Level equivalent) {
            return LogLevel.valueOf(equivalent.toString());
        }

        private LogLevel(Level equivalent) {
            this.equivalent = equivalent;
        }

        private Level getEquivalent() {
            return this.equivalent;
        }
    }
}

