/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util.java2xml;

import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.util.java2xml.XMLBinder;
import com.vividsolutions.jump.workbench.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.locationtech.jts.util.Assert;

public class XML2Java
extends XMLBinder {
    private final ArrayList<Listener> listeners = new ArrayList();
    private ClassLoader classLoader = this.getClass().getClassLoader();

    public XML2Java() {
    }

    public XML2Java(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Object read(String xml, Class<?> c) throws Exception {
        try (StringReader reader = new StringReader(xml);){
            Object object = this.read(reader, c);
            return object;
        }
    }

    public Object read(Reader reader, Class<?> c) throws Exception {
        return this.read(new SAXBuilder().build(reader).getRootElement(), c);
    }

    public Object read(InputStream inputStream, Class<?> c) throws Exception {
        return this.read(new SAXBuilder().build(inputStream).getRootElement(), c);
    }

    public Object read(File file, Class<?> c) throws Exception {
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            Object object = new XML2Java().read(bis, c);
            return object;
        }
    }

    private void read(final Element tag, final Object object, List<Element> specElements) throws Exception {
        Assert.isTrue((tag != null ? 1 : 0) != 0);
        this.visit(specElements, new XMLBinder.SpecVisitor(){

            private void fillerTagSpecFound(String xmlName, List<Element> specChildElements) throws Exception {
                if (tag.getChildren(xmlName).size() == 0) {
                    System.err.println("WARNING: Expected 1 <" + xmlName + "> tag but found None");
                    return;
                }
                if (tag.getChildren(xmlName).size() != 1) {
                    throw new XMLBinder.XMLBinderException("Expected 1 <" + xmlName + "> tag but found " + tag.getChildren(xmlName).size());
                }
                XML2Java.this.read(tag.getChild(xmlName), object, specChildElements);
            }

            private void normalTagSpecFound(String xmlName, String javaName, List<Element> specChildElements) throws Exception {
                try {
                    XML2Java.this.setValuesFromTags(object, XML2Java.this.setter(object.getClass(), javaName), tag.getChildren(xmlName));
                    for (Element childTag : tag.getChildren(xmlName)) {
                        XML2Java.this.read(childTag, object, specChildElements);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }

            @Override
            public void tagSpecFound(String xmlName, String javaName, List<Element> specChildElements) throws Exception {
                if (javaName == null) {
                    this.fillerTagSpecFound(xmlName, specChildElements);
                } else {
                    this.normalTagSpecFound(xmlName, javaName, specChildElements);
                }
            }

            @Override
            public void attributeSpecFound(String xmlName, String javaName, boolean required) throws Exception {
                if (tag.getAttribute(xmlName) == null && required) {
                    String msg = "Expected '" + xmlName + "' attribute but found none. Tag = " + tag.getName() + "; Attributes = " + StringUtil.toCommaDelimitedString(tag.getAttributes());
                    throw new XMLBinder.XMLBinderException(msg);
                }
                if (tag.getAttribute(xmlName) != null) {
                    Method setter = XML2Java.this.setter(object.getClass(), javaName);
                    XML2Java.this.setValue(object, setter, XML2Java.this.toJava(tag.getAttribute(xmlName).getValue(), setter.getParameterTypes()[0]));
                }
            }
        }, object.getClass());
    }

    private Object read(Element tag, Class<?> c) throws Exception {
        if (tag.getAttribute("null") != null && tag.getAttributeValue("null").equals("true")) {
            return null;
        }
        if (c == QName.class) {
            return QName.valueOf(tag.getTextTrim());
        }
        if (this.specifyingTypeExplicitly(c)) {
            if (tag.getAttribute("class") == null) {
                throw new XMLBinder.XMLBinderException("Expected <" + tag.getName() + "> to have 'class' attribute but found none");
            }
            try {
                return this.read(tag, Class.forName(tag.getAttributeValue("class"), true, this.classLoader));
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                Logger.error("Class not found for tag " + tag.getName() + ": " + tag.getAttribute("class").getValue(), e);
                throw e;
            }
        }
        this.fireCreatingObject(c);
        if (this.hasCustomConverter(c)) {
            return this.toJava(tag.getTextTrim(), c);
        }
        Object object = c.newInstance();
        if (object instanceof Map) {
            for (Element mappingTag : tag.getChildren()) {
                if (!mappingTag.getName().equals("mapping")) {
                    throw new XMLBinder.XMLBinderException("Expected <" + tag.getName() + "> to have <mapping> tag but found none");
                }
                if (mappingTag.getChildren().size() != 2) {
                    throw new XMLBinder.XMLBinderException("Expected <" + tag.getName() + "> to have 2 tags under <mapping> but found " + mappingTag.getChildren().size());
                }
                if (mappingTag.getChildren("key").size() != 1) {
                    throw new XMLBinder.XMLBinderException("Expected <" + tag.getName() + "> to have 1 <key> tag under <mapping> but found " + mappingTag.getChildren("key").size());
                }
                if (mappingTag.getChildren("value").size() != 1) {
                    throw new XMLBinder.XMLBinderException("Expected <" + tag.getName() + "> to have 1 <value> tag under <mapping> but found " + mappingTag.getChildren("key").size());
                }
                ((Map)object).put(this.read(mappingTag.getChild("key"), Object.class), this.read(mappingTag.getChild("value"), Object.class));
            }
        } else if (object instanceof Collection) {
            for (Element itemTag : tag.getChildren()) {
                if (!itemTag.getName().equals("item")) {
                    throw new XMLBinder.XMLBinderException("Expected <" + tag.getName() + "> to have <item> tag but found none");
                }
                ((Collection)object).add(this.read(itemTag, Object.class));
            }
        } else {
            this.read(tag, object, this.specElements(object.getClass()));
        }
        return object;
    }

    private void fireCreatingObject(Class<?> c) {
        for (Listener listener : this.listeners) {
            listener.creatingObject(c);
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void setValuesFromTags(Object object, Method setter, Collection<Element> tags) throws Exception {
        for (Element tag : tags) {
            this.setValueFromTag(object, setter, tag);
        }
    }

    private void setValueFromTag(Object object, Method setter, Element tag) throws Exception {
        this.setValue(object, setter, this.read(tag, this.fieldClass(setter)));
    }

    private void setValue(Object object, Method setter, Object value) throws IllegalAccessException, InvocationTargetException {
        setter.invoke(object, value);
    }

    public static interface Listener {
        public void creatingObject(Class<?> var1);
    }
}

