/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util;

import com.vividsolutions.jump.util.Block;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.locationtech.jts.util.Assert;

public class CollectionUtil {
    public static <T> Collection<T> concatenate(Collection<T> a, Collection<T> b) {
        ArrayList<T> result = new ArrayList<T>();
        result.addAll(a);
        result.addAll(b);
        return result;
    }

    public static <T> List<T> list(T a, T b) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(a);
        list.add(b);
        return list;
    }

    public static List combinations(List original, int maxCombinationSize) {
        return CollectionUtil.combinations(original, maxCombinationSize, null);
    }

    public static <U, V> Map<V, U> inverse(Map<U, V> map) {
        Map inverse;
        try {
            inverse = (Map)map.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            Assert.shouldNeverReachHere((String)e.toString());
            return null;
        }
        for (Map.Entry<U, V> entry : map.entrySet()) {
            inverse.put(entry.getValue(), entry.getKey());
        }
        return inverse;
    }

    public static <T> List<List<T>> combinations(List<T> original, int maxCombinationSize, T mandatoryItem) {
        ArrayList<List<T>> combinations = new ArrayList<List<T>>();
        for (int i = 1; i <= (int)Math.pow(2.0, original.size()) - 1; ++i) {
            ArrayList<T> combination = new ArrayList<T>();
            for (int j = 0; j < original.size(); ++j) {
                if ((i & (int)Math.pow(2.0, j)) <= 0) continue;
                combination.add(original.get(j));
            }
            if (combination.size() > maxCombinationSize || mandatoryItem != null && !combination.contains(mandatoryItem)) continue;
            combinations.add(combination);
        }
        return combinations;
    }

    public static <T> List<List<T>> combinations(List<T> original) {
        return CollectionUtil.combinations(original, original.size(), null);
    }

    public static <U, V> void removeKeys(Collection<U> keys, Map<U, V> map) {
        for (U key : keys) {
            map.remove(key);
        }
    }

    public static List[] keysAndCorrespondingValues(Map map) {
        ArrayList keys = new ArrayList(map.keySet());
        ArrayList values = new ArrayList();
        for (Object key : keys) {
            values.add(map.get(key));
        }
        return new List[]{keys, values};
    }

    public static <T> Collection<T> concatenate(Collection<? extends Collection<T>> collections) {
        ArrayList<T> concatenation = new ArrayList<T>();
        for (Collection<T> collection : collections) {
            concatenation.addAll(collection);
        }
        return concatenation;
    }

    public static Object randomElement(List list) {
        return list.get((int)Math.floor(Math.random() * (double)list.size()));
    }

    public static SortedSet<Integer> reverseSortedSet(int[] ints) {
        TreeSet<Integer> sortedSet = new TreeSet<Integer>(Collections.reverseOrder());
        for (int i : ints) {
            sortedSet.add(i);
        }
        return sortedSet;
    }

    public static List reverse(List list) {
        Collections.reverse(list);
        return list;
    }

    public static <T> Collection stretch(Collection<T> source, Collection<T> destination, int destinationSize) {
        Assert.isTrue((boolean)destination.isEmpty());
        List<Object> originalList = source instanceof List ? (List<Object>)source : new ArrayList<T>(source);
        for (int i = 0; i < destinationSize; ++i) {
            destination.add(originalList.get((int)Math.round((double)(i * originalList.size()) / (double)destinationSize)));
        }
        return destination;
    }

    public static Object ifNotIn(Object o, Collection c, Object alternative) {
        return c.contains(o) ? o : alternative;
    }

    public static void setIfNull(int i, List<String> list, String value) {
        if (i >= list.size()) {
            CollectionUtil.resize(list, i + 1);
        }
        if (list.get(i) != null) {
            return;
        }
        list.set(i, value);
    }

    public static void resize(List list, int newSize) {
        if (newSize < list.size()) {
            list.subList(newSize, list.size()).clear();
        } else {
            list.addAll(Collections.nCopies(newSize - list.size(), null));
        }
    }

    public static boolean containsReference(Object[] objects, Object o) {
        return CollectionUtil.indexOf(o, objects) > -1;
    }

    public static int indexOf(Object o, Object[] objects) {
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] != o) continue;
            return i;
        }
        return -1;
    }

    public static <T> Collection<T> removeDuplicates(Collection<T> original) {
        ArrayList<T> result = new ArrayList<T>();
        for (T item : original) {
            if (result.contains(item)) continue;
            result.add(item);
        }
        return result;
    }

    public static void addIfNotNull(Object item, Collection collection) {
        if (item != null) {
            collection.add(item);
        }
    }

    public static Collection filterByClass(Collection collection, Class c) {
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            Object item = i.next();
            if (c.isInstance(item)) continue;
            i.remove();
        }
        return collection;
    }

    public static Map createMap(Object[] alternatingKeysAndValues) {
        return CollectionUtil.createMap(HashMap.class, alternatingKeysAndValues);
    }

    public static Map<Object, Object> createMap(Class mapClass, Object[] alternatingKeysAndValues) {
        Map map = null;
        try {
            map = (Map)mapClass.newInstance();
            for (int i = 0; i < alternatingKeysAndValues.length; i += 2) {
                map.put(alternatingKeysAndValues[i], alternatingKeysAndValues[i + 1]);
            }
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere((String)e.toString());
        }
        return map;
    }

    public static <T, R> Collection<R> collect(Collection<T> collection, Block block) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (T object : collection) {
            result.add(block.yield(object));
        }
        return result;
    }

    public static <T> Collection<T> select(Collection<T> collection, Block block) {
        ArrayList<T> result = new ArrayList<T>();
        for (T item : collection) {
            if (!Boolean.TRUE.equals(block.yield(item))) continue;
            result.add(item);
        }
        return result;
    }

    public static Object get(Class<?> c, Map<Class<?>, ? extends Object> map) {
        if (map.containsKey(c)) {
            return map.get(c);
        }
        for (Class<?> clazz : map.keySet()) {
            if (!clazz.isAssignableFrom(c)) continue;
            return map.get(clazz);
        }
        return null;
    }
}

