/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.plugin.edit;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.FeatureCollection;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;

public class AffineTransControlPointExtracter {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_VECTOR = 1;
    public static final int TYPE_LINE_3 = 2;
    private FeatureCollection fcSrc;
    private FeatureCollection fcDest;
    private int inputType = 0;
    private String parseErrMsg = I18N.getInstance().get("jump.plugin.edit.AffineTransControlPointExtracter.Unrecognized-control-point-geometry");
    private Geometry[] geomSrc = new Geometry[3];
    private Geometry[] geomDest = new Geometry[3];
    private Coordinate[] controlPtSrc;
    private Coordinate[] controlPtDest;

    public AffineTransControlPointExtracter(FeatureCollection fcSrc, FeatureCollection fcDest) {
        this.fcSrc = fcSrc;
        this.fcDest = fcDest;
        this.init();
    }

    int getInputType() {
        return this.inputType;
    }

    String getParseErrorMessage() {
        return this.parseErrMsg;
    }

    Coordinate[] getSrcControlPoints() {
        return this.controlPtSrc;
    }

    Coordinate[] getDestControlPoints() {
        return this.controlPtDest;
    }

    private void init() {
        this.parseInput();
    }

    private void parseInput() {
        int fcDestSize;
        this.inputType = 0;
        int fcSrcSize = this.fcSrc.size();
        if (fcSrcSize != (fcDestSize = this.fcDest.size())) {
            this.parseErrMsg = I18N.getInstance().get("jump.plugin.edit.AffineTransControlPointExtracter.Control-point-collections-must-be-same-size");
            return;
        }
        if (fcSrcSize != 1) {
            this.parseErrMsg = I18N.getInstance().get("jump.plugin.edit.AffineTransControlPointExtracter.Control-points-must-be-a-single-geometry");
            return;
        }
        this.geomSrc[0] = this.fcSrc.iterator().next().getGeometry();
        this.geomDest[0] = this.fcDest.iterator().next().getGeometry();
        if (this.geomSrc[0].getClass() != this.geomDest[0].getClass()) {
            this.parseErrMsg = I18N.getInstance().get("jump.plugin.edit.AffineTransControlPointExtracter.Control-points-must-be-LineStrings");
            return;
        }
        if (!(this.geomSrc[0] instanceof LineString)) {
            this.parseErrMsg = I18N.getInstance().get("jump.plugin.edit.AffineTransControlPointExtracter.Control-points-must-be-LineStrings");
            return;
        }
        this.parseLines();
    }

    private void parseLines() {
        this.controlPtSrc = this.geomSrc[0].getCoordinates();
        this.controlPtDest = this.geomDest[0].getCoordinates();
        if (this.controlPtSrc.length != this.controlPtDest.length) {
            this.parseErrMsg = I18N.getInstance().get("jump.plugin.edit.AffineTransControlPointExtracter.Control-Point-LineStrings-are-different-lengths");
            return;
        }
        if (this.controlPtSrc.length < 2) {
            this.parseErrMsg = I18N.getInstance().get("jump.plugin.edit.AffineTransControlPointExtracter.Single-control-points-are-not-supported");
        }
        if (this.controlPtSrc.length > 3) {
            this.parseErrMsg = I18N.getInstance().get("jump.plugin.edit.AffineTransControlPointExtracter.Too-many-points-in-LineString");
        }
        this.inputType = 1;
    }
}

