/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.io.datasource;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.CompressedFile;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.JUMPReader;
import com.vividsolutions.jump.io.JUMPWriter;
import com.vividsolutions.jump.io.datasource.Connection;
import com.vividsolutions.jump.io.datasource.FileDataSource;
import com.vividsolutions.jump.task.TaskCancelledException;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.task.TaskMonitorSupport;
import com.vividsolutions.jump.task.TaskMonitorV2Util;
import com.vividsolutions.jump.util.Timer;
import com.vividsolutions.jump.workbench.Logger;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.openjump.util.UriUtil;

public class ReaderWriterFileDataSource
extends FileDataSource {
    protected JUMPReader reader = null;
    protected JUMPWriter writer = null;
    protected String[] extensions = new String[0];

    @Deprecated
    public ReaderWriterFileDataSource(JUMPReader reader, JUMPWriter writer) {
        this(reader, writer, new String[0]);
    }

    public ReaderWriterFileDataSource(JUMPReader reader, JUMPWriter writer, String[] extensions) {
        this.reader = reader;
        this.writer = writer;
        this.extensions = extensions;
    }

    @Override
    public Connection getConnection() {
        return new Connection(){

            @Override
            public FeatureCollection executeQuery(String query, Collection<Throwable> exceptions, TaskMonitor monitor) {
                if (ReaderWriterFileDataSource.this.isDisabled()) {
                    return null;
                }
                if (!ReaderWriterFileDataSource.this.isReadable()) {
                    throw new UnsupportedOperationException("reading is not supported");
                }
                try {
                    DriverProperties dp = ReaderWriterFileDataSource.this.getReaderDriverProperties();
                    ReaderWriterFileDataSource.this.fixUpDriverProperties(dp);
                    URI uri = new URI(dp.getProperty("Uri"));
                    if (ReaderWriterFileDataSource.this.reader instanceof TaskMonitorSupport) {
                        ((TaskMonitorSupport)((Object)ReaderWriterFileDataSource.this.reader)).setTaskMonitor(monitor);
                        TaskMonitorV2Util.setTitle(monitor, I18N.getInstance().get("com.vividsolutions.jump.io.datasource.ReaderWriterFileDataSource.open", ReaderWriterFileDataSource.createDescriptiveName(uri)));
                    }
                    long start = Timer.milliSecondsSince(0L);
                    FeatureCollection fc = ReaderWriterFileDataSource.this.reader.read(dp);
                    String filename = UriUtil.getFileName(uri);
                    Logger.info("Reading '" + filename + "' took " + Timer.secondsSinceString(start) + "s.");
                    exceptions.addAll(ReaderWriterFileDataSource.this.reader.getExceptions());
                    return fc;
                }
                catch (TaskCancelledException e) {
                    return null;
                }
                catch (Exception e) {
                    exceptions.add(e);
                    return null;
                }
            }

            @Override
            public void executeUpdate(String update, FeatureCollection featureCollection, TaskMonitor monitor) throws Exception {
                if (ReaderWriterFileDataSource.this.isDisabled()) {
                    return;
                }
                if (!ReaderWriterFileDataSource.this.isWritable()) {
                    throw new UnsupportedOperationException("writing is not supported");
                }
                DriverProperties dp = ReaderWriterFileDataSource.this.getWriterDriverProperties();
                ReaderWriterFileDataSource.this.fixUpDriverProperties(dp);
                URI uri = new URI(dp.getProperty("Uri"));
                if (ReaderWriterFileDataSource.this.writer instanceof TaskMonitorSupport) {
                    ((TaskMonitorSupport)((Object)ReaderWriterFileDataSource.this.writer)).setTaskMonitor(monitor);
                    TaskMonitorV2Util.setTitle(monitor, I18N.getInstance().get("com.vividsolutions.jump.io.datasource.ReaderWriterFileDataSource.write", ReaderWriterFileDataSource.createDescriptiveName(uri)));
                }
                long start = Timer.milliSecondsSince(0L);
                ReaderWriterFileDataSource.this.writer.write(featureCollection, dp);
                Logger.info("Writing '" + UriUtil.getFileName(uri) + "' took " + Timer.secondsSinceString(start) + "s.");
            }

            @Override
            public void close() {
            }

            @Override
            public FeatureCollection executeQuery(String query, TaskMonitor monitor) throws Exception {
                ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
                FeatureCollection featureCollection = this.executeQuery(query, exceptions, monitor);
                if (!exceptions.isEmpty()) {
                    throw (Exception)exceptions.iterator().next();
                }
                return featureCollection;
            }
        };
    }

    protected static String createDescriptiveName(URI uri) {
        if (CompressedFile.isArchive(uri)) {
            return UriUtil.getZipEntryName(uri) + " (" + UriUtil.getZipFileName(uri) + ")";
        }
        return UriUtil.getFileName(uri);
    }

    protected DriverProperties getReaderDriverProperties() {
        return this.getDriverProperties();
    }

    protected DriverProperties getWriterDriverProperties() {
        return this.getDriverProperties();
    }

    protected DriverProperties getDriverProperties() {
        DriverProperties properties = new DriverProperties();
        Map<String, Object> map = this.getProperties();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            properties.setProperty(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return properties;
    }

    private DriverProperties fixUpDriverProperties(DriverProperties dp) throws Exception {
        String uri = dp.getProperty("Uri");
        String file = dp.getProperty("File");
        if (file == null && uri != null) {
            dp.setProperty("File", new URI(uri).getPath());
        } else if (file != null && uri == null) {
            dp.setProperty("Uri", new File(file).toURI().toString());
        }
        return dp;
    }

    @Override
    public boolean isReadable() {
        return this.reader instanceof JUMPReader;
    }

    @Override
    public boolean isWritable() {
        return this.writer instanceof JUMPWriter;
    }

    @Override
    public String[] getExtensions() {
        return this.extensions;
    }
}

