/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.io;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.coordsys.EsriProj;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.EndianDataOutputStream;
import com.vividsolutions.jump.io.IllegalParametersException;
import com.vividsolutions.jump.io.JUMPWriter;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.ui.OKCancelDialog;
import java.awt.Component;
import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JLabel;
import org.geotools.dbffile.DbfFieldDef;
import org.geotools.dbffile.DbfFile;
import org.geotools.dbffile.DbfFileWriter;
import org.geotools.shapefile.Shapefile;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.openjump.core.ccordsys.utils.SridLookupTable;

public class ShapefileWriter
implements JUMPWriter {
    private static final String SHAPE_TYPE_PROPERTY_KEY = "ShapeType";
    private static boolean truncate = false;
    private static long lastTimeTruncate = new Date(0L).getTime();
    private static final Map<Integer, String> PRJ_MAP = new HashMap<Integer, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(FeatureCollection featureCollection, DriverProperties dp) throws Exception {
        this.checkIfGeomsAreMixed(featureCollection);
        String shpfileName = dp.getProperty("File");
        if (shpfileName == null) {
            shpfileName = dp.getProperty(DriverProperties.DEFAULT_VALUE_KEY);
        }
        if (shpfileName == null) {
            throw new IllegalParametersException(I18N.getInstance().get("io.ShapefileWriter.no-output-filename-specified"));
        }
        int loc = (shpfileName = new File(shpfileName).getPath()).lastIndexOf(File.separatorChar);
        if (loc == -1) {
            throw new Exception(I18N.getInstance().get("io.ShapefileWriter.path-separator-not-found", Character.valueOf(File.separatorChar)));
        }
        String path = shpfileName.substring(0, loc + 1);
        String fname = shpfileName.substring(loc + 1);
        if ((loc = fname.lastIndexOf(".")) == -1) {
            throw new IllegalParametersException(I18N.getInstance().get("io.ShapefileWriter.filename-must-end-in-shp"));
        }
        String fname_withoutextention = fname.substring(0, loc);
        String dbffname = path + fname_withoutextention + ".dbf";
        String charsetName = dp.getProperty("charset");
        if (charsetName == null) {
            charsetName = Charset.defaultCharset().name();
        }
        this.writeDbf(featureCollection, dbffname, Charset.forName(charsetName));
        try (PrintWriter pw = null;){
            String cpgfname = path + fname_withoutextention + ".cpg";
            pw = new PrintWriter(new FileOutputStream(cpgfname));
            pw.write(this.java_cp_2_esri(charsetName));
        }
        String code = dp.getProperty("SrsCode", "0");
        String prjString = this.getPrjString(code);
        if (prjString != null) {
            try {
                String prjfname = path + fname_withoutextention + ".prj";
                pw = new PrintWriter(new FileOutputStream(prjfname));
                pw.write(prjString);
            }
            finally {
                pw.close();
            }
        }
        GeometryCollection gc = this.makeSHAPEGeometryCollection(featureCollection);
        int shapeType = 2;
        if (dp.getProperty(SHAPE_TYPE_PROPERTY_KEY) != null) {
            String st = dp.getProperty(SHAPE_TYPE_PROPERTY_KEY);
            if (st.equalsIgnoreCase("xy")) {
                shapeType = 2;
            } else if (st.equalsIgnoreCase("xym")) {
                shapeType = 3;
            } else if (st.equalsIgnoreCase("xymz")) {
                shapeType = 4;
            } else if (st.equalsIgnoreCase("xyzm")) {
                shapeType = 4;
            } else {
                if (!st.equalsIgnoreCase("xyz")) throw new IllegalParametersException(I18N.getInstance().get("io.ShapefileWriter.unknown-type"));
                shapeType = 4;
            }
        } else if (gc.getNumGeometries() > 0) {
            shapeType = this.guessCoordinateDims(gc.getGeometryN(0));
        }
        URL url = new URL("file", "localhost", shpfileName);
        Shapefile myshape = new Shapefile(url);
        myshape.write(gc, shapeType);
        String shxfname = path + fname_withoutextention + ".shx";
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(shxfname));
             EndianDataOutputStream sfile = new EndianDataOutputStream(outputStream);){
            myshape.writeIndex(gc, sfile, shapeType);
        }
        this.deleteIndex(path, fname_withoutextention, "sbn");
        this.deleteIndex(path, fname_withoutextention, "sbx");
        this.deleteIndex(path, fname_withoutextention, "qix");
        if (!truncate) return;
        lastTimeTruncate = new Date().getTime();
    }

    private int guessCoordinateDims(Geometry g) {
        Coordinate[] cs;
        for (Coordinate coord : cs = g.getCoordinates()) {
            if (Double.isNaN(coord.z)) continue;
            return 4;
        }
        return 2;
    }

    void writeDbf(FeatureCollection featureCollection, String fname) throws Exception {
        this.writeDbf(featureCollection, fname, Charset.defaultCharset());
    }

    private void writeDbf(FeatureCollection featureCollection, String fname, Charset charset) throws Exception {
        int t;
        HashMap<String, DbfFieldDef> fieldMap = null;
        if (new File(fname).exists() && new File(fname).length() > 0L) {
            try (DbfFile dbfFile = new DbfFile(fname, charset);){
                int numFields = dbfFile.getNumFields();
                fieldMap = new HashMap<String, DbfFieldDef>(numFields);
                for (int i = 0; i < numFields; ++i) {
                    String fieldName = dbfFile.getFieldName(i);
                    fieldMap.put(fieldName, dbfFile.fielddef[i]);
                }
            }
        }
        FeatureSchema fs = featureCollection.getFeatureSchema();
        DbfFieldDef[] fields = new DbfFieldDef[fs.getAttributeCount() - 1];
        int f = 0;
        HashSet<String> uniqueNames = new HashSet<String>();
        for (t = 0; t < fs.getAttributeCount(); ++t) {
            OKCancelDialog okCancelDialog;
            DbfFieldDef fromFile;
            AttributeType columnType = fs.getAttributeType(t);
            String columnName = fs.getAttributeName(t);
            columnName = this.uniqueName(uniqueNames, columnName, 10);
            if (columnType == AttributeType.INTEGER || columnType == AttributeType.SMALLINT || columnType == AttributeType.TINYINT) {
                int maxlength = this.findMaxStringLength(featureCollection, t, charset);
                fields[f] = maxlength <= 3 ? new DbfFieldDef(columnName, 'N', 3, 0) : (maxlength <= 6 ? new DbfFieldDef(columnName, 'N', 6, 0) : (maxlength <= 9 ? new DbfFieldDef(columnName, 'N', 9, 0) : new DbfFieldDef(columnName, 'N', maxlength, 0)));
                fromFile = this.overrideWithExistingCompatibleDbfFieldDef(fields[f], fieldMap);
                if (fromFile.fieldnumdec == 0) {
                    fields[f] = fromFile;
                }
                ++f;
                continue;
            }
            if (columnType == AttributeType.LONG || columnType == AttributeType.BIGINT) {
                int maxlength = this.findMaxStringLength(featureCollection, t, charset);
                fields[f] = maxlength <= 12 ? new DbfFieldDef(columnName, 'N', 12, 0) : (maxlength <= 15 ? new DbfFieldDef(columnName, 'N', 15, 0) : (maxlength <= 18 ? new DbfFieldDef(columnName, 'N', 18, 0) : new DbfFieldDef(columnName, 'N', maxlength, 0)));
                fromFile = this.overrideWithExistingCompatibleDbfFieldDef(fields[f], fieldMap);
                if (fromFile.fieldnumdec == 0) {
                    fields[f] = fromFile;
                }
                ++f;
                continue;
            }
            if (columnType == AttributeType.DOUBLE || columnType == AttributeType.REAL || columnType == AttributeType.FLOAT || columnType == AttributeType.NUMERIC || columnType == AttributeType.DECIMAL || columnType == AttributeType.BIGDECIMAL) {
                fields[f] = new DbfFieldDef(columnName, 'N', 33, 16);
                DbfFieldDef fromFile2 = this.overrideWithExistingCompatibleDbfFieldDef(fields[f], fieldMap);
                if (fromFile2.fieldnumdec > 0) {
                    fields[f] = fromFile2;
                }
                ++f;
                continue;
            }
            if (columnType == AttributeType.STRING || columnType == AttributeType.OBJECT || columnType == AttributeType.VARCHAR || columnType == AttributeType.LONGVARCHAR || columnType == AttributeType.CHAR || columnType == AttributeType.TEXT) {
                int maxlength = this.findMaxStringLength(featureCollection, t, charset);
                if (maxlength > 255) {
                    if (new Date().getTime() - lastTimeTruncate < 30000L) {
                        maxlength = 255;
                    } else {
                        okCancelDialog = this.getLongFieldManagementDialogBox();
                        okCancelDialog.setLocationRelativeTo(null);
                        okCancelDialog.setVisible(true);
                        if (okCancelDialog.wasOKPressed()) {
                            maxlength = 255;
                            truncate = true;
                        } else {
                            truncate = false;
                            throw new Exception(I18N.getInstance().get("io.ShapefileWriter.export-cancelled") + " " + I18N.getInstance().get("io.ShapefileWriter.more-than-255-characters-field-found"));
                        }
                    }
                }
                fields[f] = new DbfFieldDef(columnName, 'C', maxlength, 0);
                ++f;
                continue;
            }
            if (columnType == AttributeType.DATE || columnType == AttributeType.TIMESTAMP || columnType == AttributeType.TIME) {
                fields[f] = new DbfFieldDef(columnName, 'D', 8, 0);
                ++f;
                continue;
            }
            if (columnType == AttributeType.BOOLEAN || columnType == AttributeType.BIT) {
                fields[f] = new DbfFieldDef(columnName, 'L', 1, 0);
                ++f;
                continue;
            }
            if (columnType == AttributeType.GEOMETRY) continue;
            if (columnType == null) {
                if (columnName.isEmpty()) continue;
                int maxlength = this.findMaxStringLength(featureCollection, t, charset);
                if (maxlength > 255) {
                    if (new Date().getTime() - lastTimeTruncate < 30000L) {
                        maxlength = 255;
                    } else {
                        okCancelDialog = this.getLongFieldManagementDialogBox();
                        okCancelDialog.setLocationRelativeTo(null);
                        okCancelDialog.setVisible(true);
                        if (okCancelDialog.wasOKPressed()) {
                            maxlength = 255;
                            truncate = true;
                        } else {
                            truncate = false;
                            throw new Exception(I18N.getInstance().get("io.ShapefileWriter.export-cancelled") + " " + I18N.getInstance().get("io.ShapefileWriter.more-than-255-characters-field-found"));
                        }
                    }
                }
                fields[f] = new DbfFieldDef(columnName, 'C', maxlength, 0);
                ++f;
                continue;
            }
            throw new Exception(I18N.getInstance().get("io.ShapefileWriter.unsupported-attribute-type") + " : " + columnType.toString());
        }
        DbfFileWriter dbf = new DbfFileWriter(fname);
        dbf.setCharset(charset);
        dbf.writeHeader(fields, featureCollection.size());
        for (Feature feature : featureCollection.getFeatures()) {
            Vector<Object> dbfRow = new Vector<Object>();
            for (t = 0; t < fs.getAttributeCount(); ++t) {
                AttributeType columnType = fs.getAttributeType(t);
                Object a = feature.getAttribute(t);
                if (a == null) {
                    dbfRow.add(null);
                    continue;
                }
                if (columnType == null) {
                    dbfRow.add(a);
                    continue;
                }
                if (columnType == AttributeType.DATE || columnType == AttributeType.TIME || columnType == AttributeType.TIMESTAMP) {
                    dbfRow.add(DbfFile.DATE_PARSER.format((Date)a));
                    continue;
                }
                if (columnType == AttributeType.OBJECT) {
                    dbfRow.add(a.toString());
                    continue;
                }
                if (columnType == AttributeType.GEOMETRY) continue;
                dbfRow.add(a);
            }
            dbf.writeRecord(dbfRow);
        }
        dbf.close();
    }

    protected String getPrjString(String code) throws Exception {
        try {
            int srid = Integer.parseInt(code);
            String prj = EsriProj.findProj(srid);
            if (prj == null) {
                prj = SridLookupTable.getOGCWKTFromWkidCode("" + srid);
            }
            return prj;
        }
        catch (IOException e) {
            Logger.warn(e);
            return null;
        }
    }

    private String removeCount(String s, int count) {
        return s.substring(0, s.length() - Integer.toString(count).length());
    }

    private String uniqueName(Set<String> set, String name, int maxLength) {
        name = name.substring(0, Math.min(maxLength, name.length()));
        int count = 1;
        while (set.contains(name)) {
            if (name.length() == maxLength) {
                name = this.removeCount(name, count);
            } else if (count > 1) {
                name = this.removeCount(name, count - 1);
            }
            name = name + count;
            ++count;
        }
        set.add(name);
        return name;
    }

    private DbfFieldDef overrideWithExistingCompatibleDbfFieldDef(DbfFieldDef field, Map columnMap) {
        String fieldname = field.fieldname.toString().trim();
        if (columnMap != null && columnMap.containsKey(fieldname)) {
            DbfFieldDef dbfFieldDef = (DbfFieldDef)columnMap.get(fieldname);
            dbfFieldDef.fieldname = field.fieldname;
            switch (dbfFieldDef.fieldtype) {
                case 'C': 
                case 'c': {
                    if (field.fieldtype != 'C') break;
                    if (field.fieldlen > dbfFieldDef.fieldlen) {
                        return field;
                    }
                    dbfFieldDef.fieldtype = field.fieldtype;
                    return dbfFieldDef;
                }
                case 'F': 
                case 'N': 
                case 'f': 
                case 'n': {
                    if (field.fieldtype != 'N') break;
                    dbfFieldDef.fieldtype = field.fieldtype;
                    return dbfFieldDef;
                }
            }
        }
        return field;
    }

    private int findMaxStringLength(FeatureCollection fc, int attributeIndex, Charset charset) {
        int maxlen = 1;
        for (Feature feature : fc.getFeatures()) {
            int length;
            if (feature.getAttribute(attributeIndex) == null || (length = feature.getString(attributeIndex).getBytes(charset).length) <= maxlen) continue;
            maxlen = length;
        }
        return maxlen;
    }

    private int findBestGeometryType(FeatureCollection fc) {
        boolean onlyPoints = true;
        boolean onlyEmptyGeometryCollection = true;
        for (Feature feature : fc.getFeatures()) {
            Geometry geom = feature.getGeometry();
            if (geom.isEmpty()) continue;
            if (onlyPoints && !(geom instanceof Point)) {
                onlyPoints = false;
            }
            if (onlyEmptyGeometryCollection && !geom.isEmpty()) {
                onlyEmptyGeometryCollection = false;
            }
            if (geom instanceof MultiPoint) {
                return 8;
            }
            if (geom instanceof Polygon) {
                return 5;
            }
            if (geom instanceof MultiPolygon) {
                return 5;
            }
            if (geom instanceof LineString) {
                return 3;
            }
            if (!(geom instanceof MultiLineString)) continue;
            return 3;
        }
        if (onlyPoints) {
            return 1;
        }
        if (onlyEmptyGeometryCollection) {
            return 0;
        }
        return 31;
    }

    private void checkIfGeomsAreMixed(FeatureCollection featureCollection) throws Exception {
        int i = 0;
        Class<?> firstClass = null;
        Geometry firstGeom = null;
        for (Feature feature : featureCollection.getFeatures()) {
            Geometry geom = feature.getGeometry();
            if (geom.isEmpty()) continue;
            if (i == 0) {
                firstClass = geom.getClass();
                firstGeom = geom;
            } else if (!(firstClass == geom.getClass() || firstGeom instanceof Polygon && geom instanceof MultiPolygon || firstGeom instanceof MultiPolygon && geom instanceof Polygon || firstGeom instanceof Point && geom instanceof MultiPoint || firstGeom instanceof MultiPoint && geom instanceof Point || firstGeom instanceof LineString && geom instanceof MultiLineString || firstGeom instanceof MultiLineString && geom instanceof LineString)) {
                throw new IllegalParametersException(I18N.getInstance().get("io.ShapefileWriter.unsupported-mixed-geometry-type"));
            }
            ++i;
        }
    }

    private LinearRing reverseRing(LinearRing lr) {
        int numPoints = lr.getNumPoints();
        Coordinate[] newCoords = new Coordinate[numPoints];
        for (int t = 0; t < numPoints; ++t) {
            newCoords[t] = lr.getCoordinateN(numPoints - t - 1);
        }
        return lr.getFactory().createLinearRing(newCoords);
    }

    private Polygon makeGoodSHAPEPolygon(Polygon p) {
        if (p.isEmpty()) {
            return p;
        }
        LinearRing[] holes = new LinearRing[p.getNumInteriorRing()];
        Coordinate[] coords = p.getExteriorRing().getCoordinates();
        LinearRing outer = Orientation.isCCW((Coordinate[])coords) ? this.reverseRing(p.getExteriorRing()) : p.getExteriorRing();
        for (int t = 0; t < p.getNumInteriorRing(); ++t) {
            coords = p.getInteriorRingN(t).getCoordinates();
            holes[t] = !Orientation.isCCW((Coordinate[])coords) ? this.reverseRing(p.getInteriorRingN(t)) : p.getInteriorRingN(t);
        }
        return p.getFactory().createPolygon(outer, holes);
    }

    private MultiPolygon makeGoodSHAPEMultiPolygon(MultiPolygon mp) {
        Polygon[] ps = new Polygon[mp.getNumGeometries()];
        for (int t = 0; t < mp.getNumGeometries(); ++t) {
            ps[t] = this.makeGoodSHAPEPolygon((Polygon)mp.getGeometryN(t));
        }
        MultiPolygon result = mp.getFactory().createMultiPolygon(ps);
        return result;
    }

    private GeometryCollection makeSHAPEGeometryCollection(FeatureCollection fc) throws Exception {
        Geometry[] allGeoms = new Geometry[fc.size()];
        GeometryFactory gf = new GeometryFactory();
        int geomtype = this.findBestGeometryType(fc);
        if (geomtype == 31) {
            throw new Exception(I18N.getInstance().get("io.ShapefileWriter.unsupported-geometry-collection"));
        }
        List<Feature> features = fc.getFeatures();
        block7: for (int t = 0; t < features.size(); ++t) {
            Geometry geom = features.get(t).getGeometry();
            gf = geom.getFactory();
            switch (geomtype) {
                case 0: {
                    allGeoms[t] = gf.createGeometryCollection(new Geometry[0]);
                    continue block7;
                }
                case 1: {
                    if (geom instanceof Point) {
                        allGeoms[t] = geom;
                        continue block7;
                    }
                    allGeoms[t] = gf.createPoint((Coordinate)null);
                    continue block7;
                }
                case 8: {
                    Point[] p;
                    if (geom instanceof Point) {
                        p = new Point[]{(Point)geom};
                        allGeoms[t] = gf.createMultiPoint(p);
                        continue block7;
                    }
                    if (geom instanceof MultiPoint) {
                        allGeoms[t] = geom;
                        continue block7;
                    }
                    allGeoms[t] = gf.createMultiPoint(new Point[0]);
                    continue block7;
                }
                case 3: {
                    if (geom instanceof LineString) {
                        LineString[] l = new LineString[]{(LineString)geom};
                        allGeoms[t] = gf.createMultiLineString(l);
                        continue block7;
                    }
                    if (geom instanceof MultiLineString) {
                        allGeoms[t] = geom;
                        continue block7;
                    }
                    allGeoms[t] = gf.createMultiLineString(new LineString[0]);
                    continue block7;
                }
                case 5: {
                    Point[] p;
                    if (geom instanceof Polygon) {
                        p = new Polygon[]{(Polygon)geom};
                        allGeoms[t] = this.makeGoodSHAPEMultiPolygon(gf.createMultiPolygon((Polygon[])p));
                        continue block7;
                    }
                    allGeoms[t] = geom instanceof MultiPolygon ? this.makeGoodSHAPEMultiPolygon((MultiPolygon)geom) : gf.createMultiPolygon(new Polygon[0]);
                }
            }
        }
        GeometryCollection result = gf.createGeometryCollection(allGeoms);
        return result;
    }

    private boolean deleteIndex(String path, String nameWithoutExtension, String extension) {
        File file = new File(path + nameWithoutExtension + "." + extension.toLowerCase());
        if (file.exists()) {
            return file.delete();
        }
        file = new File(path + nameWithoutExtension + "." + extension.toUpperCase());
        return file.exists() && file.delete();
    }

    private OKCancelDialog getLongFieldManagementDialogBox() {
        return new OKCancelDialog((Frame)null, I18N.getInstance().get("io.ShapefileWriter.fields-too-long"), true, (Component)new JLabel("<html><br/>" + I18N.getInstance().get("io.ShapefileWriter.more-than-255-characters-field-found") + "<br/><br/>" + I18N.getInstance().get("io.ShapefileWriter.truncate-option") + "<br/></html>"), null);
    }

    private String java_cp_2_esri(String java_cp) {
        if (java_cp.startsWith("IBM")) {
            return "OEM " + java_cp.substring(3);
        }
        if (java_cp.startsWith("ISO-8859-6")) {
            return "OEM 708";
        }
        if (java_cp.startsWith("ISO-8859-")) {
            return "ISO 8859" + java_cp.substring(9);
        }
        if (java_cp.startsWith("windows-")) {
            return "OEM " + java_cp.substring(8);
        }
        if (java_cp.equalsIgnoreCase("x-windows-")) {
            return "OEM " + java_cp.substring(10);
        }
        if (java_cp.equalsIgnoreCase("UTF-8")) {
            return "UTF-8";
        }
        if (java_cp.equalsIgnoreCase("Shift_JIS")) {
            return "SJIS";
        }
        if (java_cp.equalsIgnoreCase("Big5")) {
            return "Big5";
        }
        if (java_cp.equalsIgnoreCase("GBK")) {
            return "OEM 936";
        }
        return java_cp;
    }
}

