/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.io;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.GMLOutputTemplate;
import com.vividsolutions.jump.io.GMLWriter;
import com.vividsolutions.jump.io.IllegalParametersException;
import com.vividsolutions.jump.io.JUMPWriter;
import com.vividsolutions.jump.io.ParseException;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FMEGMLWriter
implements JUMPWriter {
    private int outputFormatType = 1;
    private String FME_FORMAT_VERSION = "FMEFormatVersion";
    private SimpleDateFormat fmeDateFormatter = new SimpleDateFormat("yyyyMMdd");

    @Override
    public void write(FeatureCollection featureCollection, DriverProperties dp) throws Exception {
        String outputfname = dp.getProperty("File");
        if (outputfname == null) {
            outputfname = dp.getProperty(DriverProperties.DEFAULT_VALUE_KEY);
        }
        if (outputfname == null) {
            throw new IllegalParametersException("call to FMEGMLWriter.write() has DataProperties w/o a OutputFile specified");
        }
        if (dp.getProperty(this.FME_FORMAT_VERSION) != null) {
            if (dp.getProperty(this.FME_FORMAT_VERSION).equals("2000")) {
                this.outputFormatType = 0;
            }
            if (dp.getProperty(this.FME_FORMAT_VERSION).equals("2001")) {
                this.outputFormatType = 1;
            }
        }
        GMLOutputTemplate gmlTemplate = this.createOutputTemplate(featureCollection.getFeatureSchema());
        GMLWriter gmlWriter = new GMLWriter(){

            @Override
            protected String format(Date date) {
                return FMEGMLWriter.this.fmeDateFormatter.format(date);
            }
        };
        gmlWriter.setOutputTemplate(gmlTemplate);
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputfname), StandardCharsets.UTF_8));
        gmlWriter.write(featureCollection, w);
        w.close();
    }

    private GMLOutputTemplate createOutputTemplate(FeatureSchema fs) throws Exception {
        String colName;
        int t;
        String templateText = "";
        switch (this.outputFormatType) {
            case 0: {
                templateText = "<?xml version='1.0' encoding='UTF-8'?>\n<dataset xmlns=\"http://www.safe.com/xml/namespaces/fmegml2\" xmlns:fme=\"http://www.safe.com/xml/namespaces/fmegml2\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:xsi=\"http://www.w3.org/2000/10/XMLSchema-instance\" xsi:schemaLocation=\"http://www.safe.com/xml/schemas/fmegml2.xsd\">\n";
                break;
            }
            case 1: {
                templateText = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<dataset xmlns=\"http://www.safe.com/xml/schemas/FMEFeatures\" xmlns:fme=\"http://www.safe.com/xml/schemas/FMEFeatures\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.safe.com/xml/schemas/FMEFeatures FMEFeatures.xsd\">\n";
            }
        }
        templateText = templateText + "<schemaFeatures>\n<gml:featureMember>\n<Feature>\n<featureType>JCSOutput</featureType>\n";
        for (t = 0; t < fs.getAttributeCount(); ++t) {
            AttributeType attributeType = fs.getAttributeType(t);
            if (t == fs.getGeometryIndex()) continue;
            try {
                colName = fs.getAttributeName(t);
                String colType = this.JCSattributeType2FMEtype(attributeType.toString());
                String column = "";
                switch (this.outputFormatType) {
                    case 0: {
                        column = "<property fme:name=\"" + colName + "\">" + colType + "</property>\n";
                        break;
                    }
                    case 1: {
                        column = "<property name=\"" + colName + "\">" + colType + "</property>\n";
                    }
                }
                templateText = templateText + column;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        templateText = templateText + "</Feature>\n</gml:featureMember>\n</schemaFeatures>\n<dataFeatures>\n";
        templateText = templateText + "<% FEATURE %>\n<gml:featureMember>\n<Feature>\n<featureType>JCSOutput</featureType>\n";
        for (t = 0; t < fs.getAttributeCount(); ++t) {
            colName = fs.getAttributeName(t);
            if (t != fs.getGeometryIndex()) {
                switch (this.outputFormatType) {
                    case 0: {
                        templateText = templateText + "<property fme:name=\"" + colName + "\">";
                        break;
                    }
                    case 1: {
                        templateText = templateText + "<property name=\"" + colName + "\">";
                    }
                }
                templateText = templateText + "<%=COLUMN " + colName + "%></property>\n";
                continue;
            }
            switch (this.outputFormatType) {
                case 0: {
                    templateText = templateText + "<property fme:name=\"gml2_coordsys\"></property>\n";
                    break;
                }
                case 1: {
                    templateText = templateText + "<property name=\"gml2_coordsys\"></property>\n";
                }
            }
            templateText = templateText + "<gml:<%=GEOMETRYTYPE%>Property>\n<%=GEOMETRY %>\n</gml:<%=GEOMETRYTYPE%>Property>\n";
        }
        templateText = templateText + "</Feature>\n</gml:featureMember>\n<% ENDFEATURE %>\n</dataFeatures>\n</dataset>\n";
        StringReader stringreader = new StringReader(templateText);
        GMLOutputTemplate result = new GMLOutputTemplate();
        result.load(stringreader, "Auto Generated FME GML input template");
        stringreader.close();
        return result;
    }

    private String JCSattributeType2FMEtype(String jcsType) throws ParseException {
        switch (this.outputFormatType) {
            case 0: {
                if (jcsType.equalsIgnoreCase("STRING")) {
                    return "fme_char(1024)";
                }
                if (jcsType.equalsIgnoreCase("INTEGER")) {
                    return "long";
                }
                if (jcsType.equalsIgnoreCase("LONG")) {
                    return "long";
                }
                if (jcsType.equalsIgnoreCase("DOUBLE")) {
                    return "fme_decimal(15,15)";
                }
                if (jcsType.equalsIgnoreCase("BOOLEAN")) {
                    return "fme_boolean";
                }
                if (jcsType.equalsIgnoreCase("DATE")) {
                    return "string";
                }
                throw new ParseException("couldn't convert JCS type '" + jcsType + "' to a FME type.");
            }
            case 1: {
                if (jcsType.equalsIgnoreCase("STRING")) {
                    return "string";
                }
                if (jcsType.equalsIgnoreCase("INTEGER")) {
                    return "long";
                }
                if (jcsType.equalsIgnoreCase("DOUBLE")) {
                    return "long";
                }
                if (jcsType.equalsIgnoreCase("DATE")) {
                    return "string";
                }
                throw new ParseException("couldn't convert JCS type '" + jcsType + "' to a FME type.");
            }
        }
        throw new ParseException("couldn't convert JCS type '" + jcsType + "' to a FME type.");
    }
}

