/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.io;

import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.Logger;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.openjump.util.UriUtil;

public class CompressedFile {
    public static String getInternalZipFnameByExtension(String extension, String compressedFile) throws Exception {
        FileInputStream IS_low = new FileInputStream(compressedFile);
        ZipInputStream fr_high = new ZipInputStream(IS_low);
        ZipEntry entry = fr_high.getNextEntry();
        while (entry != null) {
            String inside_zip_extension = entry.getName().substring(entry.getName().length() - extension.length());
            if (inside_zip_extension.compareToIgnoreCase(extension) == 0) {
                return entry.getName();
            }
            entry = fr_high.getNextEntry();
        }
        return null;
    }

    public static List<URI> listEntries(File file) throws Exception {
        ArrayList<URI> entries = new ArrayList<URI>();
        if (CompressedFile.isTar(file.getName())) {
            TarArchiveEntry entry;
            InputStream is = CompressedFile.openFile(file.getAbsolutePath(), null);
            TarArchiveInputStream tis = new TarArchiveInputStream(is);
            while ((entry = tis.getNextTarEntry()) != null) {
                if (entry.isDirectory()) continue;
                URI entryUri = UriUtil.createZipUri(file, entry.getName());
                entries.add(entryUri);
            }
            FileUtil.close((Closeable)tis);
        } else if (CompressedFile.isSevenZ(file.getName())) {
            SevenZArchiveEntry entry;
            SevenZFile sevenZFile = new SevenZFile(file);
            while ((entry = sevenZFile.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                URI entryUri = UriUtil.createZipUri(file, entry.getName());
                entries.add(entryUri);
            }
            FileUtil.close((Closeable)sevenZFile);
        } else {
            ArchiveEntry entry;
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            CompressorInputStream cis = null;
            try {
                cis = new CompressorStreamFactory().createCompressorInputStream((InputStream)is);
            }
            catch (CompressorException entryUri) {
                // empty catch block
            }
            ArchiveInputStream in = new ArchiveStreamFactory().createArchiveInputStream((InputStream)(cis != null ? cis : is));
            while ((entry = in.getNextEntry()) != null) {
                if (entry.isDirectory() || !in.canReadEntryData(entry)) continue;
                URI entryUri = UriUtil.createZipUri(file, entry.getName());
                entries.add(entryUri);
            }
            FileUtil.close((Closeable)in);
            FileUtil.close((Closeable)cis);
            FileUtil.close(is);
        }
        return entries;
    }

    public static InputStream openFile(String uri_string) throws URISyntaxException, IOException {
        return CompressedFile.openFile(new URI(uri_string));
    }

    public static InputStream openFile(URI uri) throws IOException {
        return CompressedFile.openFile(UriUtil.getZipFilePath(uri), UriUtil.getZipEntryName(uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream openFile(String filePath, String compressedEntry) throws IOException {
        ArchiveEntry entry;
        String extractMsg = compressedEntry != null ? " extract '" + compressedEntry + "'" : "";
        Logger.debug("Open '" + filePath + "'" + extractMsg);
        File file = new File(filePath);
        if (!file.exists()) {
            throw new FileNotFoundException("Couldn't find file '" + filePath + "'.");
        }
        if (!file.canRead()) {
            throw new IOException("Couldn't access file '" + filePath + "'.");
        }
        if (compressedEntry == null) {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(filePath));
            CompressorInputStream cis = null;
            BufferedInputStream bcis = null;
            try {
                cis = new CompressorStreamFactory().createCompressorInputStream((InputStream)bis);
                bcis = new BufferedInputStream((InputStream)cis);
                return bcis;
            }
            catch (CompressorException e) {
                FileUtil.close(bcis);
                FileUtil.close((Closeable)cis);
                return bis;
            }
        }
        if (CompressedFile.isSevenZ(filePath)) {
            SevenZFile sevenZFile = new SevenZFile(new File(filePath));
            try {
                SevenZArchiveEntry entry2;
                while ((entry2 = sevenZFile.getNextEntry()) != null) {
                    if (!entry2.getName().equals(compressedEntry)) continue;
                    byte[] content = new byte[(int)entry2.getSize()];
                    sevenZFile.read(content);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(content);
                    return byteArrayInputStream;
                }
            }
            finally {
                FileUtil.close((Closeable)sevenZFile);
            }
            throw CompressedFile.createArchiveFNFE(filePath, compressedEntry);
        }
        InputStream bis = CompressedFile.openFile(filePath, null);
        ArchiveInputStream in = null;
        try {
            in = new ArchiveStreamFactory().createArchiveInputStream(bis);
        }
        catch (ArchiveException e) {
            FileUtil.close(bis);
            throw new IOException("Couldn't determine compressed file type for file '" + filePath + "' supposedly containing '" + compressedEntry + "'.", e);
        }
        while ((entry = in.getNextEntry()) != null) {
            if (!entry.getName().equals(compressedEntry)) continue;
            return in;
        }
        FileUtil.close((Closeable)in);
        throw CompressedFile.createArchiveFNFE(filePath, compressedEntry);
    }

    public static boolean isCompressed(URI uri) {
        String filepath = UriUtil.getFilePath(uri);
        return CompressedFile.hasCompressedFileExtension(filepath);
    }

    public static boolean isArchive(URI uri) {
        String filepath = UriUtil.getFilePath(uri);
        return CompressedFile.hasArchiveFileExtension(filepath);
    }

    public static boolean isCompressed(String filePath) {
        return CompressedFile.hasCompressedFileExtension(filePath);
    }

    public static boolean isArchive(String filePath) {
        return CompressedFile.hasArchiveFileExtension(filePath);
    }

    public static boolean isZip(String filePath) {
        return filePath.matches(".*\\.(?i:zip)");
    }

    public static boolean isTar(String filePath) {
        return filePath.matches("(?i).*\\.(tar|(tar\\.|t)(gz|bz2?|xz))");
    }

    public static boolean isGZip(String filePath) {
        return filePath.matches("(?i).*(?!\\.tar)\\.gz");
    }

    public static boolean isBZip(String filePath) {
        return filePath.matches("(?i).*(?!\\.tar)\\.bz2?");
    }

    public static boolean isXZ(String filePath) {
        return filePath.matches("(?i).*(?!\\.tar)\\.(xz)");
    }

    public static boolean isSevenZ(String filePath) {
        return filePath.matches("(?i).*(?!\\.tar)\\.(7z)");
    }

    public static String[] getArchiveExtensions() {
        return new String[]{"zip", "tgz", "tar.gz", "tar.bz", "tar.bz2", "tbz", "tbz2", "txz", "tar.xz", "7z"};
    }

    public static String[] getFileExtensions() {
        return new String[]{"gz", "bz", "bz2", "xz"};
    }

    public static String getExtension(String path) {
        if (CompressedFile.isCompressed(path)) {
            path = UriUtil.removeExtension(path);
        }
        String ext = FileUtil.getExtension(path);
        return ext;
    }

    public static boolean hasCompressedFileExtension(String filename) {
        return Arrays.asList(CompressedFile.getFileExtensions()).contains(FileUtil.getExtension(new File(filename)).toLowerCase());
    }

    public static boolean hasArchiveFileExtension(String filename) {
        for (String ext : CompressedFile.getArchiveExtensions()) {
            if (!filename.toLowerCase().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static String getTargetFileWithPath(URI uri) {
        String filepath = UriUtil.getFilePath(uri);
        if (CompressedFile.hasArchiveFileExtension(filepath)) {
            String entry = UriUtil.getZipEntryName(uri);
            return entry;
        }
        return filepath;
    }

    public static URI replaceTargetFileWithPath(URI uri, String location) {
        String filepath = UriUtil.getZipFilePath(uri);
        if (CompressedFile.hasArchiveFileExtension(filepath)) {
            return UriUtil.createZipUri(filepath, location);
        }
        return UriUtil.createFileUri(location);
    }

    public static URI replaceTargetFileName(URI uri, String filename) {
        String oldpath = UriUtil.getPath(CompressedFile.getTargetFileWithPath(uri));
        return CompressedFile.replaceTargetFileWithPath(uri, oldpath + filename);
    }

    public static String createLayerName(URI uri) {
        String filename = UriUtil.getFileName(uri);
        String layerName = UriUtil.getFileNameWithoutExtension(uri);
        if (CompressedFile.hasArchiveFileExtension(filename)) {
            layerName = UriUtil.getZipEntryName(uri) + " (" + filename + ")";
        } else if (CompressedFile.hasCompressedFileExtension(filename)) {
            layerName = layerName.substring(0, layerName.lastIndexOf(46)) + " (" + filename + ")";
        }
        return layerName;
    }

    private static FileNotFoundException createArchiveFNFE(String archive, String entry) {
        return new FileNotFoundException("Couldn't find entry '" + entry + "' in compressed file: " + archive);
    }
}

