/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.postgis;

import com.vividsolutions.jump.datastore.DataStoreLayer;
import com.vividsolutions.jump.datastore.FilterQuery;
import com.vividsolutions.jump.datastore.SpatialReferenceSystemID;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesDSMetadata;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesSQLBuilder;
import org.locationtech.jts.geom.Envelope;

public class PostgisSQLBuilder
extends SpatialDatabasesSQLBuilder {
    public PostgisSQLBuilder(SpatialDatabasesDSMetadata dbMetadata, SpatialReferenceSystemID defaultSRID, String[] colNames) {
        super(dbMetadata, defaultSRID, colNames);
    }

    @Override
    public String getSQL(FilterQuery query) {
        int limit;
        StringBuilder qs = new StringBuilder();
        qs.append("SELECT ");
        qs.append(this.getColumnListSpecifier(this.colNames, query.getGeometryAttributeName()));
        qs.append(" FROM ");
        qs.append("\"").append(query.getDatasetName().replaceAll("\\.", "\".\"")).append("\"");
        qs.append(" t WHERE ");
        qs.append(this.buildBoxFilter(query));
        String whereCond = query.getCondition();
        if (whereCond != null) {
            qs.append(" AND ");
            qs.append(whereCond);
        }
        if ((limit = query.getLimit()) != 0 && limit != Integer.MAX_VALUE) {
            qs.append(" LIMIT ").append(limit);
        }
        return qs.toString();
    }

    @Override
    public String getCheckSQL(DataStoreLayer dsLayer) {
        String s = "select * FROM %s %s LIMIT 0";
        String wc = dsLayer.getWhereClause();
        wc = wc != null && !wc.isEmpty() ? " WHERE " + wc : "";
        return String.format(s, dsLayer.getFullName(), wc);
    }

    @Override
    protected String getColumnListSpecifier(String[] colNames, String geomColName) {
        StringBuilder buf = new StringBuilder();
        buf.append("\"").append(geomColName).append("\"");
        for (String colName : colNames) {
            if (geomColName.equalsIgnoreCase(colName)) continue;
            buf.append(",\"").append(colName).append("\"");
        }
        return buf.toString();
    }

    @Override
    protected String buildBoxFilter(FilterQuery query) {
        Envelope env = query.getFilterGeometry().getEnvelopeInternal();
        StringBuilder buf = new StringBuilder();
        buf.append("\"").append(query.getGeometryAttributeName()).append("\" && ST_SetSRID('BOX3D(");
        buf.append(env.getMinX() + " " + env.getMinY() + "," + env.getMaxX() + " " + env.getMaxY());
        buf.append(")'::box3d,");
        String srid = this.getSRID(query.getSRSName());
        srid = srid == null ? "ST_SRID(\"" + query.getGeometryAttributeName() + "\")" : srid;
        buf.append(srid).append(")");
        return buf.toString();
    }
}

