/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.h2;

import com.vividsolutions.jump.datastore.DataStoreConnection;
import com.vividsolutions.jump.datastore.h2.H2DSConnection;
import com.vividsolutions.jump.datastore.spatialdatabases.AbstractSpatialDatabasesDSDriver;
import com.vividsolutions.jump.parameter.ParameterList;
import com.vividsolutions.jump.parameter.ParameterListSchema;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.io.File;
import java.sql.Connection;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class H2DataStoreDriver
extends AbstractSpatialDatabasesDSDriver {
    public static final String JDBC_CLASS = "org.h2.Driver";

    public H2DataStoreDriver() {
        this.driverName = "H2GIS";
        this.jdbcClass = JDBC_CLASS;
        this.urlPrefix = "jdbc:h2:";
        this.paramNames = new String[]{"DB file", "User", "Password"};
        this.paramClasses = new Class[]{File.class, String.class, String.class};
        this.schema = new ParameterListSchema(this.paramNames, this.paramClasses);
    }

    @Override
    public DataStoreConnection createConnection(ParameterList params) throws Exception {
        Connection conn = super.createJdbcConnection(params);
        return new H2DSConnection(conn);
    }

    @Override
    protected String createJdbcUrl(ParameterList params) {
        String database = params.getParameter("DB file").toString();
        database = database.replaceAll("(?i)\\.\\w+\\.db$", "");
        return this.getUrlPrefix() + database + ";IFEXISTS=TRUE;";
    }

    @Override
    public Icon getConnectedIcon() {
        return IconLoader.icon("h2_icon.png");
    }

    @Override
    public Icon getDisconnectedIcon() {
        return GUIUtil.toGrayScale((ImageIcon)this.getConnectedIcon());
    }
}

