/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.coordsys;

import com.vividsolutions.jump.io.CompressedFile;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class EsriProj {
    public static final Map<Integer, String> PROJMAP = new HashMap<Integer, String>();
    private static File projfile;
    private static String entryName;

    public static void setProjFile(File zipFileName, String zipEntryName) {
        projfile = zipFileName;
        entryName = zipEntryName;
    }

    public static void main(String[] args) throws IOException, URISyntaxException {
        System.out.println(EsriProj.findProj(2154));
        System.out.println(EsriProj.findProj(2154));
    }

    private static String[] tokenize(String line) {
        ArrayList<String> tokens = new ArrayList<String>(15);
        boolean quoted = false;
        StringBuilder sb = new StringBuilder();
        char[] array = line.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            char c = array[i];
            if (c == ',' && !quoted) {
                tokens.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            if (c == ' ' && !quoted) continue;
            if (c == '\"' && array[i + 1] != '\"') {
                quoted = !quoted;
                continue;
            }
            sb.append(c);
            if (c != '\"' || array[i + 1] == '\"') continue;
            ++i;
        }
        tokens.add(sb.toString());
        return tokens.toArray(new String[0]);
    }

    public static String findProj(int id) throws IOException {
        String proj = PROJMAP.get(id);
        if (proj == null) {
            InputStream is;
            BufferedReader br;
            Optional<String[]> tokens;
            if (projfile == null) {
                projfile = JUMPWorkbench.getInstance().getPlugInManager().findFileOrFolderInExtensionDirs("coord_ref_sys/pe_list_projcs_geogcs.zip");
                if (projfile == null) {
                    projfile = new File("lib/ext/coord_ref_sys/pe_list_projcs_geogcs.zip");
                }
                entryName = "pe_list_projcs_geogcs.csv";
            }
            if ((tokens = (br = new BufferedReader(new InputStreamReader(is = CompressedFile.openFile(projfile.getPath(), entryName)))).lines().map(EsriProj::tokenize).filter(it -> it[0].equals("" + id) || it[1].equals("" + id)).findFirst()).isPresent()) {
                String[] r = tokens.get();
                PROJMAP.put(id, r[4]);
                proj = r[4];
            }
        }
        if (proj != null) {
            Logger.info("Found Esri prj file for srid " + id);
        } else {
            Logger.warn("No Esri prj file found for srid " + id);
        }
        return proj;
    }
}

