/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.swing.listener;

import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.plugin.MenuItemShownListener;
import javax.swing.JMenuItem;

public class EnableCheckMenuItemShownListener
implements MenuItemShownListener {
    private EnableCheck enableCheck;
    private WorkbenchContext workbenchContext;
    private String enabledMessage;

    public EnableCheckMenuItemShownListener(WorkbenchContext workbenchContext, EnableCheck enableCheck) {
        this.workbenchContext = workbenchContext;
        this.enableCheck = enableCheck;
    }

    public EnableCheckMenuItemShownListener(WorkbenchContext workbenchContext, EnableCheck enableCheck, String enabledMessage) {
        this.workbenchContext = workbenchContext;
        this.enableCheck = enableCheck;
        this.enabledMessage = enabledMessage;
    }

    @Override
    public void menuItemShown(JMenuItem menuItem) {
        String errorMessage = null;
        try {
            errorMessage = this.enableCheck.check(menuItem);
        }
        catch (Exception e) {
            JUMPWorkbench workbench = this.workbenchContext.getWorkbench();
            WorkbenchFrame frame = workbench.getFrame();
            frame.log(menuItem.getText());
            frame.handleThrowable(e);
        }
        if (errorMessage != null) {
            menuItem.setEnabled(false);
            menuItem.setToolTipText(errorMessage);
        } else {
            menuItem.setEnabled(true);
            menuItem.setToolTipText(this.enabledMessage);
        }
    }
}

