/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.view;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.ui.util.ScreenScale;

public class SuperZoomPanTool
extends DragTool
implements MouseWheelListener {
    public static final double WHEEL_ZOOM_FACTOR = 1.15;
    public static final double ZOOM_IN_FACTOR = 2.0;
    public static Cursor CURSOR_ZOOM = SuperZoomPanTool.createCursor(IconLoader.icon("MagnifyCursor.gif").getImage());
    public static Cursor CURSOR_PAN = SuperZoomPanTool.createCursor(IconLoader.icon("Hand.gif").getImage());
    public static Cursor CURSOR_WHEEL = SuperZoomPanTool.createCursor(IconLoader.icon("MagnifyAreaCursor.gif").getImage());
    public static final int INDICATOR_MODE_SHAPE = 1;
    public static final int INDICATOR_MODE_IMAGE = 2;
    private boolean dragging = false;
    private Image origImage;
    private Image auxImage = null;
    private Point mousePosition = null;
    private boolean wheelMode = false;
    private int mouseWheelCount;
    private double scale = 1.0;
    private boolean mouseWheelListenerAdded = false;
    private boolean isAnimatingZoom = false;
    private Timer zoomPanClickTimer = null;
    private int indicatorMode = 2;
    private Point imagePosition = null;

    public SuperZoomPanTool(WorkbenchContext context) {
        super(context);
    }

    @Override
    public void activate(LayerViewPanel layerViewPanel) {
        super.activate(layerViewPanel);
        if (!this.mouseWheelListenerAdded) {
            this.getWorkbench().getContext().getLayerViewPanel().addMouseWheelListener(this);
            this.mouseWheelListenerAdded = true;
        }
    }

    @Override
    public void deactivate() {
        LayerViewPanel layerViewPanel;
        super.deactivate();
        if (this.mouseWheelListenerAdded && (layerViewPanel = this.getWorkbench().getContext().getLayerViewPanel()) != null) {
            layerViewPanel.removeMouseWheelListener(this);
            this.mouseWheelListenerAdded = false;
            this.wheelMode = false;
            this.getWorkbench().getContext().getLayerViewPanel().setCursor(CURSOR_ZOOM);
            this.scale = 1.0;
            this.mouseWheelCount = 0;
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.getWorkbench().getFrame().setStatusMessage(I18N.getInstance().get("org.openjump.core.ui.plugin.view.SuperZoomPanTool.wheelmode-message"));
        int nclicks = e.getWheelRotation();
        this.mouseWheelCount += nclicks;
        this.scale = this.mouseWheelCount == 0 ? 1.0 : (this.mouseWheelCount < 0 ? (double)Math.abs(this.mouseWheelCount) * 1.15 : 1.0 / ((double)this.mouseWheelCount * 1.15));
        this.wheelMode = true;
        this.getWorkbench().getContext().getLayerViewPanel().setCursor(CURSOR_WHEEL);
        this.getWorkbench().getFrame().setTimeMessage("1:" + (int)Math.floor(ScreenScale.getHorizontalMapScale(this.panel.getViewport()) / this.scale));
        try {
            this.redrawIndicator();
        }
        catch (Exception ex) {
            this.getPanel().getContext().handleThrowable(ex);
        }
    }

    @Override
    protected Shape getShape() throws Exception {
        Dimension onScreenRectangleDimension = null;
        this.setColor(Color.magenta);
        this.setStroke(new BasicStroke(1.0f));
        onScreenRectangleDimension = this.getPanel().getSize();
        onScreenRectangleDimension.setSize(onScreenRectangleDimension.getWidth() * 1.0 / this.scale, onScreenRectangleDimension.getHeight() * 1.0 / this.scale);
        if (this.wheelMode) {
            return new Rectangle((int)(this.mousePosition.getX() - onScreenRectangleDimension.getWidth() / 2.0), (int)(this.mousePosition.getY() - onScreenRectangleDimension.getHeight() / 2.0), (int)onScreenRectangleDimension.getWidth(), (int)onScreenRectangleDimension.getHeight());
        }
        return null;
    }

    @Override
    protected Image getImage() {
        if (this.wheelMode) {
            int textAreaWidth = 200;
            int textAreaHeight = 64;
            int textAreaOffsetX = 10;
            int textAreaOffsetY = 10;
            Dimension onScreenRectangleDimension = this.getPanel().getSize();
            onScreenRectangleDimension.setSize(onScreenRectangleDimension.getWidth() * 1.0 / this.scale, onScreenRectangleDimension.getHeight() * 1.0 / this.scale);
            int zoomAreaWidth = (int)onScreenRectangleDimension.getWidth();
            int zoomAreaHeight = (int)onScreenRectangleDimension.getHeight();
            int biWidth = zoomAreaWidth / 2 + textAreaOffsetX + textAreaWidth <= zoomAreaWidth ? zoomAreaWidth : zoomAreaWidth / 2 + textAreaOffsetX + textAreaWidth;
            int biHeight = zoomAreaHeight / 2 + textAreaOffsetY + textAreaHeight <= zoomAreaHeight ? zoomAreaHeight : zoomAreaHeight / 2 + textAreaOffsetY + textAreaHeight;
            BufferedImage image = new BufferedImage(biWidth, biHeight, 3);
            Graphics2D imageG2d = image.createGraphics();
            imageG2d.setColor(Color.yellow);
            imageG2d.fillRect(0, 0, zoomAreaWidth, zoomAreaHeight);
            imageG2d.setColor(Color.red);
            imageG2d.drawRect(0, 0, zoomAreaWidth - 1, zoomAreaHeight - 1);
            imageG2d.drawRect(1, 1, zoomAreaWidth - 3, zoomAreaHeight - 3);
            imageG2d.setColor(new Color(180, 200, 0));
            imageG2d.fillRect(zoomAreaWidth / 2 + textAreaOffsetX, zoomAreaHeight / 2 + textAreaOffsetY, textAreaWidth, textAreaHeight);
            imageG2d.setColor(Color.black);
            imageG2d.drawRect(zoomAreaWidth / 2 + textAreaOffsetX, zoomAreaHeight / 2 + textAreaOffsetY, textAreaWidth - 1, textAreaHeight - 1);
            imageG2d.setColor(Color.black);
            imageG2d.drawString(I18N.getInstance().get("org.openjump.core.ui.plugin.view.ZoomToScalePlugIn.scale") + " 1:" + (int)Math.floor(ScreenScale.getHorizontalMapScale(this.panel.getViewport()) / this.scale), zoomAreaWidth / 2 + textAreaOffsetX + 5, zoomAreaHeight / 2 + textAreaOffsetY + 14);
            int hintX = zoomAreaWidth / 2 + textAreaOffsetX + 5;
            int hintOffsetX = 0;
            int hintY = zoomAreaHeight / 2 + textAreaOffsetY + 32;
            FontMetrics fm = imageG2d.getFontMetrics();
            String hintString = I18N.getInstance().get("org.openjump.core.ui.plugin.view.SuperZoomPanTool.wheelmode-message");
            for (String word : hintString.split(" ")) {
                if (hintX + hintOffsetX + fm.stringWidth(word = word + " ") > hintX + textAreaWidth - 2) {
                    hintY += 14;
                    hintOffsetX = 0;
                }
                imageG2d.drawString(word, hintX + hintOffsetX, hintY);
                hintOffsetX += fm.stringWidth(word);
            }
            imageG2d.dispose();
            this.imagePosition = new Point((int)this.mousePosition.getX() - zoomAreaWidth / 2, (int)this.mousePosition.getY() - zoomAreaHeight / 2);
            return image;
        }
        this.imagePosition = null;
        return null;
    }

    @Override
    protected Point getImagePosition() {
        return this.imagePosition;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        try {
            this.mousePosition = e.getPoint();
            this.redrawIndicator();
        }
        catch (Exception ex) {
            this.getPanel().getContext().handleThrowable(ex);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        if (this.wheelMode) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                try {
                    this.getPanel().getViewport().zoomToViewPoint(new Point(e.getX(), e.getY()), this.scale);
                }
                catch (NoninvertibleTransformException ex) {
                    this.getPanel().getContext().handleThrowable(ex);
                }
            }
            this.wheelMode = false;
            this.scale = 1.0;
            this.mouseWheelCount = 0;
            try {
                this.redrawIndicator();
            }
            catch (Exception ex) {
                this.getPanel().getContext().handleThrowable(ex);
            }
            this.getWorkbench().getFrame().setStatusMessage("");
            this.getWorkbench().getFrame().setTimeMessage("");
        } else {
            double zoomFactor = SwingUtilities.isRightMouseButton(e) ? 0.5 : 2.0;
            try {
                this.zoomAt(e.getPoint(), zoomFactor);
            }
            catch (Throwable t) {
                this.getPanel().getContext().handleThrowable(t);
            }
        }
        if (this.zoomPanClickTimer != null) {
            this.zoomPanClickTimer.stop();
            this.zoomPanClickTimer = null;
        }
        this.getWorkbench().getContext().getLayerViewPanel().setCursor(CURSOR_ZOOM);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        if (this.wheelMode) {
            this.getWorkbench().getContext().getLayerViewPanel().setCursor(CURSOR_PAN);
        } else if (this.zoomPanClickTimer == null) {
            this.zoomPanClickTimer = new Timer(900, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SuperZoomPanTool.this.getWorkbench().getContext().getLayerViewPanel().setCursor(CURSOR_PAN);
                }
            });
            this.zoomPanClickTimer.setRepeats(false);
            this.zoomPanClickTimer.start();
        }
    }

    @Override
    public boolean isRightMouseButtonUsed() {
        return true;
    }

    @Override
    public Cursor getCursor() {
        if (this.wheelMode) {
            return CURSOR_WHEEL;
        }
        return CURSOR_ZOOM;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("BigHandZoom.gif");
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.view.SuperZoomPanTool.zoom-pan");
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        try {
            if (this.zoomPanClickTimer != null) {
                this.zoomPanClickTimer.stop();
                this.zoomPanClickTimer = null;
            }
            this.getWorkbench().getContext().getLayerViewPanel().setCursor(CURSOR_PAN);
            if (!this.dragging) {
                this.dragging = true;
                this.getPanel().getRenderingManager().setPaintingEnabled(false);
                this.cacheImage();
            }
            this.drawImage(e.getPoint());
            super.mouseDragged(e);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.dragging) {
            return;
        }
        this.getPanel().getRenderingManager().setPaintingEnabled(true);
        this.dragging = false;
        super.mouseReleased(e);
        if (this.wheelMode) {
            this.getWorkbench().getContext().getLayerViewPanel().setCursor(CURSOR_WHEEL);
            try {
                this.mousePosition = e.getPoint();
                this.redrawIndicator();
            }
            catch (Exception ex) {
                this.getPanel().getContext().handleThrowable(ex);
            }
        } else {
            if (this.zoomPanClickTimer != null) {
                this.zoomPanClickTimer.stop();
                this.zoomPanClickTimer = null;
            }
            this.getWorkbench().getContext().getLayerViewPanel().setCursor(CURSOR_ZOOM);
        }
    }

    @Override
    protected Shape getShape(Point2D source, Point2D destination) {
        return null;
    }

    @Override
    protected void gestureFinished() throws NoninvertibleTransformException {
        this.reportNothingToUndoYet();
        double xDisplacement = this.getModelDestination().x - this.getModelSource().x;
        double yDisplacement = this.getModelDestination().y - this.getModelSource().y;
        Envelope oldEnvelope = this.getPanel().getViewport().getEnvelopeInModelCoordinates();
        this.getPanel().getViewport().zoom(new Envelope(oldEnvelope.getMinX() - xDisplacement, oldEnvelope.getMaxX() - xDisplacement, oldEnvelope.getMinY() - yDisplacement, oldEnvelope.getMaxY() - yDisplacement));
    }

    public Image createImageIfNeeded(Image currImage) {
        if (currImage == null || currImage.getHeight(null) != this.getPanel().getHeight() || currImage.getWidth(null) != this.getPanel().getWidth()) {
            Graphics2D g = (Graphics2D)this.getPanel().getGraphics();
            BufferedImage img = g.getDeviceConfiguration().createCompatibleImage(this.getPanel().getWidth(), this.getPanel().getHeight(), 1);
            return img;
        }
        return currImage;
    }

    public void cacheImage() {
        this.origImage = this.createImageIfNeeded(this.origImage);
        this.getPanel().paint(this.origImage.getGraphics());
    }

    private void drawImage(Point p) throws NoninvertibleTransformException {
        double dx = p.getX() - this.getViewSource().getX();
        double dy = p.getY() - this.getViewSource().getY();
        this.auxImage = this.createImageIfNeeded(this.auxImage);
        this.auxImage.getGraphics().setColor(Color.WHITE);
        this.auxImage.getGraphics().fillRect(0, 0, this.auxImage.getWidth(this.getPanel()), this.auxImage.getHeight(this.getPanel()));
        this.auxImage.getGraphics().drawImage(this.origImage, (int)dx, (int)dy, this.getPanel());
        this.getPanel().getGraphics().drawImage(this.auxImage, 0, 0, this.getPanel());
    }

    public boolean setAnimatingZoom(boolean animating) {
        boolean previousValue = this.isAnimatingZoom;
        this.isAnimatingZoom = animating;
        return previousValue;
    }

    public boolean getAnimatingZoom() {
        return this.isAnimatingZoom;
    }

    private void zoomAt(Point2D p, double zoomFactor) throws NoninvertibleTransformException {
        this.zoomAt(p, zoomFactor, this.getAnimatingZoom());
    }

    protected void zoomAt(Point2D p, double zoomFactor, boolean animatingZoom) throws NoninvertibleTransformException {
        Viewport vp = this.getPanel().getViewport();
        Point2D zoomPoint = vp.toModelPoint(p);
        Envelope modelEnvelope = vp.getEnvelopeInModelCoordinates();
        Coordinate centre = modelEnvelope.centre();
        double width = modelEnvelope.getWidth();
        double height = modelEnvelope.getHeight();
        double dx = (zoomPoint.getX() - centre.x) / zoomFactor;
        double dy = (zoomPoint.getY() - centre.y) / zoomFactor;
        Envelope zoomModelEnvelope = new Envelope(zoomPoint.getX() - 0.5 * (width / zoomFactor) - dx, zoomPoint.getX() + 0.5 * (width / zoomFactor) - dx, zoomPoint.getY() - 0.5 * (height / zoomFactor) - dy, zoomPoint.getY() + 0.5 * (height / zoomFactor) - dy);
        vp.zoom(zoomModelEnvelope);
    }

    public void redrawIndicator() {
        try {
            switch (this.getIndicatorMode()) {
                case 1: {
                    this.redrawShape();
                    break;
                }
                case 2: {
                    this.redrawImage();
                    break;
                }
                default: {
                    Logger.warn("Unknown indicatorMode " + this.getIndicatorMode() + "!");
                    break;
                }
            }
        }
        catch (Exception e) {
            Logger.error("Unable to redraw the visual indicator!", e);
        }
    }

    public int getIndicatorMode() {
        return this.indicatorMode;
    }

    public void setIndicatorMode(int indicatorMode) {
        if (indicatorMode == 1 || indicatorMode == 2) {
            this.indicatorMode = indicatorMode;
        }
    }
}

