/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.view;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openjump.core.ui.plugin.view.EasyButtonsPlugin;

public class EasyPanel
extends JPanel {
    private static final String EZ_LIST_KEY = EasyPanel.class.getName() + "EZ_LIST_KEY";
    private String UNUSED_BUTTON_NAME = I18N.getInstance().get("org.openjump.core.ui.plugin.view.EasyPanel.Right-Click-to-Assign-Button-F");
    private String UNSET_BUTTON = I18N.getInstance().get("org.openjump.core.ui.plugin.view.EasyPanel.unset-assignment");
    private String BUTTON_EMPTY = I18N.getInstance().get("org.openjump.core.ui.plugin.view.EasyPanel.not-assigned");
    private JPanel buttonPanel = new JPanel();
    private GridLayout gridLayout1 = new GridLayout();
    private final int MAX_BUTTONS = 12;
    private CustomButton[] buttons = new CustomButton[12];
    private CustomButton activeButton = null;
    private JPopupMenu masterPopup = new JPopupMenu();
    private ArrayList<JMenuItem> menuItemList = new ArrayList();
    private ArrayList<String> menuNameList = new ArrayList();
    private HashMap<Integer, String> persistentButtonMap;
    private ToolboxDialog toolbox;

    public EasyPanel(ToolboxDialog toolbox) {
        Blackboard blackboard = PersistentBlackboardPlugIn.get(toolbox.getContext());
        Object o = blackboard.get(EZ_LIST_KEY);
        if (o instanceof List) {
            List list = (List)o;
            this.persistentButtonMap = new HashMap();
            for (int i = 0; i < list.size(); ++i) {
                this.persistentButtonMap.put(i, (String)list.get(i));
            }
            blackboard.put(EZ_LIST_KEY, this.persistentButtonMap);
        } else if (o instanceof HashMap) {
            this.persistentButtonMap = (HashMap)o;
        } else {
            this.persistentButtonMap = new HashMap();
            blackboard.put(EZ_LIST_KEY, this.persistentButtonMap);
        }
        this.toolbox = toolbox;
        this.add(this.buttonPanel);
        this.buttonPanel.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(12);
        this.addButtons();
        this.populatePopupMenu(toolbox.getContext());
        this.recallButtonAssignments();
        toolbox.pack();
    }

    private void addButtons() {
        GridBagConstraints gbc = new GridBagConstraints();
        for (int i = 0; i < 12; ++i) {
            this.buttons[i] = new CustomButton(i);
            this.buttonPanel.add((Component)this.buttons[i], gbc);
            PopupListener popupListener = new PopupListener(this.masterPopup);
            this.buttons[i].addMouseListener(popupListener);
            this.buttons[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EasyPanel.this.buttonActionPerformed(e);
                }
            });
        }
    }

    private void recallButtonAssignments() {
        Iterator<Map.Entry<Integer, String>> i = this.persistentButtonMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Integer, String> e = i.next();
            int buttonNumber = e.getKey();
            String name = e.getValue();
            int index = this.menuNameList.indexOf(name);
            if (index > -1) {
                JMenuItem jMenuItemToSet = this.menuItemList.get(index);
                this.buttons[buttonNumber].setMenuItem(jMenuItemToSet);
                String buttonName = this.buttons[buttonNumber].getText();
                this.buttons[buttonNumber].setText(buttonName);
                continue;
            }
            i.remove();
        }
    }

    private void buttonActionPerformed(ActionEvent e) {
        String name = e.getActionCommand();
        CustomButton button = null;
        for (CustomButton b : this.buttons) {
            if (!b.getText().equalsIgnoreCase(name)) continue;
            button = b;
            break;
        }
        if (button != null) {
            button.executeMenuItem();
        }
    }

    private void populatePopupMenu(WorkbenchContext context) {
        JMenuItem unsetter = new JMenuItem(this.UNSET_BUTTON);
        unsetter.setIcon(IconLoader.icon("famfam/cross.png"));
        unsetter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EasyPanel.this.menuItemActionPerformed(e);
            }
        });
        this.masterPopup.add(unsetter);
        JMenuBar jMenuBar = context.getWorkbench().getFrame().getJMenuBar();
        int menuCount = jMenuBar.getMenuCount();
        for (int i = 0; i < menuCount; ++i) {
            JMenu jMenuRef = jMenuBar.getMenu(i);
            this.masterPopup.add(this.populateMenu(jMenuRef));
        }
        JPopupMenu layerview_popup = LayerViewPanel.popupMenu();
        TitledPopupMenu layername_popup = context.getWorkbench().getFrame().getLayerNamePopupMenu();
        TitledPopupMenu layernamecategory_popup = context.getWorkbench().getFrame().getCategoryPopupMenu();
        this.masterPopup.add(this.populatePopupMenu(layerview_popup, new JMenu(MenuNames.LAYERVIEWPANEL_POPUP)));
        this.masterPopup.add(this.populatePopupMenu(layernamecategory_popup, new JMenu(MenuNames.LAYERNAMEPANEL_CATEGORY_POPUP)));
        this.masterPopup.add(this.populatePopupMenu(layername_popup, new JMenu(MenuNames.LAYERNAMEPANEL_LAYER_POPUP)));
    }

    private JMenuItem populatePopupMenu(JPopupMenu jPopupMenu, JMenu rightClickMenu) {
        int itemCount = jPopupMenu.getComponentCount();
        for (int j = 0; j < itemCount; ++j) {
            if (jPopupMenu.getComponent(j) instanceof JMenu) {
                rightClickMenu.add(this.populateMenu((JMenu)jPopupMenu.getComponent(j)));
                continue;
            }
            if (jPopupMenu.getComponent(j) instanceof JMenuItem) {
                JMenuItem jMenuItemRef = (JMenuItem)jPopupMenu.getComponent(j);
                CustomJMenuItem jMenuItem = new CustomJMenuItem(jMenuItemRef);
                jMenuItem.setIcon(jMenuItemRef.getIcon());
                this.menuNameList.add(jMenuItem.getText());
                this.menuItemList.add(jMenuItemRef);
                rightClickMenu.add(jMenuItem);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        EasyPanel.this.menuItemActionPerformed(e);
                    }
                });
                continue;
            }
            if (!(jPopupMenu.getComponent(j) instanceof JSeparator)) continue;
            rightClickMenu.insertSeparator(j);
        }
        return rightClickMenu;
    }

    private JMenuItem populateMenu(JMenu jMenuRef) {
        JMenu jMenu = new JMenu(jMenuRef.getText());
        int itemCount = jMenuRef.getItemCount();
        for (int j = 0; j < itemCount; ++j) {
            JMenuItem jMenuItemRef = jMenuRef.getItem(j);
            if (jMenuItemRef instanceof JMenu) {
                jMenu.add(this.populateMenu((JMenu)jMenuItemRef));
                continue;
            }
            if (jMenuItemRef instanceof JMenuItem) {
                CustomJMenuItem jMenuItem = new CustomJMenuItem(jMenuItemRef);
                jMenuItem.setIcon(jMenuItemRef.getIcon());
                this.menuNameList.add(jMenuItem.getText());
                this.menuItemList.add(jMenuItemRef);
                jMenu.add(jMenuItem);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        EasyPanel.this.menuItemActionPerformed(e);
                    }
                });
                continue;
            }
            if (!(jMenuItemRef instanceof JSeparator)) continue;
            jMenu.insertSeparator(j);
        }
        return jMenu;
    }

    private void menuItemActionPerformed(ActionEvent e) {
        Object source = e.getSource();
        String name = e.getActionCommand();
        if (this.activeButton != null) {
            if (source instanceof JMenuItem && ((JMenuItem)source).getText().equals(this.UNSET_BUTTON)) {
                this.activeButton.unsetMenuItem();
            }
            if (source instanceof CustomJMenuItem) {
                CustomJMenuItem jMenuItem = (CustomJMenuItem)source;
                JMenuItem referencedJMenuItem = jMenuItem.getReferencedJMenuItem();
                this.activeButton.setMenuItem(referencedJMenuItem);
            }
        }
        this.toolbox.pack();
    }

    class CustomJMenuItem
    extends JMenuItem {
        private JMenuItem referencedJMenuItem;

        public CustomJMenuItem(JMenuItem jMenuItem) {
            super(jMenuItem.getText());
            this.referencedJMenuItem = null;
            this.referencedJMenuItem = jMenuItem;
        }

        public JMenuItem getReferencedJMenuItem() {
            return this.referencedJMenuItem;
        }
    }

    class CustomButton
    extends JButton {
        private String default_name = "";
        private JMenuItem jMenuItem = null;
        private int buttonNumber = 0;

        public CustomButton(int buttonNumber) {
            this.default_name = EasyPanel.this.UNUSED_BUTTON_NAME + (buttonNumber + 1);
            this.buttonNumber = buttonNumber;
            this.setText(this.default_name);
            this.setToolTipText("F" + (buttonNumber + 1));
            EasyPanel.this.toolbox.getContext().getWorkbench().getFrame().addKeyboardShortcut(KeyStroke.getKeyStroke(112 + buttonNumber, 0), new PlugIn(){

                @Override
                public boolean execute(PlugInContext context) throws Exception {
                    CustomButton.this.executeMenuItem();
                    return false;
                }

                @Override
                public String getName() {
                    return EasyButtonsPlugin.TOOLBOX_NAME + " - " + (CustomButton.this.jMenuItem != null ? CustomButton.this.jMenuItem.getText() : EasyPanel.this.BUTTON_EMPTY);
                }

                @Override
                public void initialize(PlugInContext context) throws Exception {
                }
            });
        }

        public void unsetMenuItem() {
            this.jMenuItem = null;
            this.setText(this.default_name);
            EasyPanel.this.persistentButtonMap.remove(this.buttonNumber);
        }

        public void setMenuItem(JMenuItem jMenuItemToSet) {
            this.jMenuItem = jMenuItemToSet;
            this.setText(this.jMenuItem.getText() + " " + this.getToolTipText());
            EasyPanel.this.persistentButtonMap.put(this.buttonNumber, this.jMenuItem.getText());
        }

        public void executeMenuItem() {
            if (this.jMenuItem != null) {
                Component component = ((JPopupMenu)this.jMenuItem.getParent()).getInvoker();
                if (component instanceof JMenu) {
                    MenuListener[] menuListeners;
                    JMenu jMenu = (JMenu)component;
                    for (MenuListener listener : menuListeners = jMenu.getMenuListeners()) {
                        if (!(listener instanceof FeatureInstaller.JumpMenuListener)) continue;
                        listener.menuSelected(null);
                    }
                } else {
                    PopupMenuListener[] listeners;
                    JPopupMenu popupMenu = (JPopupMenu)this.jMenuItem.getParent();
                    for (PopupMenuListener listener : listeners = (PopupMenuListener[])popupMenu.getListeners(PopupMenuListener.class)) {
                        listener.popupMenuWillBecomeVisible(new PopupMenuEvent(popupMenu));
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (CustomButton.this.jMenuItem.isEnabled()) {
                            CustomButton.this.jMenuItem.doClick();
                        } else {
                            String toolTip = CustomButton.this.jMenuItem.getToolTipText();
                            CustomButton.this.setToolTip(toolTip);
                        }
                    }
                });
            }
        }

        public void setButtonEnabled(boolean enabled) {
            this.setEnabled(enabled);
        }

        private void setToolTip(String toolTip) {
            this.setToolTipText(toolTip);
            EasyPanel.this.toolbox.getContext().getWorkbench().getFrame().warnUser(toolTip);
        }
    }

    class PopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                Component component = e.getComponent();
                this.popup.show(component, e.getX(), e.getY());
                if (component instanceof CustomButton) {
                    EasyPanel.this.activeButton = (CustomButton)component;
                }
            }
        }
    }
}

